#!/usr/bin/env python
# coding: utf-8

# ANTAB per Source generator
## by Cristina Romero Cañizales (Feb 2025) -uses parts of Jongho Park's script eht_apriori_cal.py-

print('=====')
print('This script will take ANTAB tables from the antab/processed/ folder and create new ones')
print('containing information for the antennas in the track and for the source you specify below.')

import numpy as np
import pandas as pd
import os

#
if not os.path.exists('antab/customized'):
    os.makedirs('antab/customized/')
newANTAB_path = 'antab/customized/'

band_name = ['b1','b2','b3','b4']

tsa_dict = pd.read_csv('ancillary/tsa.csv',sep='\t',engine='python')
tsa_dict.Antenna = tsa_dict.Antenna.apply(eval)

all_ants = tsa_dict.Antenna.explode().unique()
all_ants = [i.upper() for i in all_ants]

print('Check valid track and source names in ancillary/tsa.csv file.')
print('=====')
tr = input('Enter track name: ').lower()
sou = input('Enter source name: ').upper()
print('=====')

mask_TS = (tsa_dict.Track == tr) & (tsa_dict.Source==sou)
ant_list = tsa_dict.loc[mask_TS, 'Antenna'].iloc[0]
ant_list = sorted([i.upper() for i in ant_list])

for band in band_name:
    #
    antab_file = 'antab/processed/'+tr+'_'+band+'_proc.AN'
    new_antab = newANTAB_path+tr+'_'+band+'_'+sou+'_proc.AN'
    #
    outfi = open(new_antab,'w')
    #
    with open(antab_file, 'r') as infi:
        for line in infi:
            if 'GAIN' in line:
                if line.split()[1] in ant_list:
                    outfi.write(line)
    outfi.write('\n')
    #
    with open(antab_file, 'r') as infi:
        for line in infi:
            if 'TSYS' in line:
                if line.split()[1] in ant_list:
                    outfi.write(line)
                    if line.split()[1] == 'AA':
                        for line in infi:
                            outfi.write(line)
                            if '/' in line:
                                break
                    for line in infi:
                        outfi.write(line)
                        if '/' in line:
                            outfi.write('\n')
                            break
    #                            
    outfi.close()
    print('The file '+new_antab+' has been created.')
