/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.fits.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jsky.image.fits.codec.FITSImage;
import jsky.image.gui.MainImageDisplay;
import jsky.util.gui.BusyWin;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.SwingUtil;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Header;
import nom.tam.fits.ImageHDU;
import uk.ac.starlink.table.gui.NumericCellRenderer;

public class FITSHDUChooser
extends JPanel {
    private MainImageDisplay _imageDisplay;
    private JTable _table;
    private FITSImage _fitsImage;
    private static final String[] COLUMN_NAMES = new String[]{"HDU", "Type", "EXTNAME", "NAXIS", "NAXIS1", "NAXIS2", "NAXIS3", "CRPIX1", "CRPIX2"};
    private static final int NUM_COLS = COLUMN_NAMES.length;
    private static final int HDU_INDEX = 0;
    private static final int TYPE_INDEX = 1;
    private static final int EXTNAME_INDEX = 2;
    private static final int NAXIS_INDEX = 3;
    private static final int NAXIS1_INDEX = 4;
    private static final int NAXIS2_INDEX = 5;
    private static final int NAXIS3_INDEX = 6;
    private static final int CRPIX1_INDEX = 7;
    private static final int CRPIX2_INDEX = 8;
    private static final Class[] COLUMN_CLASSES = new Class[]{Integer.class, String.class, String.class, Integer.class, Integer.class, Integer.class, Integer.class, Double.class, Double.class};
    private static final int[] COLUMN_WIDTHS = new int[]{50, 70, 200, 60, 60, 60, 60, 70, 70};
    private Object[][] _tableData;
    private JButton _openButton;
    private JButton _deleteButton;
    private JCheckBox _showHiddenCheckBox;

    public FITSHDUChooser(MainImageDisplay imageDisplay, FITSImage fitsImage) {
        this._imageDisplay = imageDisplay;
        this.setLayout(new BorderLayout());
        this.add((Component)this._makeTablePane(), "Center");
        this.add((Component)this._makeButtonPanel(), "South");
        this.updateDisplay(fitsImage);
    }

    private JScrollPane _makeTablePane() {
        this._table = new JTable();
        this._table.setCellSelectionEnabled(false);
        this._table.setAutoResizeMode(4);
        this._table.setRowSelectionAllowed(true);
        this._table.setColumnSelectionAllowed(false);
        this._table.setGridColor(Color.gray);
        this._table.setRowHeight(20);
        this._table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Point pt = evt.getPoint();
                int row = FITSHDUChooser.this._table.rowAtPoint(pt);
                if (evt.getClickCount() == 2) {
                    FITSHDUChooser.this._open(row);
                }
            }
        });
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FITSHDUChooser.this._updateEnabledStates();
            }
        });
        this._table.setPreferredScrollableViewportSize(new Dimension(450, 90));
        return new JScrollPane(this._table);
    }

    private void _updateEnabledStates() {
        int[] rows = this._table.getSelectedRows();
        int selectedRow = this._table.getSelectedRow();
        this._openButton.setEnabled(rows.length == 1);
        this._deleteButton.setEnabled(rows.length > 0 && selectedRow != 0);
        TableModel model = this._table.getModel();
        for (int rowIndex : rows) {
            String type = (String)model.getValueAt(rowIndex, 1);
            if (!"binary".equalsIgnoreCase(type)) {
                this._deleteButton.setEnabled(false);
                break;
            }
            String name = (String)model.getValueAt(rowIndex, 2);
            if (!"CATINFO".equalsIgnoreCase(name)) continue;
            this._deleteButton.setEnabled(false);
            break;
        }
    }

    protected boolean _isHidden(BasicHDU hdu) {
        if (this._showHiddenCheckBox.isSelected()) {
            return false;
        }
        Header header = hdu.getHeader();
        String name = header.getStringValue("EXTNAME");
        return name != null && (name.equals("CATINFO") || name.startsWith("VOTMETA") || name.equals(".GRAPHICS"));
    }

    public void updateDisplay(FITSImage fitsImage) {
        this._fitsImage = fitsImage;
        int numRows = this._fitsImage.getNumHDUs();
        this._tableData = new Object[numRows][NUM_COLS];
        int count = 0;
        for (int row = 0; row < numRows; ++row) {
            BasicHDU hdu = this._fitsImage.getHDU(row);
            if (this._isHidden(hdu)) continue;
            Header header = hdu.getHeader();
            this._tableData[count][0] = row;
            this._tableData[count][1] = this._getHDUType(hdu);
            this._tableData[count][2] = header.getStringValue("EXTNAME");
            this._tableData[count][3] = header.getIntValue("NAXIS");
            this._tableData[count][4] = header.getIntValue("NAXIS1");
            this._tableData[count][5] = header.getIntValue("NAXIS2");
            this._tableData[count][6] = header.getIntValue("NAXIS3");
            this._tableData[count][7] = header.getDoubleValue("CRPIX1");
            this._tableData[count][8] = header.getDoubleValue("CRPIX2");
            ++count;
        }
        final int rowCount = count;
        this._table.setModel(new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return NUM_COLS;
            }

            @Override
            public String getColumnName(int i) {
                return COLUMN_NAMES[i];
            }

            public Class getColumnClass(int i) {
                return COLUMN_CLASSES[i];
            }

            @Override
            public int getRowCount() {
                return rowCount;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return FITSHDUChooser.this._tableData[row][col];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        for (int i = 0; i < NUM_COLS; ++i) {
            TableColumn col = this._table.getColumn(COLUMN_NAMES[i]);
            col.setPreferredWidth(COLUMN_WIDTHS[i]);
            col.setCellRenderer((TableCellRenderer)new NumericCellRenderer(COLUMN_CLASSES[i]));
        }
        this._table.getSelectionModel().clearSelection();
        this._deleteButton.setEnabled(false);
    }

    private String _getHDUType(BasicHDU hdu) {
        if (hdu instanceof ImageHDU) {
            return "image";
        }
        if (hdu instanceof BinaryTableHDU) {
            return "binary";
        }
        if (hdu instanceof AsciiTableHDU) {
            return "ascii";
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _open(int rowIndex) {
        if (rowIndex != -1) {
            BusyWin.setBusy((boolean)true);
            try {
                TableModel model = this._table.getModel();
                int hdu = (Integer)model.getValueAt(rowIndex, 0);
                String type = (String)model.getValueAt(rowIndex, 1);
                int naxis = (Integer)model.getValueAt(rowIndex, 3);
                if (type.equals("image")) {
                    if (naxis >= 2) {
                        this.selectImage(hdu);
                    }
                } else if (type.equals("binary") || type.equals("ascii")) {
                    this._imageDisplay.displayFITSTable(hdu);
                }
            }
            finally {
                BusyWin.setBusy((boolean)false);
            }
        }
    }

    public void selectImage(int hdu) {
        try {
            this._fitsImage.setHDU(hdu);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't select FIT HDU# " + hdu + ": " + e.getMessage());
        }
        this._imageDisplay.setImage(PlanarImage.wrapRenderedImage((RenderedImage)this._fitsImage));
    }

    public JTable getTable() {
        return this._table;
    }

    private JPanel _makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        this._openButton = new JButton("Open");
        this._openButton.setToolTipText("Open and display the selected FITS HDU (header/data unit)");
        panel.add(this._openButton);
        this._openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FITSHDUChooser.this._open();
            }
        });
        this._deleteButton = new JButton("Delete");
        this._deleteButton.setToolTipText("Delete the selected FITS HDU");
        panel.add(this._deleteButton);
        this._deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FITSHDUChooser.this._delete();
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.setToolTipText("Hide this window");
        panel.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FITSHDUChooser.this._close();
            }
        });
        this._showHiddenCheckBox = new JCheckBox("Show hidden HDUs");
        this._showHiddenCheckBox.setToolTipText("Show or hide generated FITS HDUs used to store additional VOTable or catalog information");
        this._showHiddenCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FITSHDUChooser.this.updateDisplay(FITSHDUChooser.this._fitsImage);
            }
        });
        this._showHiddenCheckBox.setMargin(new Insets(2, 10, 2, 1));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)this._showHiddenCheckBox, "West");
        buttonPanel.add((Component)panel, "East");
        return buttonPanel;
    }

    private void _open() {
        this._open(this._table.getSelectedRow());
    }

    private void _delete() {
        int[] hdus = this._table.getSelectedRows();
        for (int i = hdus.length - 1; i >= 0; --i) {
            int hdu = hdus[i];
            if (hdu <= 0 || hdu >= this._fitsImage.getNumHDUs()) continue;
            try {
                this._imageDisplay.deleteFITSTable(hdu);
            }
            catch (Exception e) {
                DialogUtil.error((Exception)e);
                return;
            }
            this.updateDisplay(this._fitsImage);
        }
    }

    private void _close() {
        JFrame parent = SwingUtil.getFrame((Component)this);
        if (parent != null) {
            parent.setVisible(false);
        }
    }

    public void clear() {
        this._table.setModel(new DefaultTableModel());
        this._fitsImage = null;
    }

    public void setShow(boolean show) {
        JFrame parent = SwingUtil.getFrame((Component)this);
        if (parent != null) {
            parent.setVisible(show);
            if (show) {
                int hdu = this._fitsImage.getCurrentHDUIndex();
                this._table.getSelectionModel().setSelectionInterval(hdu, hdu);
                SwingUtil.showFrame((JFrame)parent);
            }
        }
    }
}

