/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.cdb.rest;

import alma.acs.cdb.rest.CDBConnector;
import alma.acs.cdb.rest.model.CDBEntry;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CDBAPIController {
    @GetMapping(value={"/read/**"})
    public ResponseEntity<HashMap<String, Object>> read(HttpServletRequest request) {
        String requestURL = request.getRequestURL().toString();
        String[] requestURLParts = requestURL.split("read/");
        if (requestURLParts.length < 2 || requestURLParts[1] == "") {
            HashMap<String, String> empty = new HashMap<String, String>();
            empty.put("error", "Empty CURL");
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body(empty);
        }
        String curl = requestURLParts[1];
        HashMap<String, Object> cdbMap = CDBConnector.readCurlInCDB(curl, "corbaloc::127.0.1.1:3012/CDB");
        if (cdbMap == null || cdbMap.isEmpty()) {
            HashMap<String, String> cdbEmptyMap = new HashMap<String, String>();
            cdbEmptyMap.put("error", "Record not found");
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).contentType(MediaType.APPLICATION_JSON).body(cdbEmptyMap);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).contentType(MediaType.APPLICATION_JSON).body(cdbMap);
    }

    @GetMapping(value={"/list/**"})
    public ResponseEntity<HashMap<String, Object>> list(HttpServletRequest request) {
        String requestURL = request.getRequestURL().toString();
        String[] requestURLParts = requestURL.split("list/");
        if (requestURLParts.length < 2 || requestURLParts[1] == "") {
            HashMap<String, String> emptyCurl = new HashMap<String, String>();
            emptyCurl.put("error", "Empty CURL");
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body(emptyCurl);
        }
        String curl = requestURLParts[1];
        String[] listNodes = CDBConnector.listNodes(curl, "corbaloc::127.0.1.1:3012/CDB");
        HashMap<String, String[]> response = new HashMap<String, String[]>();
        response.put("list", listNodes);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).contentType(MediaType.APPLICATION_JSON).body(response);
    }

    @PostMapping(value={"/write"})
    public ResponseEntity<HashMap<String, String>> write(@RequestBody CDBEntry cdbEntry) {
        if (cdbEntry.curl == "") {
            HashMap<String, String> curlEmptyMap = new HashMap<String, String>();
            curlEmptyMap.put("error", "Empty CURL");
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body(curlEmptyMap);
        }
        if (cdbEntry.properties.isEmpty()) {
            HashMap<String, String> propertiesEmptyMap = new HashMap<String, String>();
            propertiesEmptyMap.put("error", "no properties");
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body(propertiesEmptyMap);
        }
        HashMap<String, String> response = CDBConnector.writeCDBEntry(cdbEntry, "corbaloc::127.0.1.1:3012/CDB");
        if (response == null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body(response);
        }
        boolean success = !response.keySet().contains("error");
        ResponseEntity result = null;
        if (success) {
            String typeOfWrite = response.get("INFO");
            if (typeOfWrite == "write") {
                result = ResponseEntity.status((HttpStatus)HttpStatus.OK).contentType(MediaType.APPLICATION_JSON).body(response);
            } else if (typeOfWrite == "add") {
                result = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).contentType(MediaType.APPLICATION_JSON).body(response);
            }
        } else {
            result = response.get("error") == "Record is read only" ? ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).contentType(MediaType.APPLICATION_JSON).body(response) : ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body(response);
        }
        if (result == null) {
            result = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body(response);
        }
        return result;
    }

    @DeleteMapping(value={"/delete/**"})
    public ResponseEntity<HashMap<String, String>> delete(HttpServletRequest request) {
        String requestURL = request.getRequestURL().toString();
        String[] requestURLParts = requestURL.split("delete/");
        if (requestURLParts.length < 2 || requestURLParts[1] == "") {
            HashMap<String, String> emptyCurl = new HashMap<String, String>();
            emptyCurl.put("error", "Empty CURL");
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body(emptyCurl);
        }
        String curl = requestURLParts[1];
        HashMap<String, String> response = CDBConnector.deleteNode(curl, "corbaloc::127.0.1.1:3012/CDB");
        boolean success = !response.keySet().contains("error");
        ResponseEntity result = null;
        if (success) {
            result = ResponseEntity.status((HttpStatus)HttpStatus.OK).contentType(MediaType.APPLICATION_JSON).body(response);
        } else if (response.get("error") == "Record does not exist") {
            result = ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).contentType(MediaType.APPLICATION_JSON).body(response);
        } else if (response.get("error") == "Record is read only") {
            result = ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).contentType(MediaType.APPLICATION_JSON).body(response);
        }
        if (result == null) {
            result = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body(response);
        }
        return result;
    }
}

