/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.cdb.jdal;

import com.cosylab.cdb.jdal.JNDIContext;
import com.cosylab.cdb.jdal.XMLHandler;
import com.cosylab.cdb.jdal.XMLTreeNode;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JNDIXMLContext
extends JNDIContext {
    private static boolean parserInited = false;
    private static SAXParserFactory factory;
    private static SAXParser saxParser;
    private XMLTreeNode node;
    private Hashtable nestedElements;

    protected static void initParser() {
        if (parserInited) {
            return;
        }
        factory = SAXParserFactory.newInstance();
        try {
            saxParser = factory.newSAXParser();
            parserInited = true;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public JNDIXMLContext(String name, String elements, String xml, Logger logger) {
        super(name, elements, logger);
        JNDIXMLContext.initParser();
        XMLHandler xmlSolver = new XMLHandler(false, logger);
        try {
            saxParser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)xmlSolver);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (xmlSolver.m_errorString != null) {
            String info = "XML parser error: " + xmlSolver.m_errorString;
            System.err.println(info);
        }
        this.node = xmlSolver.m_rootNode;
    }

    public JNDIXMLContext(XMLTreeNode node, Logger logger) {
        super(logger);
        this.node = node;
    }

    @Override
    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            JNDIXMLNodesEnumeration enumeration = new JNDIXMLNodesEnumeration(this.node);
            return enumeration;
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " unable to list");
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        String nameToLookup = name.toString();
        int slashIndex = nameToLookup.indexOf(47);
        if (slashIndex != -1) {
            String nodeName = nameToLookup.substring(0, slashIndex);
            if (this.node.getNodesMap().containsKey(nodeName)) {
                XMLTreeNode nextNode = this.node.getNodesMap().get(nodeName);
                return new JNDIXMLContext(nextNode, this.logger).lookup(nameToLookup.substring(slashIndex + 1));
            }
        }
        if (this.nestedElements != null && this.nestedElements.containsKey(nameToLookup)) {
            return super.lookup(name);
        }
        if (this.node.getNodesMap().containsKey(nameToLookup)) {
            XMLTreeNode nextNode = this.node.getNodesMap().get(nameToLookup);
            return new JNDIXMLContext(nextNode, this.logger);
        }
        if (this.node.getFieldMap().containsKey(nameToLookup)) {
            return this.node.getFieldMap().get(nameToLookup);
        }
        throw new NamingException("No name " + nameToLookup);
    }

    private class JNDIXMLNodesEnumeration
    implements NamingEnumeration {
        protected XMLTreeNode node;
        protected Enumeration nestedNames = null;
        protected Iterator<String> nodesIter;
        protected Iterator<String> fieldsIter;

        public JNDIXMLNodesEnumeration(XMLTreeNode node) {
            this.node = node;
            this.nodesIter = node.getNodesMap().keySet().iterator();
            this.fieldsIter = node.getFieldMap().keySet().iterator();
        }

        public Object next() throws NamingException {
            if (this.nestedNames != null && this.nestedNames.hasMoreElements()) {
                return new NameClassPair((String)this.nestedNames.nextElement(), Context.class.getName());
            }
            if (this.nodesIter.hasNext()) {
                return new NameClassPair(this.nodesIter.next(), Context.class.getName());
            }
            if (this.fieldsIter.hasNext()) {
                return new NameClassPair(this.fieldsIter.next(), String.class.getName());
            }
            return null;
        }

        @Override
        public boolean hasMore() throws NamingException {
            if (this.nestedNames != null && this.nestedNames.hasMoreElements()) {
                return true;
            }
            if (this.nodesIter.hasNext()) {
                return true;
            }
            return this.fieldsIter.hasNext();
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                return false;
            }
        }

        @Override
        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new NoSuchElementException(e.toString());
            }
        }
    }
}

