/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.util.Iterator;
import org.w3c.dom.Node;

public class NodeDescendants {
    private static int[] nodeToMaskMap;
    public static final int SHOW_ALL = -1;
    public static final int SHOW_ELEMENT = 1;
    public static final int SHOW_ATTRIBUTE = 2;
    public static final int SHOW_TEXT = 4;
    public static final int SHOW_CDATA_SECTION = 8;
    public static final int SHOW_ENTITY_REFERENCE = 16;
    public static final int SHOW_ENTITY = 32;
    public static final int SHOW_PROCESSING_INSTRUCTION = 64;
    public static final int SHOW_COMMENT = 128;
    public static final int SHOW_DOCUMENT = 256;
    public static final int SHOW_DOCUMENT_TYPE = 512;
    public static final int SHOW_DOCUMENT_FRAGMENT = 1024;
    public static final int SHOW_NOTATION = 2048;
    private final Node initialNode;
    private Node currentNode;
    private NodeDescendants subtree;
    private int whatToShow;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NodeDescendants(Node node) {
        this(node, -1);
    }

    public NodeDescendants(Node node, int whatToShow) {
        this.initialNode = node;
        this.whatToShow = whatToShow;
        this.reset();
    }

    public void reset() {
        this.currentNode = this.initialNode;
        this.subtree = null;
    }

    public void reset(int whatToShow) {
        this.reset();
        this.whatToShow = whatToShow;
    }

    private Node nextNode() {
        if (this.currentNode == null) {
            return null;
        }
        if (this.subtree == null) {
            if (!$assertionsDisabled && this.currentNode == null) {
                throw new AssertionError();
            }
            Node ret = this.currentNode;
            this.currentNode = this.currentNode.getFirstChild();
            if (this.currentNode != null) {
                this.subtree = new NodeDescendants(this.currentNode, this.whatToShow);
            }
            return ret;
        }
        Node ret = this.subtree.nextNode();
        if (ret == null) {
            this.currentNode = this.currentNode.getNextSibling();
            if (this.currentNode != null) {
                this.subtree = new NodeDescendants(this.currentNode, this.whatToShow);
                ret = this.subtree.nextNode();
            }
        }
        if (ret == null) {
            this.reset();
        }
        return ret;
    }

    private Node nextFilteredNode() {
        Node ret;
        if (this.whatToShow == -1) {
            return this.nextNode();
        }
        while ((ret = this.nextNode()) != null && (nodeToMaskMap[ret.getNodeType()] & this.whatToShow) == 0) {
        }
        return ret;
    }

    public Object visitTree(Visitor v) {
        if (v == null) {
            throw new IllegalArgumentException("NodeDescendants.visitTree given null visitor");
        }
        Node n = this.nextFilteredNode();
        while (n != null) {
            Object ret = v.visitNode(n);
            if (ret != null) {
                return ret;
            }
            n = this.nextFilteredNode();
        }
        return null;
    }

    public Iterator iterator() {
        return new Iterator(){
            private Node nextNode;
            {
                this.nextNode = NodeDescendants.this.nextFilteredNode();
            }

            public boolean hasNext() {
                return this.nextNode != null;
            }

            public Object next() {
                Node ret = this.nextNode;
                this.nextNode = NodeDescendants.this.nextFilteredNode();
                return ret;
            }

            public void remove() {
                throw new UnsupportedOperationException("NodeDescendants.iterator does not support element removal");
            }
        };
    }

    static {
        $assertionsDisabled = !NodeDescendants.class.desiredAssertionStatus();
        nodeToMaskMap = new int[16];
        NodeDescendants.nodeToMaskMap[2] = 2;
        NodeDescendants.nodeToMaskMap[4] = 8;
        NodeDescendants.nodeToMaskMap[8] = 128;
        NodeDescendants.nodeToMaskMap[11] = 1024;
        NodeDescendants.nodeToMaskMap[9] = 256;
        NodeDescendants.nodeToMaskMap[10] = 512;
        NodeDescendants.nodeToMaskMap[1] = 1;
        NodeDescendants.nodeToMaskMap[6] = 32;
        NodeDescendants.nodeToMaskMap[5] = 16;
        NodeDescendants.nodeToMaskMap[12] = 2048;
        NodeDescendants.nodeToMaskMap[7] = 64;
        NodeDescendants.nodeToMaskMap[3] = 4;
    }

    public static interface Visitor {
        public Object visitNode(Node var1);
    }
}

