/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.util.BitSet;

public class ValueWatcher {
    private final long loBound_;
    private final long hiBound_;
    private final BitSet used_;

    public ValueWatcher(long loBound, long hiBound) {
        if (hiBound - loBound >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Range too wide");
        }
        this.loBound_ = loBound;
        this.hiBound_ = hiBound;
        this.used_ = new BitSet();
    }

    public void useValue(long val) {
        if (val <= this.hiBound_ && val >= this.loBound_) {
            this.used_.set((int)(val - this.loBound_));
        }
    }

    public Long getUnused() {
        long value = this.loBound_ + (long)this.used_.nextClearBit(0);
        return value <= this.hiBound_ ? new Long(value) : null;
    }
}

