/*
 * Decompiled with CFR 0.152.
 */
package skyview.request;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import skyview.geometry.Position;
import skyview.survey.Util;

public class SourceCoordinates
implements Runnable {
    private String enteredText = null;
    private Position pos = null;
    private String queryReturn = null;
    private String coords;
    Thread thread;
    private boolean converted = false;
    private double[] values;
    boolean processed = false;
    static final String urlBase = "http://heasarc.gsfc.nasa.gov/cgi-bin/Tools/convcoord/convcoord.pl?NoCache=y&Output=Batch&";
    static HashMap<String, Position> savedQueries = new HashMap();
    String resolver;

    public SourceCoordinates(String s, String csn, double equinox, String resolver) {
        if (csn == null || csn.length() == 0) {
            csn = "J2000";
        }
        char initial = csn.charAt(0);
        String rest = csn.substring(1);
        try {
            equinox = Double.parseDouble(rest);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (initial != 'G' && initial != 'I') {
            csn = initial + "" + equinox;
        }
        this.resolver = resolver;
        this.coords = csn;
        this.enteredText = s;
    }

    public SourceCoordinates(String lon, String lat, String coords) throws IllegalArgumentException {
        lon = lon.trim();
        lat = lat.trim();
        this.coords = coords;
        this.enteredText = lon + ", " + lat;
        if (!this.process(new String[]{lon, lat})) {
            throw new IllegalArgumentException("Invalid coordinates:" + this.enteredText);
        }
        this.converted = true;
    }

    public static SourceCoordinates factory(String s, String csn, double equinox, String resolver) {
        return new SourceCoordinates(s, csn, equinox, resolver);
    }

    public static SourceCoordinates factory(String lon, String lat, String coords) {
        try {
            return new SourceCoordinates(lon, lat, coords);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Position getPosition() {
        return this.pos;
    }

    public boolean convertToCoords() {
        if (this.converted) {
            return true;
        }
        this.converted = true;
        if (savedQueries.containsKey(this.enteredText)) {
            this.pos = savedQueries.get(this.enteredText);
            return true;
        }
        if (Pattern.matches("^[\\s0-9\\.\\+\\-\\,\\:]+", this.enteredText)) {
            return this.parseLocal(this.enteredText);
        }
        this.thread = new Thread(this);
        this.thread.start();
        try {
            this.thread.join(35000L);
            if (this.queryReturn != null) {
                return this.parseCoords();
            }
            System.err.println("Error: timeout from resolver service.");
            return false;
        }
        catch (InterruptedException x) {
            System.err.println("Error: Accessing resolver service:\n" + x);
            return false;
        }
    }

    @Override
    public void run() {
        this.queryReturn = this.heasarcResolve();
    }

    public boolean parseCoords() {
        StringTokenizer st = new StringTokenizer(this.queryReturn, "|");
        String[] sexigesimals = new String[8];
        double[] decimals = new double[8];
        try {
            int i;
            for (i = 0; i < 8; ++i) {
                sexigesimals[i] = st.nextToken();
            }
            for (i = 0; i < 8; ++i) {
                decimals[i] = Double.parseDouble(st.nextToken());
            }
        }
        catch (Exception e) {
            System.err.println("HEASARC name resolver unable to process input: " + this.enteredText);
            return false;
        }
        try {
            this.pos = new Position(decimals[0], decimals[1]);
        }
        catch (Exception e) {
            return false;
        }
        savedQueries.put(this.enteredText, this.pos);
        return true;
    }

    public String heasarcResolve() {
        String query;
        String coordSys = "J2000";
        boolean special = false;
        if (this.coords.startsWith("G")) {
            coordSys = "Galactic";
        } else if (this.coords.startsWith("J") || this.coords.startsWith("B")) {
            special = true;
            coordSys = "Special Epoch";
        } else if (this.coords.startsWith("E")) {
            coordSys = "Ecliptic";
        }
        try {
            query = "http://heasarc.gsfc.nasa.gov/cgi-bin/Tools/convcoord/convcoord.pl?NoCache=y&Output=Batch&CoordVal=" + URLEncoder.encode(this.enteredText, "UTF-8") + "&CoordType=" + URLEncoder.encode(coordSys, "UTF-8");
            if (special) {
                query = query + "&Epoch=" + URLEncoder.encode(this.coords, "UTF-8");
            }
            if (this.resolver != null && this.resolver.length() > 0) {
                Pattern pattern = Pattern.compile("-");
                Matcher matcher = pattern.matcher(this.resolver);
                this.resolver = matcher.replaceAll("/");
                query = query + "&Resolver=" + URLEncoder.encode(this.resolver, "UTF-8");
            }
        }
        catch (Exception e) {
            System.err.println("Error encoding query:\n " + e);
            return null;
        }
        String wholeString = "";
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new URL(query).openStream()));
            while ((line = in.readLine()) != null) {
                wholeString = wholeString + "|" + line;
            }
        }
        catch (IOException e) {
            System.err.println("Error accessing HEASARC service:\n" + e);
        }
        return wholeString;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            SourceCoordinates.usage();
        } else {
            String source = args[0];
            String coords = args[1];
            double equinox = Double.parseDouble(args[2]);
            String resolver = args[3];
            System.err.println("resolver=" + resolver);
            SourceCoordinates sc = new SourceCoordinates(source, coords, equinox, resolver);
            Position pos = sc.getPosition();
            double[] posit = pos.getCoordinates(args[4]);
            System.out.println("Posit:" + posit[0] + "," + posit[1]);
        }
    }

    private static void usage() {
        System.out.println("Usage: java skyview.request.SourceCoordinates text inCoord equinox resolver outCoord");
    }

    private boolean parseLocal(String input) {
        String[] signs;
        input = input.trim();
        input = Util.replace(input, "\\+\\s+", "\\+", true);
        input = Util.replace(input, "\\-\\s+", "\\-", true);
        String[] commas = Pattern.compile(",").split(input);
        if (commas.length == 2) {
            return this.process(commas);
        }
        if (commas.length > 2) {
            System.err.println("Error: Too many commas");
            return false;
        }
        String prefix = "";
        String sign = "-";
        if (input.charAt(0) == '+' || input.charAt(0) == '-') {
            prefix = input.substring(0, 1);
            input = input.substring(1);
        }
        if ((signs = Pattern.compile("(\\+|\\-)").split(input)).length == 2) {
            signs[0] = prefix + signs[0];
            if (input.indexOf("+") >= 0) {
                sign = "+";
            }
            signs[1] = sign + signs[1];
            return this.process(signs);
        }
        if (signs.length > 2) {
            System.err.println("Error in signs");
            return false;
        }
        input = prefix + input;
        String[] spaces = Pattern.compile("\\s+").split(input);
        if (spaces.length == 2) {
            return this.process(spaces);
        }
        if (spaces.length == 6) {
            return this.process(new String[]{spaces[0] + " " + spaces[1] + " " + spaces[2], spaces[2] + " " + spaces[4] + " " + spaces[5]});
        }
        System.err.println("Unable to process input");
        return false;
    }

    private boolean process(String[] fields) {
        this.values = new double[2];
        for (int i = 0; i < 2; ++i) {
            if (this.parseField(i, fields[i])) continue;
            return false;
        }
        try {
            this.pos = new Position(this.values[0], this.values[1], this.coords);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean parseField(int index, String field) {
        field = field.trim();
        field = Util.replace(field, "\\s*\\:\\s*", "\\:", true);
        String[] comp = Pattern.compile("(\\s+|\\:)").split(field);
        if (comp.length > 3) {
            return false;
        }
        double value = 0.0;
        double sign = 1.0;
        double ratio = 1.0;
        if (comp[0].charAt(0) == '-') {
            sign = -1.0;
            comp[0] = comp[0].substring(1);
        } else if (comp[0].charAt(0) == '+') {
            comp[0] = comp[0].substring(1);
        }
        for (int i = 0; i < comp.length; ++i) {
            if (comp[i].length() == 0) {
                return false;
            }
            if (i != comp.length - 1 && comp[i].indexOf(".") >= 0) {
                return false;
            }
            if (comp[i].indexOf("+") >= 0 || comp[i].indexOf("-") >= 0) {
                return false;
            }
            value += sign * Double.parseDouble(comp[i]) / ratio;
            ratio *= 60.0;
        }
        String xcoords = this.coords.toUpperCase();
        if (index == 0 && comp.length > 1 && (xcoords.startsWith("J") || xcoords.startsWith("B"))) {
            value *= 15.0;
        }
        this.values[index] = value;
        return true;
    }
}

