/*
 * Decompiled with CFR 0.152.
 */
package skyview.vo;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import skyview.executive.Settings;
import skyview.geometry.Converter;
import skyview.geometry.CoordinateSystem;
import skyview.geometry.DepthSampler;
import skyview.geometry.Sampler;
import skyview.geometry.Util;
import skyview.process.Processor;
import skyview.survey.Image;
import skyview.vo.ConeQuerier;

public class CatalogProcessor
implements Processor {
    private static HashMap<String, ConeQuerier> requests = new HashMap();
    private ArrayList<Thread> threads = new ArrayList();
    private Image outputImage;
    private String[] catalogs;
    private boolean pixelsValid = false;
    private double cosRad;
    private boolean hasRad = false;
    private double[] centerUnit;
    private double[] centerCoords;
    private ArrayList<double[]> pixLoc;
    private ArrayList<Integer> symbols;
    private ArrayList<String[]> extras;
    private static boolean geometryMessage = false;
    PrintStream ps;
    static CatalogProcessor lastProcessor;

    public CatalogProcessor() {
        lastProcessor = this;
    }

    @Override
    public String getName() {
        return "CatalogProcessor";
    }

    @Override
    public String getDescription() {
        return "Handle the queries of external catalogs";
    }

    @Override
    public void process(Image[] inputs, Image output, int[] source, Sampler samp, DepthSampler dsamp) {
        int i;
        double requestSize;
        if (Settings.has("CatalogFile")) {
            String file = Settings.get("CatalogFile");
            if (file == null || file.length() == 0 || file.equals("1")) {
                file = Settings.get("output") + ".tab";
            } else if (Settings.has("_surveycount")) {
                file = Settings.has("dummy") && file.indexOf(".cat") >= 0 ? file.replace(".cat", "_" + Settings.get("_surveycount") + ".cat") : file + "." + Settings.get("_surveycount");
                Settings.put("CatalogFile", file);
            }
            try {
                if (file != null) {
                    if (this.ps != null) {
                        this.ps.close();
                        this.ps = null;
                    }
                    this.ps = new PrintStream(new FileOutputStream(file));
                    geometryMessage = true;
                    System.err.println("  Generating Catalog output file " + file);
                } else {
                    this.ps = null;
                }
            }
            catch (Exception e) {
                System.err.println("  Unable to create table output file:" + file);
                return;
            }
        }
        this.outputImage = output;
        this.catalogs = Settings.getArray("catalog");
        int nx = output.getWidth();
        int ny = output.getHeight();
        double imageSize = -1.0;
        if (Settings.has("CatalogRadius")) {
            try {
                imageSize = Double.parseDouble(Settings.get("catalogradius"));
                this.cosRad = Math.cos(Math.toRadians(imageSize));
                this.hasRad = true;
            }
            catch (Exception e) {
                System.err.println("  Invalid CatalogRadius setting:" + Settings.get("CatalogRadius") + " ignored");
            }
        }
        if (imageSize < 0.0) {
            imageSize = Math.toDegrees(output.getWCS().getScale() * (double)(nx + ny) / 2.0);
        }
        if (this.centerUnit == null) {
            this.centerUnit = output.getWCS().inverse().transform(new double[]{(double)nx / 2.0, (double)ny / 2.0});
            this.centerCoords = Util.coord(this.centerUnit);
        }
        if (requests.containsKey(this.catalogs[0]) && (requestSize = requests.get(this.catalogs[0]).getSize()) >= imageSize) {
            return;
        }
        this.pixelsValid = false;
        String[] qualArr = Settings.getArray("CatalogFilter");
        String[][] qualFlds = new String[qualArr.length][];
        int nQual = 0;
        for (i = 0; i < qualArr.length; ++i) {
            String[] flds = CatalogProcessor.parseQualifier(qualArr[i]);
            if (flds == null) continue;
            qualFlds[nQual] = flds;
            ++nQual;
        }
        for (i = 0; i < this.catalogs.length; ++i) {
            String cat = this.catalogs[i];
            ConeQuerier cq = cat.startsWith("http:") || cat.startsWith("ftp:") || cat.startsWith("file:") ? new ConeQuerier(cat, "cat" + i, Math.toDegrees(this.centerCoords[0]), Math.toDegrees(this.centerCoords[1]), imageSize) : ConeQuerier.factory(cat, Math.toDegrees(this.centerCoords[0]), Math.toDegrees(this.centerCoords[1]), imageSize);
            if (Settings.has("CatalogFields")) {
                cq.setOutput(this.ps);
            }
            if (nQual > 0) {
                for (int q = 0; q < nQual; ++q) {
                    cq.addCriterion(qualFlds[q][0], qualFlds[q][1], qualFlds[q][2]);
                }
            }
            requests.put(this.catalogs[i], cq);
            Thread thr = new Thread(cq);
            this.threads.add(thr);
            thr.start();
        }
    }

    private static String[] parseQualifier(String input) {
        if (input.indexOf("<=") > 0) {
            return CatalogProcessor.split(input, "<=");
        }
        if (input.indexOf(">=") > 0) {
            return CatalogProcessor.split(input, ">=");
        }
        if (input.indexOf(">") > 0) {
            return CatalogProcessor.split(input, ">");
        }
        if (input.indexOf("<") > 0) {
            return CatalogProcessor.split(input, "<");
        }
        if (input.indexOf("=") > 0) {
            return CatalogProcessor.split(input, "=");
        }
        return null;
    }

    private static String[] split(String input, String op) {
        int index = input.indexOf(op);
        int len = op.length();
        if (index == 0 || index + len == input.length()) {
            return null;
        }
        return new String[]{input.substring(0, index), op, input.substring(index + len)};
    }

    public static CatalogProcessor getLastProcessor() {
        return lastProcessor;
    }

    public void waitForThreads() {
        for (int i = 0; i < this.threads.size(); ++i) {
            try {
                this.threads.get(i).join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.threads.clear();
    }

    public ConeQuerier[] getCatalogs() {
        return requests.values().toArray(new ConeQuerier[0]);
    }

    @Override
    public void updateHeader(Header header) {
        try {
            header.insertHistory("");
            header.insertHistory("Catalogs:");
            header.insertHistory("");
        }
        catch (FitsException e) {
            System.err.println("  Error updating FITS file in CatalogProcessor:" + e);
        }
        for (ConeQuerier cq : this.getCatalogs()) {
            cq.updateHeader(header);
        }
    }

    public void pixels(boolean doPrint) {
        int i;
        if (this.pixelsValid && !doPrint) {
            return;
        }
        this.waitForThreads();
        this.pixLoc = new ArrayList();
        this.symbols = new ArrayList();
        CoordinateSystem cs = null;
        Converter conv = null;
        if (this.ps != null && doPrint) {
            cs = this.outputImage.getWCS().getCoordinateSystem();
            conv = new Converter();
            try {
                if (cs.getSphereDistorter() != null) {
                    conv.add(cs.getSphereDistorter());
                }
                conv.add(cs.getRotater());
            }
            catch (Exception e) {
                this.ps.println("CatalogProcessor unable to transform coordinates to image system. Using J2000");
            }
        }
        int maxCatLen = -1;
        for (int i2 = 0; i2 < this.catalogs.length; ++i2) {
            if (this.catalogs[i2].length() <= maxCatLen) continue;
            maxCatLen = this.catalogs[i2].length();
        }
        ++maxCatLen;
        if (Settings.has("_surveycount")) {
            String[] surveys = Settings.getArray("survey");
            if (geometryMessage) {
                System.err.println("   Catalog output file uses image geometry for survey=" + surveys[0] + ".");
                geometryMessage = false;
            }
        }
        double[] px = new double[2];
        double[] unit = new double[3];
        double[] newCoo = new double[2];
        int nx = this.outputImage.getWidth();
        int ny = this.outputImage.getHeight();
        if (this.ps != null && doPrint) {
            this.ps.printf(" %3s | %-" + maxCatLen + "s| %-20s| %9s| %9s|", "N ", "Cat", "ID/Name", "RA/Lon ", "Dec/Lat ");
            String[] xtras = Settings.getArray("CatalogColumns");
            if (xtras != null) {
                for (i = 0; i < xtras.length; ++i) {
                    this.ps.printf("%19s|", xtras[i]);
                }
            }
            this.ps.printf("  %6s| %6s\n", "X ", "Y ");
        }
        int count = 0;
        for (i = 0; i < this.catalogs.length; ++i) {
            ConeQuerier cq = requests.get(this.catalogs[i]);
            double[][] pos = cq.getPositions();
            String[] ids = cq.getIDs();
            ArrayList<String[]> extra = cq.getExtras();
            int catCount = 0;
            for (int p = 0; p < pos.length; ++p) {
                px[0] = Math.toRadians(pos[p][0]);
                px[1] = Math.toRadians(pos[p][1]);
                unit = Util.unit(px);
                this.outputImage.getWCS().transform(unit, px);
                if (!(px[0] >= 0.0) || !(px[1] >= 0.0) || !(px[0] <= (double)nx) || !(px[1] <= (double)ny) || this.hasRad && unit[0] * this.centerUnit[0] + unit[1] * this.centerUnit[1] + unit[2] * this.centerUnit[2] < this.cosRad) continue;
                ++count;
                ++catCount;
                if (this.ps != null && doPrint) {
                    conv.transform(unit, unit);
                    newCoo = Util.coord(unit);
                    newCoo[0] = Math.toDegrees(newCoo[0]);
                    newCoo[1] = Math.toDegrees(newCoo[1]);
                    String[] xx = null;
                    if (extra != null) {
                        xx = extra.get(p);
                    }
                    this.ps.printf(" %3d | %-" + maxCatLen + "s| %-20s| %9.4f| %9.4f|", count, this.catalogs[i], ids[p], newCoo[0], newCoo[1]);
                    if (xx != null) {
                        for (int ii = 0; ii < xx.length; ++ii) {
                            this.ps.printf("%19s|", xx[ii]);
                        }
                    }
                    this.ps.printf("  %6.1f| %6.1f\n", px[0], px[1]);
                }
                this.pixLoc.add((double[])px.clone());
                this.symbols.add(i);
            }
            cq.setEntriesUsed(catCount);
        }
        this.pixelsValid = true;
        Settings.put("_totalCatalogCount", "" + count);
    }

    public void postProcess(Image[] inputs, Image output, int[] source, Sampler samp, DepthSampler dsamp) {
        if (Settings.has("CatalogFile")) {
            this.pixels(true);
        }
    }

    public double[][] getPixels() {
        this.pixels(false);
        return (double[][])this.pixLoc.toArray((T[])new double[0][]);
    }

    public int[] getSymbols() {
        this.pixels(false);
        int[] arr = new int[this.symbols.size()];
        for (int i = 0; i < this.symbols.size(); ++i) {
            arr[i] = this.symbols.get(i);
        }
        return arr;
    }

    public static void clearRequests() {
        requests.clear();
    }
}

