/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.layout;

import diva.graph.GraphModel;
import diva.graph.layout.AbstractGlobalLayout;
import diva.graph.layout.LayoutTarget;
import diva.graph.layout.LayoutUtilities;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class RandomLayout
extends AbstractGlobalLayout {
    private static final int NUM_ITER = 10;

    public RandomLayout(LayoutTarget target) {
        super(target);
    }

    public void layout(Object composite) {
        LayoutTarget target = this.getLayoutTarget();
        GraphModel model = target.getGraphModel();
        Iterator ns = model.nodes(composite);
        block0: while (ns.hasNext()) {
            Object node = ns.next();
            if (!target.isNodeVisible(node)) continue;
            Rectangle2D vp = target.getViewport(composite);
            Rectangle2D bounds = target.getBounds(node);
            for (int i = 0; i < 10; ++i) {
                double x = vp.getX() + Math.abs(Math.random()) * vp.getWidth();
                double y = vp.getY() + Math.abs(Math.random()) * vp.getHeight();
                LayoutUtilities.place(target, node, x, y);
                bounds = target.getBounds(node);
                boolean overlap = false;
                Iterator j = target.intersectingNodes(bounds);
                while (j.hasNext()) {
                    Object n2 = j.next();
                    if (node == n2) continue;
                    overlap = false;
                }
                if (!overlap) continue block0;
            }
        }
        LayoutUtilities.routeVisibleEdges(composite, target);
    }
}

