/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

public class AstronomicalUtils {
    private AstronomicalUtils() {
    }

    public static final Double calculateSeparation(Double calibratorRaDegrees, Double calibratorDecDegrees, Double queryRaRadians, Double queryDecRadians) {
        double bottom;
        if (calibratorRaDegrees == null || calibratorDecDegrees == null || queryRaRadians == null || queryDecRadians == null) {
            return null;
        }
        double a1 = queryRaRadians;
        double a2 = Math.toRadians(calibratorRaDegrees);
        double d1 = queryDecRadians;
        double d2 = Math.toRadians(calibratorDecDegrees);
        double top = Math.sqrt(Math.pow(Math.cos(d2), 2.0) * Math.pow(Math.sin(a2 - a1), 2.0) + Math.pow(Math.cos(d1) * Math.sin(d2) - Math.sin(d1) * Math.cos(d2) * Math.cos(a2 - a1), 2.0));
        double separationInDegrees = 57.29577951308232 * Math.atan(top / (bottom = Math.sin(d1) * Math.sin(d2) + Math.cos(d1) * Math.cos(d2) * Math.cos(a2 - a1)));
        if (separationInDegrees < 0.0) {
            separationInDegrees += 180.0;
        }
        return separationInDegrees;
    }
}

