/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.components;

import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.component.ComponentImplBase;
import alma.acs.component.ComponentLifecycleException;
import alma.acs.container.ContainerServices;
import alma.acs.exceptions.AcsJException;
import alma.acs.nc.AcsEventPublisher;
import alma.archive.components.AdministrativeImpl;
import alma.archive.components.OperationalImpl;
import alma.archive.exceptions.ArchiveException;
import alma.maciErrType.wrappers.AcsJComponentCleanUpEx;
import alma.xmlstore.Administrative;
import alma.xmlstore.AdministrativeHelper;
import alma.xmlstore.AdministrativeOperations;
import alma.xmlstore.AdministrativePOATie;
import alma.xmlstore.ArchiveConnectionOperations;
import alma.xmlstore.ArchiveConnectionPackage.PermissionException;
import alma.xmlstore.ArchiveConnectionPackage.UserDoesNotExistException;
import alma.xmlstore.Operational;
import alma.xmlstore.OperationalHelper;
import alma.xmlstore.OperationalOperations;
import alma.xmlstore.OperationalPOATie;
import alma.xmlstore.XmlStoreNotificationEvent;
import java.util.HashMap;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.PortableServer.Servant;

public class ArchiveConnectionImpl
extends ComponentImplBase
implements ArchiveConnectionOperations {
    private HashMap<String, Operational> operMap = new HashMap();
    protected AcsEventPublisher<XmlStoreNotificationEvent> xmlNotifyChannel;

    public void initialize(ContainerServices containerServices) throws ComponentLifecycleException {
        super.initialize(containerServices);
        if (this.xmlNotifyChannel == null) {
            try {
                this.xmlNotifyChannel = containerServices.createNotificationChannelPublisher("xmlstore", XmlStoreNotificationEvent.class);
            }
            catch (AcsJException e) {
                this.m_logger.severe("ARCHIVE: Could not initialize Notification channel xmlstore");
            }
        }
    }

    public void cleanUp() throws AcsJComponentCleanUpEx {
        super.cleanUp();
        if (this.xmlNotifyChannel != null) {
            try {
                this.xmlNotifyChannel.disconnect();
            }
            catch (Exception e) {
                this.m_logger.info("Problems in disconnectiong from notification channel: " + e);
            }
            this.xmlNotifyChannel = null;
        }
    }

    public synchronized Operational getOperational(String user) throws alma.xmlstore.ArchiveConnectionPackage.ArchiveException, UserDoesNotExistException, PermissionException {
        if (this.operMap.get(user) == null) {
            this.m_logger.info("Creating new Operational offshoot for user " + user);
            OperationalPOATie operational = new OperationalPOATie((OperationalOperations)new OperationalImpl(user, (Logger)this.m_logger, this.m_containerServices, this.xmlNotifyChannel));
            try {
                this.operMap.put(user, OperationalHelper.narrow((Object)this.m_containerServices.activateOffShoot((Servant)operational)));
            }
            catch (AcsJContainerServicesEx e) {
                this.m_logger.severe("The container had a problem starting the OffShoot: " + e.getContextInfo());
                throw new alma.xmlstore.ArchiveConnectionPackage.ArchiveException(e.getContextInfo());
            }
        }
        return this.operMap.get(user);
    }

    public synchronized Administrative getAdministrative(String user) throws alma.xmlstore.ArchiveConnectionPackage.ArchiveException, UserDoesNotExistException, PermissionException {
        AdministrativePOATie administrative;
        try {
            administrative = new AdministrativePOATie((AdministrativeOperations)new AdministrativeImpl(user, (Logger)this.m_logger, this.m_containerServices));
        }
        catch (ArchiveException e1) {
            throw new alma.xmlstore.ArchiveConnectionPackage.ArchiveException(e1.toString());
        }
        try {
            return AdministrativeHelper.narrow((Object)this.m_containerServices.activateOffShoot((Servant)administrative));
        }
        catch (AcsJContainerServicesEx e) {
            throw new alma.xmlstore.ArchiveConnectionPackage.ArchiveException(e.getContextInfo());
        }
    }
}

