/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.client;

import alma.archive.wrappers.TextFileWindow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class LogAggregator {
    private String targetDirectory;
    private String tag;
    private String outputFile;

    public LogAggregator(String targetDirectory, String tag, String outputFile) {
        this.targetDirectory = targetDirectory;
        this.tag = tag;
        this.outputFile = outputFile;
    }

    public void run() {
        ArrayList logs = this.extractLogEntrys(this.targetDirectory, this.tag);
        ArrayList changed = this.assignIds(logs);
        this.updateChanged(changed);
        this.updateXml(this.outputFile, this.tag, logs);
    }

    public void printLogs() {
        ArrayList logs = this.extractLogEntrys(this.targetDirectory, this.tag);
        for (LogEntry log : logs) {
            String msg = log.toString();
            System.out.println(log.getLine() + "::" + msg);
        }
    }

    private ArrayList assignIds(ArrayList logs) {
        Iterator iter = logs.iterator();
        ArrayList<LogEntry> noid = new ArrayList<LogEntry>();
        int maxid = 0;
        while (iter.hasNext()) {
            LogEntry log = (LogEntry)iter.next();
            if (log.hasId()) {
                String strInt = log.getId();
                int intid = Integer.parseInt(strInt);
                if (intid <= maxid) continue;
                maxid = intid;
                continue;
            }
            noid.add(log);
        }
        for (LogEntry log : noid) {
            log.setId(Integer.toString(++maxid));
        }
        return noid;
    }

    private void updateChanged(ArrayList changed) {
        Hashtable lines;
        Hashtable<String, Hashtable> files = new Hashtable<String, Hashtable>();
        ArrayList<String> fileNames = new ArrayList<String>();
        for (LogEntry log : changed) {
            if (files.containsKey(log.getPath())) {
                lines = (Hashtable)files.get(log.getPath());
                lines.put(log.getLine(), log);
                continue;
            }
            lines = new Hashtable();
            lines.put(log.getLine(), log);
            files.put(log.getPath(), lines);
            if (fileNames.contains(log.getPath())) continue;
            fileNames.add(log.getPath());
        }
        for (String fileName : fileNames) {
            lines = (Hashtable)files.get(fileName);
            try {
                String str;
                File file = new File(fileName);
                File newFile = new File(fileName + ".orig");
                file.renameTo(newFile);
                BufferedReader in = new BufferedReader(new FileReader(newFile));
                BufferedWriter out = new BufferedWriter(new FileWriter(file));
                int lineNumber = 0;
                while ((str = in.readLine()) != null) {
                    if (lines.containsKey(Integer.toString(++lineNumber))) {
                        LogEntry log = (LogEntry)lines.get(Integer.toString(lineNumber));
                        str = str.replaceFirst(log.oldTag(), log.newTag());
                    }
                    out.write(str + "\n");
                }
                in.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateXml(String fileName, String tag, ArrayList logs) {
        File xmlFile = new File(fileName);
        String outFileName = fileName;
        Element aggregation = null;
        Element module = null;
        if (xmlFile.exists()) {
            SAXBuilder builder = new SAXBuilder();
            builder.setIgnoringElementContentWhitespace(true);
            try {
                Document doc = builder.build((Reader)new FileReader(xmlFile));
                aggregation = doc.getRootElement();
                String _path = "module[@name='" + tag + "']";
                XPath path = XPath.newInstance((String)_path);
                module = (Element)path.selectSingleNode((Object)aggregation);
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            xmlFile.delete();
        } else {
            aggregation = new Element("aggregation");
        }
        if (module == null) {
            module = new Element("module");
            module.setAttribute("name", tag);
            aggregation.addContent((Content)module);
        }
        for (LogEntry log : logs) {
            String id = log.getId();
            Element logElement = null;
            try {
                XPath path = XPath.newInstance((String)("log[@id='" + id + "'"));
                logElement = (Element)path.selectSingleNode((Object)module);
                if (logElement == null) {
                    logElement = log.toXml();
                    module.addContent((Content)logElement);
                    continue;
                }
                log.update(logElement);
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
        }
        try {
            FileWriter writer = new FileWriter(outFileName);
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            out.output(aggregation, (Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ArrayList extractLogEntrys(String targetDirectory, String tag) {
        ArrayList results = new ArrayList();
        File dir = new File(targetDirectory);
        if (dir.exists()) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name.startsWith(".")) {
                        return false;
                    }
                    return !name.endsWith(".orig");
                }
            };
            String[] children = dir.list(filter);
            for (int x = 0; x < children.length; ++x) {
                String fileName = dir.getAbsolutePath() + "/" + children[x];
                File file = new File(fileName);
                if (!file.isDirectory()) {
                    ArrayList fileResults = this.extractLogsFromFile(file, tag);
                    results.addAll(fileResults);
                    continue;
                }
                ArrayList subResults = this.extractLogEntrys(file.getPath(), tag);
                results.addAll(subResults);
            }
        }
        return results;
    }

    private ArrayList extractLogsFromFile(File file, String tag) {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        try {
            Object str;
            TextFileWindow in = new TextFileWindow(5, 4, file);
            String packageName = "";
            int lineNumber = 0;
            while ((str = in.readLine()) != null) {
                if (((String)str).startsWith("package")) {
                    packageName = ((String)str).substring(8, ((String)str).length() - 1);
                }
                ++lineNumber;
                int start = ((String)str).indexOf(tag + ":");
                if (start <= 0) continue;
                int offset = 0;
                int end = ((String)str).indexOf(");", start);
                while (end < 0 && (str = (String)str + in.readLine()) != null) {
                    ++offset;
                    end = ((String)str).indexOf(");", start);
                }
                String msg = ((String)str).substring(start, end);
                if ((msg = msg.replaceAll("\t", "")).endsWith("\"")) {
                    msg = msg.substring(0, msg.length() - 1);
                }
                LogEntry log = new LogEntry(msg, lineNumber, file, packageName, in.readWindow());
                result.add(log);
                lineNumber += offset;
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private ArrayList usedIds(String targetDirectory, String tag) {
        return null;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Arguments: [working directory] [tag e.g. ARCHIVE] [xml file name]");
        } else {
            String directory = args[0];
            String tag = args[1];
            String outputFile = args[2];
            LogAggregator la = new LogAggregator(directory, tag, outputFile);
            la.run();
        }
    }

    private class LogEntry {
        private String tag = "";
        private String id = "";
        private String message = "";
        private String line = "";
        private String comments = "";
        private String path = "";
        private String fileName = "";
        private String packageName = "";
        private String codeSnippet = "";

        public LogEntry(String code, int lineNumber, File file, String packageName, String codeSnippet) {
            this.line = Integer.toString(lineNumber);
            this.path = file.getAbsolutePath();
            this.fileName = file.getName();
            this.packageName = packageName;
            this.codeSnippet = codeSnippet;
            String[] parts = code.split(":");
            this.tag = parts[0];
            this.message = code.substring(this.tag.length() + 1);
            int start = this.message.indexOf("<id>");
            int end = this.message.indexOf("</id>");
            if (start >= 0 && end > 0) {
                this.id = this.message.substring(start + 4, end);
                this.message = this.message.substring(end + 5);
            }
            this.comments = "Insert comment here";
        }

        public Element toXml() {
            Element log = new Element("log");
            log.setAttribute("tag", this.tag);
            log.setAttribute("id", this.id);
            log.setAttribute("message", this.message);
            log.setAttribute("line", this.line);
            log.setAttribute("fileName", this.fileName);
            log.setAttribute("packageName", this.packageName);
            Element comment = new Element("comments");
            comment.setText(this.comments);
            log.addContent((Content)comment);
            Element code = new Element("code");
            code.setText(this.codeSnippet);
            log.addContent((Content)code);
            return log;
        }

        public void update(Element log) {
            log.setAttribute("message", this.message);
            log.setAttribute("line", this.line);
            Element code = log.getChild("code");
            code.setText(this.codeSnippet);
        }

        public boolean hasId() {
            return this.id != "";
        }

        public String getLine() {
            return this.line;
        }

        public String getPath() {
            return this.path;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setComments(String comments) {
            this.comments = comments;
        }

        public String toString() {
            if (this.hasId()) {
                return this.tag + ":<id>" + this.id + "</id>" + this.message;
            }
            return this.tag + ":" + this.message;
        }

        public String toStringShort() {
            return this.tag + ":<id>" + this.id + "</id>";
        }

        public String oldTag() {
            return this.tag + ":";
        }

        public String newTag() {
            return this.tag + ":<id>" + this.id + "</id>";
        }
    }
}

