/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcTransport;
import org.apache.xmlrpc.XmlRpcTransportFactory;

class CustomTransportFactory
implements XmlRpcTransportFactory {
    private URL url_;
    private String auth_;

    public CustomTransportFactory(URL url) {
        this.url_ = url;
    }

    public void setProperty(String key, Object value) {
        if ("auth".equals(key)) {
            this.auth_ = (String)value;
        } else if ("url".equals(key)) {
            this.url_ = (URL)value;
        }
    }

    public XmlRpcTransport createTransport() {
        return new Transport(this.url_, this.auth_);
    }

    private static class Transport
    implements XmlRpcTransport {
        private final URL url_;
        private final String auth_;
        private InputStream connStrm_;

        public Transport(URL url, String auth) {
            this.url_ = url;
            this.auth_ = auth;
        }

        public InputStream sendXmlRpc(byte[] request) throws IOException {
            URLConnection conn = this.url_.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setAllowUserInteraction(false);
            conn.setRequestProperty("Content-Length", Integer.toString(request.length));
            conn.setRequestProperty("Content-Type", "text/xml");
            if (this.auth_ != null) {
                conn.setRequestProperty("Authorization", "Basic " + this.auth_);
            }
            OutputStream out = conn.getOutputStream();
            out.write(request);
            out.flush();
            out.close();
            try {
                this.connStrm_ = conn.getInputStream();
                return this.connStrm_;
            }
            catch (IOException e) {
                InputStream err;
                if (conn instanceof HttpURLConnection && (err = ((HttpURLConnection)conn).getErrorStream()) != null) {
                    this.connStrm_ = err;
                    return err;
                }
                throw e;
            }
        }

        public void endClientRequest() throws XmlRpcClientException {
            if (this.connStrm_ != null) {
                try {
                    this.connStrm_.close();
                }
                catch (IOException e) {
                    throw new XmlRpcClientException("Trouble closing URLConnection: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    this.connStrm_ = null;
                }
            }
        }
    }
}

