/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.RandomJELRowReader;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;

public class AddJELColumnTable
extends WrapperStarTable {
    private final int nAdded_;
    private final StarTable baseTable_;
    private final String[] exprs_;
    private final int[] colMap_;
    private final RandomJELRowReader randomReader_;
    private final CompiledExpression[] randomCompexs_;
    private final ColumnInfo[] addInfos_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AddJELColumnTable(StarTable baseTable, ColumnInfo cinfo, String expr, int ipos) throws CompilationException {
        this(baseTable, new ColumnInfo[]{cinfo}, new String[]{expr}, ipos);
    }

    public AddJELColumnTable(StarTable baseTable, ColumnInfo[] cinfos, String[] exprs, int ipos) throws CompilationException {
        super(baseTable);
        this.baseTable_ = baseTable;
        this.exprs_ = (String[])exprs.clone();
        this.nAdded_ = this.exprs_.length;
        if (cinfos.length != this.nAdded_) {
            throw new IllegalArgumentException("How many new columns??");
        }
        if (ipos < 0) {
            ipos = baseTable.getColumnCount();
        }
        this.colMap_ = new int[baseTable.getColumnCount() + this.nAdded_];
        int j = 0;
        for (int i = 0; i < this.colMap_.length; ++i) {
            int k = i - ipos;
            this.colMap_[i] = k >= 0 && k < this.nAdded_ ? -(k + 1) : j++;
        }
        if (!$assertionsDisabled && j != baseTable.getColumnCount()) {
            throw new AssertionError();
        }
        this.randomReader_ = new RandomJELRowReader(baseTable);
        Library lib = JELUtils.getLibrary(this.randomReader_);
        this.randomCompexs_ = new CompiledExpression[this.nAdded_];
        this.addInfos_ = new ColumnInfo[this.nAdded_];
        for (int i = 0; i < this.nAdded_; ++i) {
            String expr = this.exprs_[i];
            this.randomCompexs_[i] = JELUtils.compile(lib, baseTable, expr);
            Class primType = JELUtils.getExpressionType(lib, baseTable, expr);
            Class clazz = JELUtils.getWrapperType(primType);
            this.addInfos_[i] = cinfos[i];
            this.addInfos_[i].setContentClass(clazz);
        }
    }

    public int getColumnCount() {
        return this.colMap_.length;
    }

    public ColumnInfo getColumnInfo(int icol) {
        int ibase = this.colMap_[icol];
        return ibase >= 0 ? super.getColumnInfo(ibase) : this.addInfos_[-1 - ibase];
    }

    public Object getCell(long irow, int icol) throws IOException {
        int ibase = this.colMap_[icol];
        return ibase >= 0 ? super.getCell(irow, ibase) : this.evaluateAtRow(irow, -1 - ibase);
    }

    public Object[] getRow(long irow) throws IOException {
        Object[] baseRow = super.getRow(irow);
        int ncol = this.colMap_.length;
        if (!$assertionsDisabled && ncol != baseRow.length + 1) {
            throw new AssertionError();
        }
        Object[] row = new Object[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            int ibase = this.colMap_[icol];
            row[icol] = ibase >= 0 ? baseRow[ibase] : this.evaluateAtRow(irow, -1 - ibase);
        }
        return row;
    }

    public RowSequence getRowSequence() throws IOException {
        final SequentialJELRowReader seqReader = new SequentialJELRowReader(this.baseTable_);
        final CompiledExpression[] seqCompexs = new CompiledExpression[this.nAdded_];
        Library lib = JELUtils.getLibrary(seqReader);
        for (int i = 0; i < this.nAdded_; ++i) {
            try {
                seqCompexs[i] = JELUtils.compile(lib, this.baseTable_, this.exprs_[i]);
                continue;
            }
            catch (CompilationException e) {
                throw (IOException)new IOException("Bad expression: " + this.exprs_[i]).initCause(e);
            }
        }
        return new WrapperRowSequence(seqReader){
            static final /* synthetic */ boolean $assertionsDisabled;

            public Object getCell(int icol) throws IOException {
                if (seqReader.getCurrentRow() < 0L) {
                    throw new IllegalStateException("Before start of table");
                }
                int ibase = AddJELColumnTable.this.colMap_[icol];
                return ibase >= 0 ? super.getCell(ibase) : this.evaluate(-1 - ibase);
            }

            public Object[] getRow() throws IOException {
                Object[] baseRow = super.getRow();
                int ncol = AddJELColumnTable.this.colMap_.length;
                if (!$assertionsDisabled && ncol != baseRow.length + 1) {
                    throw new AssertionError();
                }
                Object[] row = new Object[ncol];
                for (int icol = 0; icol < ncol; ++icol) {
                    int ibase = AddJELColumnTable.this.colMap_[icol];
                    row[icol] = ibase >= 0 ? baseRow[ibase] : this.evaluate(-1 - ibase);
                }
                return row;
            }

            private Object evaluate(int iAddcol) throws IOException {
                try {
                    return seqReader.evaluate(seqCompexs[iAddcol]);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }

            static {
                $assertionsDisabled = !(class$uk$ac$starlink$ttools$filter$AddJELColumnTable == null ? (class$uk$ac$starlink$ttools$filter$AddJELColumnTable = AddJELColumnTable.class$("uk.ac.starlink.ttools.filter.AddJELColumnTable")) : class$uk$ac$starlink$ttools$filter$AddJELColumnTable).desiredAssertionStatus();
            }
        };
    }

    private Object evaluateAtRow(long irow, int iAddcol) throws IOException {
        if (irow < 0L) {
            throw new IllegalStateException("Illegal row index " + irow);
        }
        try {
            return this.randomReader_.evaluateAtRow(this.randomCompexs_[iAddcol], irow);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    static {
        $assertionsDisabled = !AddJELColumnTable.class.desiredAssertionStatus();
    }
}

