/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import edu.jhu.htm.core.HTMException;
import edu.jhu.htm.core.HTMfunc;
import gov.fnal.eag.healpix.PixTools;
import javax.vecmath.Vector3d;

public class Tilings {
    private static final PixTools pixTools_ = new PixTools();

    private Tilings() {
    }

    public static long htmIndex(int level, double ra, double dec) {
        try {
            return HTMfunc.lookupId((double)ra, (double)dec, (int)level);
        }
        catch (HTMException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static long healpixNestIndex(int k, double ra, double dec) {
        if (k > 63) {
            throw new IllegalArgumentException("k " + k + " too large");
        }
        long nside = 1L << k;
        return pixTools_.vect2pix_nest(nside, Tilings.toVector(ra, dec));
    }

    public static long healpixRingIndex(int k, double ra, double dec) {
        if (k > 63) {
            throw new IllegalArgumentException("k " + k + " too large");
        }
        long nside = 1L << k;
        return pixTools_.vect2pix_ring(nside, Tilings.toVector(ra, dec));
    }

    public static int healpixK(double pixelsize) {
        long nside = pixTools_.GetNSide(pixelsize * 60.0 * 60.0);
        return (int)(Math.log(nside) / Math.log(2.0));
    }

    public static double healpixResolution(int k) {
        long nside = 1L << k;
        double resArcsec = pixTools_.PixRes(nside);
        return resArcsec / 3600.0;
    }

    public static int htmLevel(double pixelsize) {
        return (int)Math.ceil(5.0 - Math.log(pixelsize / 2.8125) / Math.log(2.0));
    }

    public static double htmResolution(int level) {
        return 2.8125 * Math.pow(2.0, 5 - level);
    }

    private static Vector3d toVector(double ra, double dec) {
        double theta = 1.5707963267948966 - Math.toRadians(dec);
        return pixTools_.Ang2Vec(theta, Math.toRadians(ra));
    }
}

