/*
 * Decompiled with CFR 0.152.
 */
package jsky.navigator;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.QueryResult;
import jsky.catalog.TableQueryResult;
import jsky.catalog.gui.CatalogNavigator;
import jsky.catalog.gui.CatalogNavigatorOpener;
import jsky.catalog.gui.TablePlotter;
import jsky.image.fits.codec.FITSImage;
import jsky.image.fits.gui.FITSKeywordsFrame;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.image.gui.ImageDisplayControlFrame;
import jsky.image.gui.PickObjectStatistics;
import jsky.navigator.Navigator;
import jsky.navigator.NavigatorFITSTable;
import jsky.navigator.NavigatorImageDisplayFrame;
import jsky.navigator.NavigatorManager;
import jsky.navigator.NavigatorPane;
import jsky.util.I18N;
import jsky.util.Resources;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.SwingUtil;

public class NavigatorImageDisplay
extends DivaMainImageDisplay
implements CatalogNavigatorOpener {
    private static final I18N _I18N = I18N.getInstance(NavigatorImageDisplay.class);
    private Navigator _navigator;
    private NavigatorPane _navigatorPane;
    private JFrame _navigatorFrame;
    private Set<String> _filesVisited = new HashSet<String>();
    private AbstractAction _catalogBrowseAction = new AbstractAction(_I18N.getString("browse") + "...", Resources.getIcon("Catalog24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("showCatalogWindow"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                NavigatorImageDisplay.this.openCatalogWindow();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _gridAction = new AbstractAction(_I18N.getString("grid") + "...", Resources.getIcon("grid.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("showGrid"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                NavigatorImageDisplay.this.toggleGrid();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };

    public NavigatorImageDisplay() {
        super(new NavigatorPane());
        this._navigatorPane = (NavigatorPane)this.getCanvasPane();
        this._navigatorPane.setImageDisplay(this);
    }

    public NavigatorPane getNavigatorPane() {
        return this._navigatorPane;
    }

    @Override
    public ImageDisplayControlFrame newWindow() {
        NavigatorImageDisplayFrame f = new NavigatorImageDisplayFrame();
        f.getImageDisplayControl().getImageDisplay().setTitle(this.getTitle());
        f.setVisible(true);
        return f;
    }

    public void setNavigator(Navigator navigator) {
        this._navigator = navigator;
        this._navigatorFrame = SwingUtil.getFrame(navigator);
    }

    public Navigator getNavigator() {
        return this._navigator;
    }

    public void toggleGrid() {
        this.setGridVisible(!this.isGridVisible());
    }

    public boolean isGridVisible() {
        return this._navigatorPane.getGridLayer().isVisible();
    }

    public void setGridVisible(boolean visible) {
        if (visible != this.isGridVisible()) {
            this._navigatorPane.getGridLayer().setVisible(visible);
            this.repaint();
        }
    }

    @Override
    public void openCatalogWindow() {
        if (this._navigatorFrame == null) {
            this.makeNavigatorFrame();
        }
        this.showNavigatorFrame(null);
    }

    @Override
    public void openCatalogWindow(Catalog cat) {
        if (this._navigatorFrame == null) {
            this.makeNavigatorFrame();
        }
        this.showNavigatorFrame(cat);
    }

    @Override
    public void openCatalogWindow(String name) {
        CatalogDirectory dir = CatalogNavigator.getCatalogDirectory(false);
        Catalog cat = dir.findCatalog(name);
        if (cat != null) {
            this.openCatalogWindow(cat);
        }
    }

    @Override
    public void openLocalCatalog() {
        this.openCatalogWindow();
        this._navigator.open();
    }

    @Override
    public void displayFITSTable(int hduIndex) {
        FITSImage fitsImage = this.getFitsImage();
        if (fitsImage != null && hduIndex > 0 && hduIndex < fitsImage.getNumHDUs()) {
            try {
                TableQueryResult table = NavigatorFITSTable.getTable(this.getFilename(), fitsImage.getFits(), hduIndex);
                this.showNavigatorFrame(null);
                this.openCatalogWindow(table.getCatalog());
                FITSKeywordsFrame fitsKeywordsFrame = this.getFitsKeywordsFrame();
                if (fitsKeywordsFrame != null) {
                    fitsKeywordsFrame.getFITSKeywords().updateDisplay(hduIndex);
                }
            }
            catch (Exception e) {
                DialogUtil.error((Component)this, e);
            }
        }
    }

    @Override
    public void deleteFITSTable(int hduIndex) {
        FITSImage fitsImage = this.getFitsImage();
        if (fitsImage != null && hduIndex > 0 && hduIndex < fitsImage.getNumHDUs()) {
            try {
                NavigatorFITSTable.deleteTable(fitsImage.getFits(), hduIndex);
                this.setSaveNeeded(true);
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    }

    public void saveFITSTable(TableQueryResult table) {
        FITSImage fitsImage = this.getFitsImage();
        if (fitsImage == null) {
            DialogUtil.error((Component)this, "This operation is only supported on FITS files.");
            return;
        }
        try {
            TableQueryResult newTable = NavigatorFITSTable.saveWithImage(this.getFilename(), fitsImage.getFits(), table);
            if (newTable == null) {
                return;
            }
            this.setSaveNeeded(true);
            this.checkExtensions(true);
            TablePlotter plotter = this._navigator.getPlotter();
            if (plotter != null) {
                plotter.unplot(table);
                this._navigator.setQueryResult(newTable.getCatalog());
            }
        }
        catch (Exception e) {
            DialogUtil.error((Component)this, e);
        }
    }

    protected void showNavigatorFrame(Catalog cat) {
        if (cat != null) {
            this._navigator.setAutoQuery(true);
            this._navigator.setQueryResult(cat);
        } else {
            this._navigator.setAutoQuery(false);
            SwingUtil.showFrame(this._navigatorFrame);
        }
    }

    protected void makeNavigatorFrame() {
        this._navigator = NavigatorManager.create();
        this._navigatorFrame = SwingUtil.getFrame(this._navigator);
        this._navigator.setImageDisplay(this);
    }

    @Override
    protected void newImage(boolean before) {
        super.newImage(before);
        if (!before) {
            if (this._navigatorFrame == null) {
                this.makeNavigatorFrame();
            }
            if (this._navigatorFrame != null) {
                TablePlotter plotter = this._navigator.getPlotter();
                if (plotter != null) {
                    plotter.replotAll();
                }
                String filename = this.getFilename();
                FITSImage fitsImage = this.getFitsImage();
                if (fitsImage != null && filename != null && !this._filesVisited.contains(filename)) {
                    this._filesVisited.add(filename);
                    try {
                        NavigatorFITSTable.plotTables(filename, fitsImage.getFits(), this._navigator);
                    }
                    catch (Exception e) {
                        DialogUtil.error((Component)this, e);
                    }
                }
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._navigatorFrame != null) {
            this._navigatorFrame.dispose();
        }
    }

    @Override
    protected void transformGraphics(AffineTransform trans) {
        TablePlotter plotter;
        super.transformGraphics(trans);
        if (this._navigator != null && (plotter = this._navigator.getPlotter()) != null) {
            plotter.transformGraphics(trans);
        }
    }

    public void saveCatalogOverlaysWithImage() {
        TableQueryResult[] tables;
        TablePlotter plotter;
        if (this._navigator != null && (plotter = this._navigator.getPlotter()) != null && (tables = plotter.getTables()) != null) {
            for (TableQueryResult table : tables) {
                this.saveFITSTable(table);
            }
        }
    }

    @Override
    protected void pickedObject() {
        if (this._navigatorFrame == null) {
            this.makeNavigatorFrame();
        }
        if (this._navigator == null) {
            return;
        }
        PickObjectStatistics stats = this.getPickObjectPanel().getStatistics();
        if (stats == null) {
            DialogUtil.error("No object was selected");
            return;
        }
        this._navigator.addPickedObjectToTable(stats, this.getPickObjectPanel().isUpdate());
    }

    public AbstractAction getCatalogBrowseAction() {
        return this._catalogBrowseAction;
    }

    public AbstractAction getGridAction() {
        return this._gridAction;
    }

    public QueryResult filterQueryResult(QueryResult queryResult) {
        return queryResult;
    }
}

