/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;

abstract class ArrayWriter {
    private final char formatChar_;
    private final int nByte_;

    protected ArrayWriter(char formatChar, int nByte) {
        this.formatChar_ = formatChar;
        this.nByte_ = nByte;
    }

    public char getFormatChar() {
        return this.formatChar_;
    }

    public int getByteCount() {
        return this.nByte_;
    }

    public abstract void writeElement(DataOutput var1, Object var2, int var3) throws IOException;

    public abstract void writePad(DataOutput var1) throws IOException;

    public abstract double getZero();

    public static ArrayWriter createArrayWriter(Class clazz, boolean allowSignedByte) {
        if (clazz == [Z.class) {
            return new ArrayWriter('L', 1){

                public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                    out.writeByte(((boolean[])array)[ix] ? 84 : 70);
                }

                public void writePad(DataOutput out) throws IOException {
                    out.writeByte(0);
                }

                public double getZero() {
                    return Double.NaN;
                }
            };
        }
        if (clazz == [B.class) {
            if (allowSignedByte) {
                return new NormalArrayWriter('B', 1, new byte[]{0}){

                    public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                        out.writeByte(((byte[])array)[ix] ^ 0xFFFFFF80);
                    }

                    public double getZero() {
                        return -128.0;
                    }
                };
            }
            return new NormalArrayWriter('I', 2, new byte[]{0}){

                public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                    out.writeShort(((byte[])array)[ix]);
                }
            };
        }
        if (clazz == [S.class) {
            return new NormalArrayWriter('I', 2, new short[]{0}){

                public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                    out.writeShort(((short[])array)[ix]);
                }
            };
        }
        if (clazz == [I.class) {
            return new NormalArrayWriter('J', 4, new int[]{0}){

                public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                    out.writeInt(((int[])array)[ix]);
                }
            };
        }
        if (clazz == [J.class) {
            return new NormalArrayWriter('K', 8, new long[]{0L}){

                public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                    out.writeLong(((long[])array)[ix]);
                }
            };
        }
        if (clazz == [F.class) {
            return new NormalArrayWriter('E', 4, new float[]{Float.NaN}){

                public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                    out.writeFloat(((float[])array)[ix]);
                }
            };
        }
        if (clazz == [D.class) {
            return new NormalArrayWriter('D', 8, new double[]{Double.NaN}){

                public void writeElement(DataOutput out, Object array, int ix) throws IOException {
                    out.writeDouble(((double[])array)[ix]);
                }
            };
        }
        return null;
    }

    private static abstract class NormalArrayWriter
    extends ArrayWriter {
        private final Object pad1_;

        protected NormalArrayWriter(char formatChar, int nByte, Object pad1) {
            super(formatChar, nByte);
            this.pad1_ = pad1;
            if (Array.getLength(pad1) != 1) {
                throw new IllegalArgumentException();
            }
        }

        public void writePad(DataOutput out) throws IOException {
            this.writeElement(out, this.pad1_, 0);
        }

        public double getZero() {
            return 0.0;
        }
    }
}

