/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class OUSLocator {
    private Optional<Integer> tuning = Optional.empty();
    private Optional<ObsUnitSet> rootOUS = Optional.empty();
    private Optional<ScienceGoal> scienceGoal = Optional.empty();
    private boolean isSimultaneous12and7mObservation = false;

    public OUSLocator(Builder builder) throws UnableToLocateObsUnitSetException {
        this.rootOUS = builder.rootOUS;
        this.tuning = builder.tuning;
        this.scienceGoal = builder.scienceGoal;
        this.isSimultaneous12and7mObservation = builder.simultaneous12and7mObservation;
        if (!this.rootOUS.isPresent()) {
            throw new UnableToLocateObsUnitSetException("root OUS has not been supplied");
        }
        if (!this.scienceGoal.isPresent()) {
            throw new UnableToLocateObsUnitSetException("Science goal has not been specified");
        }
        if (this.tuning.isPresent()) {
            throw new UnsupportedOperationException("Tuning selections are not supported currently");
        }
    }

    public List<ObsUnitSet> locateOUS() throws UnableToLocateObsUnitSetException {
        ArrayList<ObsUnitSet> arrayList = new ArrayList<ObsUnitSet>();
        int n = this.getClusterIndex(this.scienceGoal) - 1;
        assert (n >= 0);
        assert (this.rootOUS.isPresent());
        ObsUnitSet obsUnitSet = this.rootOUS.get();
        if (obsUnitSet.getObsUnitSetCount() < n) {
            throw new UnableToLocateObsUnitSetException("Unable to locate group OUS corresponding to cluster " + n + " for the first visit");
        }
        if (this.isSimultaneous12and7mObservation) {
            for (ObsUnitSet obsUnitSet2 : obsUnitSet.getObsUnitSet()) {
                ArrayList<SchedBlock> arrayList2 = new ArrayList<SchedBlock>();
                SchedBlockWorker.findSBsUnderOUS(arrayList2, obsUnitSet2);
                assert (!arrayList2.isEmpty());
                if (!this.isSBsFromRequestedCluster(arrayList2, n)) continue;
                arrayList.add(obsUnitSet2);
            }
        } else {
            arrayList.add(obsUnitSet.getObsUnitSet(n));
        }
        if (Log.logger(OUSLocator.class).fine()) {
            for (ObsUnitSet obsUnitSet3 : arrayList) {
                ArrayList<SchedBlock> arrayList3 = new ArrayList<SchedBlock>();
                SchedBlockWorker.findSBsUnderOUS(arrayList3, obsUnitSet3).stream().forEach(schedBlock -> Log.logger(OUSLocator.class).fine("schedBlock " + schedBlock));
            }
        }
        return arrayList;
    }

    private boolean isSBsFromRequestedCluster(@NonNull List<SchedBlock> list, int n) {
        if (list == null) {
            throw new NullPointerException("schedblocks is marked non-null but is null");
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException("Illegal argument: schedblocks.size() (" + list.size() + ") did not pass the test: schedblocks.size() == 0");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Illegal argument: clusterIndex (" + n + ") did not pass the test: clusterIndex < 0");
        }
        for (SchedBlock schedBlock : list) {
            int n2 = -1;
            try {
                n2 = schedBlock.getSbGenerationContext().getGoal().getClusterIndex();
            }
            catch (ScienceGoal.NotClusteredScienceGoalException notClusteredScienceGoalException) {
                return true;
            }
            if (n2 == n + 1) continue;
            return false;
        }
        return true;
    }

    private int getClusterIndex(Optional<ScienceGoal> optional) throws UnableToLocateObsUnitSetException {
        int n;
        if (!optional.isPresent()) {
            throw new UnableToLocateObsUnitSetException("Science goal has not been specified");
        }
        ScienceGoal scienceGoal = optional.get();
        try {
            n = scienceGoal.getClusterIndex();
        }
        catch (ScienceGoal.NotClusteredScienceGoalException notClusteredScienceGoalException) {
            n = 1;
        }
        return n;
    }

    public static class Builder {
        private Optional<Integer> tuning = Optional.empty();
        private Optional<ObsUnitSet> rootOUS = Optional.empty();
        private Optional<ScienceGoal> scienceGoal = Optional.empty();
        private boolean simultaneous12and7mObservation = false;

        public Builder scienceGoal(ScienceGoal scienceGoal) {
            this.scienceGoal = Optional.of(scienceGoal);
            return this;
        }

        public Builder tuning(@NonNull Integer n) {
            if (n == null) {
                throw new NullPointerException("tuning is marked non-null but is null");
            }
            this.tuning = Optional.of(n);
            return this;
        }

        public Builder rootOUS(@NonNull ObsUnitSet obsUnitSet) {
            if (obsUnitSet == null) {
                throw new NullPointerException("rootOUS is marked non-null but is null");
            }
            this.rootOUS = Optional.of(obsUnitSet);
            return this;
        }

        public OUSLocator build() throws UnableToLocateObsUnitSetException {
            return new OUSLocator(this);
        }

        public Builder simultaneousArrayOperation(boolean bl) {
            this.simultaneous12and7mObservation = bl;
            return this;
        }
    }

    public static class UnableToLocateObsUnitSetException
    extends Exception {
        public UnableToLocateObsUnitSetException(String string) {
            super(string);
        }
    }
}

