/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.ObsProjectRefT;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.hla.runtime.obsprep.interfaces.ModelStructureListener;
import alma.hla.runtime.obsprep.interfaces.ModelStructureNotifier;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.HashCodeGeneratorInterface;
import alma.obsprep.bo.annotations.GUIScienceGoalAcceptor;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.HistoricalProjectRefresher;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SubmissionRecord;
import alma.obsprep.bo.obsproject.data.ObsProjectData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.valdef.ValidatorSet;
import alma.obsprep.util.MiscUtils;
import alma.scheduling.projectstatus.StatusBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import lombok.NonNull;

public class ObsProject
extends ObsProjectData
implements HashCodeGeneratorInterface,
ModelStructureNotifier,
GUIScienceGoalAcceptor {
    private int objectHash = -1;
    public static final String NOPROJECTCODEASSIGNED = "None Assigned";
    private final transient Vector<ModelStructureListener> listeners = new Vector();
    private volatile transient ModelStructureListener[] listeners_ro = new ModelStructureListener[0];

    public ObsProject(alma.entity.xmlbinding.obsproject.ObsProject obsProject) {
        super(obsProject);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setPI("");
        this.setProjectName("");
        this.setVersion("0");
        this.setManualMode(false);
        this.setSimulationMode(false);
        this.setIsCalibration(false);
        this.setIsCommissioning(false);
        this.setObsProgram(ObsProgram.createObsProgram());
        this.setObsProposal(null);
    }

    protected void initEntityReferencesFrom(IBusinessObject iBusinessObject, Copier copier) throws CopyException {
        super.initEntityReferencesFrom(iBusinessObject, copier);
        this.setProjectStatus(null);
        this.setStatus(STATUS_NEWPHASE2);
    }

    public ObsProjectRefT getReference() {
        ObsProjectRefT obsProjectRefT = super.getReference();
        obsProjectRefT.setDocumentVersion("1");
        return obsProjectRefT;
    }

    public String toTreeString(int n, boolean bl, boolean bl2) {
        String string = this.getProjectName();
        if (string.equals("")) {
            string = "Project";
        }
        return string;
    }

    public void setObsProposal(ObsProposal obsProposal) {
        super.setObsProposal(obsProposal);
        if (obsProposal != null) {
            obsProposal.setObsProject(this);
        }
    }

    public Object[][] getSubmissionRecordTable() {
        Object[][] objectArray = new String[this.getSubmissionRecordCount()][];
        for (int i = 0; i < objectArray.length; ++i) {
            SubmissionRecord submissionRecord = this.getSubmissionRecord(i);
            objectArray[objectArray.length - 1 - i] = new String[]{submissionRecord.getSubmissionTime(), submissionRecord.getSubmitter()};
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelStructureListener(ModelStructureListener modelStructureListener) {
        Vector<ModelStructureListener> vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(modelStructureListener);
            Object[] objectArray = new ModelStructureListener[this.listeners.size()];
            this.listeners.copyInto(objectArray);
            this.listeners_ro = objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelStructureListener(ModelStructureListener modelStructureListener) {
        Vector<ModelStructureListener> vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(modelStructureListener);
            Object[] objectArray = new ModelStructureListener[this.listeners.size()];
            this.listeners.copyInto(objectArray);
            this.listeners_ro = objectArray;
        }
    }

    public void fireBusinessObjectAddedTo(IBusinessObject iBusinessObject, IBusinessObject iBusinessObject2, Referring.By by, int n) {
        ModelStructureListener[] modelStructureListenerArray;
        for (ModelStructureListener modelStructureListener : modelStructureListenerArray = this.listeners_ro) {
            modelStructureListener.businessObjectAddedTo(iBusinessObject, iBusinessObject2, by, n);
        }
    }

    public void fireBusinessObjectRemovedFrom(IBusinessObject iBusinessObject, IBusinessObject iBusinessObject2, Referring.By by) {
        ModelStructureListener[] modelStructureListenerArray;
        for (ModelStructureListener modelStructureListener : modelStructureListenerArray = this.listeners_ro) {
            modelStructureListener.businessObjectRemovedFrom(iBusinessObject, iBusinessObject2, by);
        }
    }

    public ObsProgram placeToAdd() {
        return this.getObsProgram();
    }

    @Override
    public void removeScienceGoal(AbstractScienceGoal abstractScienceGoal) {
        this.placeToAdd().removeScienceGoal(abstractScienceGoal);
    }

    public Set<BusinessObject> getAllBusinessObjects() {
        HashSet<BusinessObject> hashSet = new HashSet<BusinessObject>();
        this.findAllBusinessObjects((BusinessObject)this, hashSet);
        return hashSet;
    }

    private void findAllBusinessObjects(BusinessObject businessObject, Set<BusinessObject> set) {
        if (businessObject == null || businessObject instanceof StatusBase) {
            return;
        }
        if (set.contains(businessObject)) {
            return;
        }
        set.add(businessObject);
        List list = businessObject.associatedObjects();
        for (BusinessObject businessObject2 : list) {
            this.findAllBusinessObjects(businessObject2, set);
        }
    }

    public static Collection<String> getCsvStates() {
        return Set.of(STATUS_CSVREADY, STATUS_CSVRUNNING, STATUS_CSVSUSPENDED);
    }

    public static Collection<String> getOperationalStates() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(ObsProject.getKnownStatusList()));
        hashSet.removeAll(ObsProject.getCsvStates());
        return hashSet;
    }

    public static Collection<String> getSubmittableStates() {
        return List.of(STATUS_NEWPHASE1, STATUS_NEWPHASE2, STATUS_APPROVED, STATUS_BROKEN);
    }

    public static Collection<String> getPIP1SGEditableStates() {
        return List.of(STATUS_NEWPHASE1, STATUS_PHASE1SUBMITTED);
    }

    public boolean isNewProject() {
        return this.getStatus().equals(STATUS_NEWPHASE1) || this.getStatus().equals(STATUS_NEWPHASE2);
    }

    public boolean isProjectWithStatus(String ... stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("statii is marked non-null but is null");
        }
        String string = this.getStatus();
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public void resetAfterImport() {
        HistoricalProjectRefresher historicalProjectRefresher = new HistoricalProjectRefresher(this);
        historicalProjectRefresher.applyCurrentCycleConstraints();
    }

    public void updateRevisionNumberToCurrent() throws UnableToGetDocumentRevisionNumberException {
        String string = MiscUtils.getCurrentDocumentRevisionNumber();
        alma.entity.xmlbinding.obsproject.ObsProject obsProject = this.getCastorObject();
        obsProject.setRevision(string);
    }

    public boolean isRevisionNumberOfProjectCurrent() {
        String string;
        try {
            string = MiscUtils.getCurrentDocumentRevisionNumber();
        }
        catch (UnableToGetDocumentRevisionNumberException unableToGetDocumentRevisionNumberException) {
            Log.logger(ObsProject.class).warning("Unable to determine the current document revision number");
            return false;
        }
        return this.getCastorObject().getRevision().equals(string);
    }

    public static List<SchedBlock> getAllSBsInProject() {
        ObsProject obsProject = ImpexFactory.getInstance().getLastObsProjectLoaded();
        if (obsProject == null) {
            obsProject = ObservingToolController.getOTGui().getPrimaryProject();
        }
        List<SchedBlock> list = obsProject.getAllBusinessObjects().stream().filter(businessObject -> businessObject instanceof SchedBlock).map(businessObject -> (SchedBlock)businessObject).toList();
        return list;
    }

    public static boolean isPhase2Project(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        return !string.equals(ObsProjectData.STATUS_PHASE1SUBMITTED) && !string.equals(ObsProjectData.STATUS_REJECTED) && !string.equals(ObsProjectData.STATUS_NEWPHASE1);
    }

    public boolean isDPRRequired() {
        ObsProposal obsProposal;
        try {
            obsProposal = this.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            return false;
        }
        if (obsProposal == null) {
            return false;
        }
        return !this.getIsDDT() && !obsProposal.isLargeProgram();
    }

    public List<ScienceGoal> getPhaseApplicableScienceGoals() throws UnknownEntityException {
        boolean bl = ObsProject.isPhase2Project(this.getStatus());
        List<ScienceGoal> list = new ArrayList<ScienceGoal>();
        if (bl) {
            ObsProgram obsProgram = this.getObsProgram();
            if (obsProgram != null) {
                list = Arrays.asList(obsProgram.getAbstractScienceGoalScienceGoal());
            }
        } else {
            ObsProposal obsProposal = this.getObsProposal();
            if (obsProposal != null) {
                list = Arrays.asList(obsProposal.getAbstractScienceGoalScienceGoal());
            }
        }
        return list;
    }

    @Override
    public void generateObjectHash() {
        int n = 0;
        try {
            n = Objects.hashCode(ValidatorSet.removeEntityIDs(this.getObsProposal().toXml()));
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        this.objectHash = Objects.hashCode(this.toXml()) + n;
    }

    public boolean isPhase1Project() {
        String string = this.getStatus();
        return string == ObsProjectData.STATUS_NEWPHASE1 || string == ObsProjectData.STATUS_PHASE1SUBMITTED;
    }

    @Override
    public int getObjectHash() {
        return this.objectHash;
    }

    public static class UnableToGetDocumentRevisionNumberException
    extends Exception {
    }
}

