/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.SinglePointT;
import alma.obsprep.bo.obsproject.data.SinglePointData;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;

public class SinglePoint
extends SinglePointData {
    public String toString() {
        return "SinglePoint [lat(arcsec)=" + Double.toString(this.getCentre().getLatitude().getContentInUnits(Angle.UNIT_ARCSEC)) + " long(arcsec)=" + Double.toString(this.getCentre().getLongitude().getContentInUnits(Angle.UNIT_ARCSEC)) + "]";
    }

    public SinglePoint(SinglePointT singlePointT) {
        super(singlePointT);
    }

    public static SinglePoint createSinglePoint(SkyCoordinates skyCoordinates) {
        SinglePoint singlePoint = SinglePoint.createSinglePoint();
        singlePoint.setCentre(skyCoordinates);
        return singlePoint;
    }

    public boolean isPointingPattern() {
        return true;
    }

    public boolean isAbsolutePointingPattern() {
        return this.getCentre().isAbsoluteCoordinates();
    }

    public boolean isOffsetPointingPattern() {
        return this.getCentre().isOffsetCoordinates();
    }

    public FieldPattern.FieldPatternType getFieldPatternType() {
        return FieldPattern.FieldPatternType.POINT;
    }
}

