/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.common.calibratorCatalogue.calQueryParameters.types.CalibrationUseType;
import alma.entity.xmlbinding.schedblock.QuerySourceT;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.data.QuerySourceData;
import alma.valuetypes.Angle;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import lombok.NonNull;

public class QuerySource
extends QuerySourceData
implements IQuerySource {
    @NonNull
    String sourceName;
    private TargetParameters keyTargetParameters;

    public QuerySource(QuerySourceT querySourceT) {
        super(querySourceT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setUse(CalibrationUseType.UNDEFINED.toString());
        this.setMinFrequency(Frequency.createFrequencyGHZ(0.0));
        this.setMaxFrequency(Frequency.createFrequencyGHZ(0.0));
        this.setMinFlux(Flux.createFlux((double)0.0, (String)Flux.UNIT_JY));
        this.setMaxFlux(Flux.createFlux((double)0.0, (String)Flux.UNIT_JY));
        this.setMinTimeSinceObserved(Time.createTime((double)0.0, (String)Time.UNIT_D));
        this.setMaxTimeSinceObserved(Time.createTime((double)0.0, (String)Time.UNIT_D));
    }

    public void setSearchFrequenciesFromSB(SchedBlock schedBlock) {
        SpectralSpec[] spectralSpecArray = schedBlock.getSpectralSpec();
        if (spectralSpecArray.length > 0) {
            SpectralSpec spectralSpec = spectralSpecArray[0];
            ReceiverBand receiverBand = spectralSpec.getReceiverBand();
            double d = receiverBand.getRFMin();
            double d2 = receiverBand.getRFMax();
            this.setMinFrequency(Frequency.createFrequencyGHZ(d));
            this.setMaxFrequency(Frequency.createFrequencyGHZ(d2));
        }
    }

    public static QuerySource createQuerySource(alma.obsprep.bo.obsproject.QuerySource querySource) {
        QuerySource querySource2 = QuerySource.createQuerySource();
        Object object = querySource.gettrueMaxFlux();
        if (object != null && querySource.gettrueMaxFlux().hasContent()) {
            querySource2.setMaxFlux((Flux)object.deepCopy());
        } else {
            querySource2.setMaxFlux(Flux.createFlux((double)0.0, (String)Flux.UNIT_JY));
        }
        object = querySource.gettrueMaxFrequency();
        if (object != null && querySource.gettrueMaxFrequency().hasContent()) {
            querySource2.setMaxFrequency((Frequency)object.deepCopy());
        } else {
            querySource2.setMaxFrequency(Frequency.createFrequencyGHZ(0.0));
        }
        object = querySource.gettrueMaxTimeSinceObserved();
        if (object != null && querySource.gettrueMaxTimeSinceObserved().hasContent()) {
            querySource2.setMaxTimeSinceObserved((Time)object.deepCopy());
        } else {
            querySource2.setMaxTimeSinceObserved(Time.createTime((double)0.0, (String)Time.UNIT_D));
        }
        object = querySource.gettrueMinFlux();
        if (object != null && querySource.gettrueMinFlux().hasContent()) {
            querySource2.setMinFlux((Flux)object.deepCopy());
        } else {
            querySource2.setMinFlux(Flux.createFlux((double)0.0, (String)Flux.UNIT_JY));
        }
        object = querySource.gettrueMinFrequency();
        if (object != null && querySource.gettrueMinFrequency().hasContent()) {
            querySource2.setMinFrequency((Frequency)object.deepCopy());
        } else {
            querySource2.setMinFrequency(Frequency.createFrequencyGHZ(0.0));
        }
        object = querySource.gettrueMinTimeSinceObserved();
        if (object != null && querySource.gettrueMinTimeSinceObserved().hasContent()) {
            querySource2.setMinTimeSinceObserved((Time)object.deepCopy());
        } else {
            querySource2.setMinTimeSinceObserved(Time.createTime((double)0.0, (String)Time.UNIT_D));
        }
        object = querySource.gettrueQueryCenter();
        if (object != null) {
            querySource2.setQueryCenter((SkyCoordinates)object.deepCopy());
        }
        if ((object = querySource.gettrueSearchRadius()) != null) {
            querySource2.setSearchRadius((Angle)object.deepCopy());
        }
        if ((object = querySource.getKeyTargetParameters()) != null) {
            querySource2.setKeyTargetParameters((TargetParameters)object.deepCopy());
        }
        querySource2.setSourceName(querySource.getSourceName());
        querySource2.setMaxSources(querySource.getMaxSources());
        String string = querySource.gettrueUse();
        if (string != null) {
            querySource2.setUse(string);
        }
        return querySource2;
    }

    @Override
    @NonNull
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public void setSourceName(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("sourceName is marked non-null but is null");
        }
        this.sourceName = string;
    }

    public void setKeyTargetParameters(TargetParameters targetParameters) {
        this.keyTargetParameters = targetParameters;
    }

    public TargetParameters getKeyTargetParameters() {
        return this.keyTargetParameters;
    }
}

