/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.events.examples;

import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventType;
import java.util.Date;

public class Example4 {
    public static final int COUNT_SYNC = 1000000;
    public static final int COUNT_ASYNC = 1000000;
    public static final EventType SYNC = new EventType("sync");
    public static final EventType ASYNC = new EventType("async", 1);

    public void run() {
        int n;
        Receiver receiver = new Receiver();
        Sender sender = new Sender();
        EventManager.subscribeBySrc(sender, receiver);
        long l = new Date().getTime();
        for (n = 0; n < 1000000; ++n) {
            sender.sendSync();
        }
        long l2 = new Date().getTime();
        double d = (l2 - l) * 1000L;
        String string = "SYNC:  iterations=1000000 musec=" + d + " musec/iteration=" + d / 1000000.0;
        System.out.println(string);
        l = new Date().getTime();
        for (n = 0; n < 1000000; ++n) {
            sender.sendAsync();
        }
        l2 = new Date().getTime();
        d = (l2 - l) * 1000L;
        string = "ASYNC: iterations=1000000 musec=" + d + " musec/iteration=" + d / 1000000.0;
        System.out.println(string);
        EventManager.finish();
    }

    public static void main(String[] stringArray) {
        Example4 example4 = new Example4();
        example4.run();
    }

    private class Receiver
    implements EventReceiver {
        private Receiver() {
        }

        @Override
        public void receiveEvent(Event event) {
        }
    }

    private class Sender {
        Event sync = new Event(SYNC, this, null);
        Event async = new Event(SYNC, this, null);

        private Sender() {
        }

        public void sendSync() {
            EventManager.publish(this.sync);
        }

        public void sendAsync() {
            EventManager.publish(this.async);
        }
    }
}

