/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.BOUtilities;
import alma.obsprep.bo.FieldSourceCollection;
import alma.obsprep.bo.InstrumentSpecCollection;
import alma.obsprep.bo.ObservingParametersCollection;
import alma.obsprep.bo.OusCollection;
import alma.obsprep.bo.PhaseISciencePlanCollection;
import alma.obsprep.bo.ResourceCollection;
import alma.obsprep.bo.TargetCollection;
import alma.obsprep.bo.annotations.GUIScienceGoalAcceptor;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsPhase;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.OpticalPointingScienceGoal;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.data.ControlBlockData;
import alma.obsprep.bo.obsproject.data.ObsUnitSetData;
import alma.obsprep.bo.obsproject.data.OpticalPointingScienceGoalData;
import alma.obsprep.bo.obsproject.data.ScienceGoalData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.HolographyParameters;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedBlockControl;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SquareLawSetup;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.data.SchedBlockData;
import alma.obsprep.bo.schedblock.data.SpectralSpecData;
import alma.obsprep.bo.schedblock.data.SquareLawSetupData;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.AddInteractor;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.obsproject.ObsProposalModel;
import alma.obsprep.services.experts.ObservingModeExpert;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Time;
import alma.valuetypes.data.TimeData;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.EnumSet;
import lombok.NonNull;

public class AddPerformer
extends Performer {
    private static DialogId DIALOG_ADD = new DialogId("Add.Confirm");

    public AddPerformer(AddInteractor addInteractor) {
        super(addInteractor);
    }

    @Override
    public void perform() {
        AddInteractor addInteractor = (AddInteractor)this.getGui();
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (!this.confirmAdd(businessObject)) {
            return;
        }
        Object object = null;
        AddInteractor.ObjectType objectType = addInteractor.whatType();
        object = switch (objectType) {
            case AddInteractor.ObjectType.SCHEDBLOCK -> this.performAddSB(addInteractor);
            case AddInteractor.ObjectType.OBSUNITSET -> this.performAddOUS(addInteractor);
            case AddInteractor.ObjectType.OBSERVINGGROUP -> this.performAddObservingGroup(addInteractor);
            case AddInteractor.ObjectType.TARGET -> this.performAddTarget(addInteractor);
            case AddInteractor.ObjectType.FIELDSOURCE -> this.performAddFieldSource(addInteractor);
            case AddInteractor.ObjectType.BLSPECTRALSPEC, AddInteractor.ObjectType.ACASPECTRALSPEC, AddInteractor.ObjectType.SQUARELAWSPECTRALSPEC -> this.performAddSpectralSpec(addInteractor);
            case AddInteractor.ObjectType.OPTICALCAMERASPEC -> this.performAddOpticalCameraSpec(addInteractor);
            case AddInteractor.ObjectType.SCIENCEPARAMETERS, AddInteractor.ObjectType.PHASECALPARAMETERS, AddInteractor.ObjectType.POINTINGCALPARAMETERS, AddInteractor.ObjectType.AMPLITUDECALPARAMETERS, AddInteractor.ObjectType.POLARIZATIONCALPARAMETERS, AddInteractor.ObjectType.FOCUSCALPARAMETERS, AddInteractor.ObjectType.ATMOSPHERICCALPARAMETERS, AddInteractor.ObjectType.DELAYCALPARAMETERS, AddInteractor.ObjectType.CHECKSOURCECALPARAMETERS, AddInteractor.ObjectType.DGCREFERENCECALPARAMETERS, AddInteractor.ObjectType.DGCSCIENCECALPARAMETERS, AddInteractor.ObjectType.SIDEBANDRATIOCALPARAMETERS, AddInteractor.ObjectType.BANDPASSCALPARAMETERS, AddInteractor.ObjectType.OPTICALPOINTINGPARAMETERS, AddInteractor.ObjectType.RADIOMETRICPOINTINGPARAMETERS, AddInteractor.ObjectType.HOLOGRAPHYPARAMETERS -> this.performAddObservingParameters(addInteractor);
            case AddInteractor.ObjectType.OPTICALPOINTINGWIZARD -> this.performAddOpticalPointingScienceGoal(addInteractor);
            case AddInteractor.ObjectType.SCIENCEGOAL -> this.performAddScienceGoal(addInteractor);
            case AddInteractor.ObjectType.CALIBRATORSURVEYWIZARD -> this.performAddCalibratorSurveyGoal(addInteractor);
            case AddInteractor.ObjectType.RADIOMETRICPOINTINGWIZARD -> this.performAddRadiometricPointingGoal(addInteractor);
            case AddInteractor.ObjectType.BASELINECALIBRATIONWIZARD -> this.performAddBaselineCalibrationGoal(addInteractor);
            case AddInteractor.ObjectType.HOLOGRAPHYSETUP -> this.performAddHolographySetup(addInteractor);
            case AddInteractor.ObjectType.ASTROHOLOGRAPHYSETUP -> this.performAddAstroHolographySetup(addInteractor);
            case AddInteractor.ObjectType.PHASEISCIENCEGOAL -> this.performAddPhaseIScienceGoal(addInteractor);
            default -> throw new RuntimeException("Invalid Business Object type: " + addInteractor.whatType());
        };
        if (object != null) {
            addInteractor.updateDisplay(businessObject, (BusinessObject)object, -1);
        }
        ActionLog.performed(new Object[]{"Add", objectType, "to", businessObject});
    }

    private ObsUnitSet performAddOUS(AddInteractor addInteractor) {
        ObsUnitSet obsUnitSet = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (businessObject.getClass().equals(ObsUnitSet.class)) {
            ObsUnitSet obsUnitSet2 = (ObsUnitSet)businessObject;
            obsUnitSet = ObsUnitSetData.createObsUnitSet();
            obsUnitSet2.addObsUnitSet(obsUnitSet);
            return obsUnitSet;
        }
        if (businessObject.getClass().equals(ObsProgram.class)) {
            ObsProgram obsProgram = (ObsProgram)businessObject;
            obsUnitSet = ObsUnitSetData.createObsUnitSet();
            obsProgram.getObsPlan().addObsUnitSet(obsUnitSet);
            return obsUnitSet;
        }
        if (businessObject.getClass().equals(OusCollection.class)) {
            ObsProgram obsProgram = ((OusCollection)businessObject).getObsProgram();
            obsUnitSet = ObsUnitSetData.createObsUnitSet();
            obsProgram.getObsPlan().addObsUnitSet(obsUnitSet);
            return obsUnitSet;
        }
        addInteractor.error("Cannot add an ObsUnitSet to " + businessObject.getNameOrDefault());
        return null;
    }

    private SchedBlock performAddSB(AddInteractor addInteractor) {
        SchedBlock schedBlock = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (businessObject.getClass().equals(ObsUnitSet.class)) {
            ObsUnitSet obsUnitSet = (ObsUnitSet)businessObject;
            schedBlock = SchedBlockData.createSchedBlock();
            obsUnitSet.addSchedBlock(schedBlock);
            return schedBlock;
        }
        if (businessObject.getClass().equals(ObsProgram.class)) {
            ObsProgram obsProgram = (ObsProgram)businessObject;
            ObsUnitSet obsUnitSet = obsProgram.getObsPlan();
            schedBlock = SchedBlockData.createSchedBlock();
            schedBlock = SchedBlockData.createSchedBlock();
            obsUnitSet.addSchedBlock(schedBlock);
            return schedBlock;
        }
        addInteractor.error("Cannot add a Scheduling Block to " + businessObject.getNameOrDefault());
        return null;
    }

    private OpticalPointingScienceGoal performAddOpticalPointingScienceGoal(AddInteractor addInteractor) {
        BusinessObject businessObject = addInteractor.getSelectedBO();
        OpticalPointingScienceGoal opticalPointingScienceGoal = null;
        try {
            GUIScienceGoalAcceptor gUIScienceGoalAcceptor = (GUIScienceGoalAcceptor)businessObject;
            ObsPhase obsPhase = gUIScienceGoalAcceptor.placeToAdd();
            opticalPointingScienceGoal = OpticalPointingScienceGoalData.createOpticalPointingScienceGoal();
            obsPhase.addAbstractScienceGoal((AbstractScienceGoal)((Object)opticalPointingScienceGoal));
            addInteractor.updateDisplay((BusinessObject)obsPhase, (BusinessObject)opticalPointingScienceGoal, -1);
        }
        catch (ClassCastException classCastException) {
            addInteractor.error("Cannot add an optical pointing wizard parameters to " + businessObject.getNameOrDefault());
        }
        return null;
    }

    private HolographyParameters performAddHolographySetup(AddInteractor addInteractor) {
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (!(businessObject instanceof ObsProgram)) {
            String string = "Unexpected node for Holography Setup : " + businessObject.getClass().getSimpleName();
            Log.logger((Object)this).warning(string);
            return null;
        }
        HolographyParameters holographyParameters = null;
        ObsUnitSet obsUnitSet = this.performAddOUS(addInteractor);
        if (obsUnitSet != null) {
            SchedBlock schedBlock = SchedBlockData.createSchedBlock();
            ObservingModeExpert observingModeExpert = ObservingModeExpert.getInstance();
            schedBlock.setModeName("Tower Holography");
            SBGenerationContext sBGenerationContext = new SBGenerationContext();
            sBGenerationContext.setSBType(SBGeneratorTemplate.SchedBlockType.SCHEDBLOCKTYPEUNKNOWN).setSBGenerationSchema(EnumSet.of(SBGeneratorTemplate.SBGenerationSchema.OBSERVATORYGOAL));
            schedBlock.setSbGenerationContext(sBGenerationContext);
            observingModeExpert.updateSchedBlock(schedBlock, "Tower Holography");
            SchedBlockControl schedBlockControl = schedBlock.getSchedBlockControl();
            schedBlockControl.setIndefiniteRepeat(true);
            schedBlockControl.setSBMaximumTime(Time.createTimeSec(1800.0));
            schedBlock.getObsUnitControl().setMaximumTime(Time.createTimeSec(1800.0));
            schedBlock.setName("Holography");
            obsUnitSet.addSchedBlock(schedBlock);
            holographyParameters = schedBlock.createHolographyParameters();
            schedBlock.getSchedulingConstraints().setRepresentativeFrequency(holographyParameters.getFrequency());
        }
        return holographyParameters;
    }

    private Target performAddAstroHolographySetup(AddInteractor addInteractor) {
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (!(businessObject instanceof ObsProgram)) {
            String string = "Unexpected node for Holography Setup : " + businessObject.getClass().getSimpleName();
            Log.logger((Object)this).warning(string);
            return null;
        }
        throw new RuntimeException("Astro-holography is no longer available (see ICT-2468)");
    }

    private ScienceGoal performAddCalibratorSurveyGoal(AddInteractor addInteractor) {
        BusinessObject businessObject = addInteractor.getSelectedBO();
        ObservatoryGoal observatoryGoal = null;
        try {
            GUIScienceGoalAcceptor gUIScienceGoalAcceptor = (GUIScienceGoalAcceptor)businessObject;
            ObsPhase obsPhase = gUIScienceGoalAcceptor.placeToAdd();
            observatoryGoal = ObservatoryGoal.createCalibratorSurveyGoal();
            obsPhase.addAbstractScienceGoal((AbstractScienceGoal)((Object)observatoryGoal));
            addInteractor.updateDisplay((BusinessObject)obsPhase, (BusinessObject)observatoryGoal, -1);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            addInteractor.error("Cannot add a calibrator survey wizard parameters: " + exception.getLocalizedMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(byteArrayOutputStream));
            Log.logger((Object)this).warning(((Object)byteArrayOutputStream).toString());
        }
        return null;
    }

    private ScienceGoal performAddRadiometricPointingGoal(AddInteractor addInteractor) {
        BusinessObject businessObject = addInteractor.getSelectedBO();
        ObservatoryGoal observatoryGoal = null;
        try {
            GUIScienceGoalAcceptor gUIScienceGoalAcceptor = (GUIScienceGoalAcceptor)businessObject;
            ObsPhase obsPhase = gUIScienceGoalAcceptor.placeToAdd();
            observatoryGoal = ObservatoryGoal.createRadiometricPointingGoal();
            obsPhase.addAbstractScienceGoal((AbstractScienceGoal)((Object)observatoryGoal));
            addInteractor.updateDisplay((BusinessObject)obsPhase, (BusinessObject)observatoryGoal, -1);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            addInteractor.error("Cannot add a calibrator survey wizard parameters: " + exception.getLocalizedMessage());
            PrintStream printStream = new PrintStream(new ByteArrayOutputStream());
            exception.printStackTrace(printStream);
            Log.logger((Object)this).warning(new ByteArrayOutputStream().toString());
        }
        return null;
    }

    private ScienceGoal performAddBaselineCalibrationGoal(AddInteractor addInteractor) {
        BusinessObject businessObject = addInteractor.getSelectedBO();
        ObservatoryGoal observatoryGoal = null;
        try {
            GUIScienceGoalAcceptor gUIScienceGoalAcceptor = (GUIScienceGoalAcceptor)businessObject;
            ObsPhase obsPhase = gUIScienceGoalAcceptor.placeToAdd();
            observatoryGoal = ObservatoryGoal.createBaselineCalibrationGoal();
            obsPhase.addAbstractScienceGoal((AbstractScienceGoal)((Object)observatoryGoal));
            addInteractor.updateDisplay((BusinessObject)obsPhase, (BusinessObject)observatoryGoal, -1);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            addInteractor.error("Cannot add a calibrator survey wizard parameters: " + exception.getLocalizedMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            Log.logger((Object)this).warning(((Object)byteArrayOutputStream).toString());
        }
        return null;
    }

    private ScienceGoal performAddScienceGoal(@NonNull AddInteractor addInteractor) {
        if (addInteractor == null) {
            throw new NullPointerException("gui is marked non-null but is null");
        }
        BusinessObject businessObject = addInteractor.getSelectedBO();
        ScienceGoal scienceGoal = null;
        try {
            GUIScienceGoalAcceptor gUIScienceGoalAcceptor = (GUIScienceGoalAcceptor)businessObject;
            ObsPhase obsPhase = gUIScienceGoalAcceptor.placeToAdd();
            scienceGoal = ScienceGoalData.createScienceGoal();
            TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
            scienceGoal.setTargetParameters(targetParameters);
            ObsProposal obsProposal = ObservingToolController.getMyInstance().getPrimaryProject().getObsProposal();
            if (obsProposal.isPhasedArray()) {
                ObsProposalModel.setVLBIPassivePhasing(obsProposal, true);
            }
            if (obsProposal.isVLBIorPhasedArray()) {
                VLBIExpert.setToVLBIDefaultSpectralConfiguration(scienceGoal);
            }
            obsPhase.addAbstractScienceGoal((AbstractScienceGoal)((Object)scienceGoal));
            addInteractor.updateDisplay((BusinessObject)obsPhase, (BusinessObject)scienceGoal, -1);
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {
            addInteractor.error("Cannot add a single field wizard parameters: " + exception.getLocalizedMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            Log.logger((Object)this).warning(((Object)byteArrayOutputStream).toString());
        }
        return null;
    }

    private ScienceGoal performAddPhaseIScienceGoal(AddInteractor addInteractor) {
        BusinessObject businessObject = addInteractor.getSelectedBO();
        ScienceGoal scienceGoal = null;
        try {
            ObsProposal obsProposal;
            if (businessObject instanceof PhaseISciencePlanCollection) {
                obsProposal = ((PhaseISciencePlanCollection)businessObject).getObsProposal();
            } else if (businessObject instanceof ObsProposal) {
                obsProposal = (ObsProposal)businessObject;
            } else if (businessObject instanceof ObsProject) {
                obsProposal = ((ObsProject)businessObject).getObsProposal();
            } else {
                return null;
            }
            scienceGoal = ScienceGoalData.createScienceGoal();
            obsProposal.addAbstractScienceGoal((AbstractScienceGoal)((Object)scienceGoal));
            if (obsProposal.isPhasedArray()) {
                ObsProposalModel.setVLBIPassivePhasing(obsProposal, true);
            }
            if (obsProposal.isVLBIorPhasedArray()) {
                VLBIExpert.setToVLBIDefaultSpectralConfiguration(scienceGoal);
            }
            addInteractor.updateDisplay((BusinessObject)obsProposal, (BusinessObject)scienceGoal, -1);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        catch (Exception exception) {
            addInteractor.error("Cannot add a single field wizard parameters: " + exception.getLocalizedMessage());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            Log.logger((Object)this).warning(((Object)byteArrayOutputStream).toString());
        }
        return null;
    }

    private BusinessObject performAddObservingGroup(AddInteractor addInteractor) {
        ObservingGroup observingGroup = null;
        SchedBlock schedBlock = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (businessObject instanceof SchedBlock) {
            schedBlock = (SchedBlock)businessObject;
        }
        if (schedBlock != null) {
            observingGroup = schedBlock.createObservingGroup();
        } else {
            addInteractor.error("Cannot add an Observing Group to " + businessObject.getNameOrDefault());
        }
        return observingGroup;
    }

    private BusinessObject performAddTarget(AddInteractor addInteractor) {
        Target target = null;
        SchedBlock schedBlock = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (businessObject instanceof TargetCollection) {
            TargetCollection targetCollection = (TargetCollection)businessObject;
            schedBlock = targetCollection.getSchedBlock();
        } else if (businessObject instanceof SchedBlock) {
            schedBlock = (SchedBlock)businessObject;
        }
        if (schedBlock != null) {
            target = schedBlock.createTarget();
        } else {
            addInteractor.error("Cannot add an Target to " + businessObject.getNameOrDefault());
        }
        return target;
    }

    private BusinessObject performAddFieldSource(AddInteractor addInteractor) {
        FieldSource fieldSource = null;
        SchedBlock schedBlock = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (businessObject instanceof FieldSourceCollection) {
            FieldSourceCollection fieldSourceCollection = (FieldSourceCollection)businessObject;
            schedBlock = fieldSourceCollection.getSchedBlock();
        } else if (businessObject instanceof ResourceCollection) {
            ResourceCollection resourceCollection = (ResourceCollection)businessObject;
            schedBlock = resourceCollection.getSchedBlock();
        } else if (businessObject instanceof SchedBlock) {
            schedBlock = (SchedBlock)businessObject;
        }
        if (schedBlock != null) {
            fieldSource = schedBlock.createFieldSource();
        } else {
            addInteractor.error("Cannot add an FieldSource to " + businessObject.getNameOrDefault());
        }
        return fieldSource;
    }

    private BusinessObject performAddSpectralSpec(AddInteractor addInteractor) {
        Object object;
        SpectralSpec spectralSpec = null;
        SchedBlock schedBlock = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (businessObject instanceof InstrumentSpecCollection) {
            InstrumentSpecCollection instrumentSpecCollection = (InstrumentSpecCollection)businessObject;
            schedBlock = instrumentSpecCollection.getSchedBlock();
        } else if (businessObject instanceof ResourceCollection) {
            object = (ResourceCollection)businessObject;
            schedBlock = object.getSchedBlock();
        } else if (businessObject instanceof SchedBlock) {
            schedBlock = (SchedBlock)businessObject;
        }
        if (schedBlock != null) {
            int n = schedBlock.getSpectralSpecCount();
            switch (addInteractor.whatType()) {
                case ACASPECTRALSPEC: {
                    spectralSpec = schedBlock.createSpectralSpecWithACACorrelatorConfiguration();
                    schedBlock.getObsUnitControl().setArrayRequested(ControlBlockData.ARRAYREQUESTED_ACA);
                    break;
                }
                case BLSPECTRALSPEC: {
                    spectralSpec = schedBlock.createSpectralSpecWithBLCorrelatorConfiguration();
                    schedBlock.getObsUnitControl().setArrayRequested(ControlBlockData.ARRAYREQUESTED_TWELVE_M);
                    break;
                }
                case SQUARELAWSPECTRALSPEC: {
                    spectralSpec = SpectralSpecData.createSpectralSpec();
                    object = SquareLawSetupData.createSquareLawSetup();
                    object.setIntegrationDuration(TimeData.createTime((double)16.0, (String)TimeData.UNIT_MS));
                    spectralSpec.setSquareLawSetup((SquareLawSetup)((Object)object));
                    schedBlock.addSpectralSpec(spectralSpec);
                    break;
                }
            }
            if (schedBlock.getSpectralSpecCount() == n) {
                spectralSpec = null;
            }
        } else {
            addInteractor.error("Cannot add an Spectral Spec to " + businessObject.getNameOrDefault());
        }
        return spectralSpec;
    }

    private BusinessObject performAddOpticalCameraSpec(AddInteractor addInteractor) {
        OpticalCameraSpec opticalCameraSpec = null;
        SchedBlock schedBlock = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        if (businessObject instanceof InstrumentSpecCollection) {
            InstrumentSpecCollection instrumentSpecCollection = (InstrumentSpecCollection)businessObject;
            schedBlock = instrumentSpecCollection.getSchedBlock();
        } else if (businessObject instanceof ResourceCollection) {
            ResourceCollection resourceCollection = (ResourceCollection)businessObject;
            schedBlock = resourceCollection.getSchedBlock();
        } else if (businessObject instanceof SchedBlock) {
            schedBlock = (SchedBlock)businessObject;
        }
        if (schedBlock != null) {
            int n = schedBlock.getOpticalCameraSpecCount();
            opticalCameraSpec = schedBlock.createOpticalCameraSpec();
            if (schedBlock.getOpticalCameraSpecCount() == n) {
                opticalCameraSpec = null;
            }
        } else {
            addInteractor.error("Cannot add an Optical Camera Spec to " + businessObject.getNameOrDefault());
        }
        return opticalCameraSpec;
    }

    private BusinessObject performAddObservingParameters(AddInteractor addInteractor) {
        Object object = null;
        SchedBlock schedBlock = null;
        BusinessObject businessObject = addInteractor.getSelectedBO();
        AddInteractor.ObjectType objectType = addInteractor.whatType();
        if (businessObject instanceof ObservingParametersCollection) {
            ObservingParametersCollection observingParametersCollection = (ObservingParametersCollection)businessObject;
            schedBlock = observingParametersCollection.getSchedBlock();
        } else if (businessObject instanceof ResourceCollection) {
            ResourceCollection resourceCollection = (ResourceCollection)businessObject;
            schedBlock = resourceCollection.getSchedBlock();
        } else if (businessObject instanceof SchedBlock) {
            schedBlock = (SchedBlock)businessObject;
        }
        if (schedBlock != null) {
            int n = schedBlock.getObservingParametersCount();
            object = switch (objectType) {
                case AddInteractor.ObjectType.SCIENCEPARAMETERS -> schedBlock.createScienceParameters();
                case AddInteractor.ObjectType.PHASECALPARAMETERS -> schedBlock.createPhaseCalParameters();
                case AddInteractor.ObjectType.POINTINGCALPARAMETERS -> schedBlock.createPointingCalParameters();
                case AddInteractor.ObjectType.AMPLITUDECALPARAMETERS -> schedBlock.createAmplitudeCalParameters();
                case AddInteractor.ObjectType.POLARIZATIONCALPARAMETERS -> schedBlock.createPolarizationCalParameters();
                case AddInteractor.ObjectType.FOCUSCALPARAMETERS -> schedBlock.createFocusCalParameters();
                case AddInteractor.ObjectType.ATMOSPHERICCALPARAMETERS -> schedBlock.createAtmosphericCalParameters();
                case AddInteractor.ObjectType.DELAYCALPARAMETERS -> schedBlock.createDelayCalParameters();
                case AddInteractor.ObjectType.CHECKSOURCECALPARAMETERS -> schedBlock.createCheckSourceCalParameters();
                case AddInteractor.ObjectType.SIDEBANDRATIOCALPARAMETERS -> schedBlock.createSidebandRatioCalParameters();
                case AddInteractor.ObjectType.BANDPASSCALPARAMETERS -> schedBlock.createBandpassCalParameters();
                case AddInteractor.ObjectType.OPTICALPOINTINGPARAMETERS -> schedBlock.createOpticalPointingParameters();
                case AddInteractor.ObjectType.RADIOMETRICPOINTINGPARAMETERS -> schedBlock.createRadiometricPointingParameters();
                case AddInteractor.ObjectType.HOLOGRAPHYPARAMETERS -> schedBlock.createHolographyParameters();
                case AddInteractor.ObjectType.DGCREFERENCECALPARAMETERS -> schedBlock.createDGCReferenceCalParameters();
                case AddInteractor.ObjectType.DGCSCIENCECALPARAMETERS -> schedBlock.createDGCScienceCalParameters();
                default -> throw new RuntimeException("Invalid Business Object type: " + objectType);
            };
            if (schedBlock.getObservingParametersCount() == n) {
                object = null;
            }
        } else {
            addInteractor.error("Cannot add a " + objectType + " to " + businessObject.getNameOrDefault());
        }
        return object;
    }

    private boolean confirmAdd(BusinessObject businessObject) {
        AbstractScienceGoal abstractScienceGoal = BOUtilities.findScienceGoal(businessObject);
        if (abstractScienceGoal == null) {
            return true;
        }
        String string = "";
        string = abstractScienceGoal.getObsUnitSet() == businessObject ? "" : "part of ";
        String string2 = String.format("<html>Do you want to add an object into <br><br>&nbsp;&nbsp;&nbsp;%s?<br><br><strong>Note</strong>: it is %sthe ObsUnitSet generated from the Science Goal:<br><br>&nbsp;&nbsp;&nbsp;%s.<br><br></html>", businessObject.toTreeString(1, false, false), string, abstractScienceGoal.toTreeString(1, false, false));
        return GUIUtilities.confirm(DIALOG_ADD, string2);
    }
}

