/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.hla.runtime.obsprep.util.UnknownEntityPartException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.ImportInteractor;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.actions.PostRetrievalActionInterface;
import alma.obsprep.ot.actions.ProjectRecycler;
import alma.obsprep.ot.actions.RetrieveAsNewACASupplementalCallProposalPerformer;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.PersistenceException;
import alma.obsprep.util.FileUtilities;
import alma.obsprep.util.GUIUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import lombok.NonNull;
import org.exolab.castor.xml.XMLException;

public class ImportPerformer
extends Performer
implements PostRetrievalActionInterface {
    private boolean showsConfirmationDialog = true;
    private final ProjectRecycler projectRecycler = new ProjectRecycler();

    public ImportPerformer(ImportInteractor importInteractor) {
        super(importInteractor);
    }

    @Override
    public void perform() {
        ImportInteractor importInteractor = (ImportInteractor)this.getGui();
        URL uRL = importInteractor.getImportURL();
        if (uRL == null) {
            return;
        }
        String string = FileUtilities.getExtension(uRL.toExternalForm());
        if (!"aot".equals(string)) {
            importInteractor.error("Can only import ALMA OT (*.aot) files");
            return;
        }
        ObsProject obsProject = null;
        try {
            obsProject = ImpexFactory.getInstance().importObsProject(uRL, this.showsConfirmationDialog);
        }
        catch (PersistenceException persistenceException) {
            importInteractor.error("Usage error: " + persistenceException.getMessage());
        }
        catch (IOException iOException) {
            importInteractor.error("I/O error: " + iOException.getMessage());
        }
        catch (XMLException xMLException) {
            importInteractor.error("XML (syntax or validity) error: " + xMLException.getMessage());
        }
        catch (UnknownEntityPartException unknownEntityPartException) {
            importInteractor.error("Data integrity error: " + unknownEntityPartException.getMessage());
        }
        if (obsProject == null) {
            return;
        }
        obsProject.getObsProgram();
        File file = null;
        String string2 = uRL.toExternalForm();
        if (string2.startsWith("file:")) {
            file = new File(string2.substring(5));
        }
        try {
            if (!this.postRetrieveProcessing(obsProject)) {
                return;
            }
        }
        catch (PostRetrievalActionInterface.UnableToPerformPostRetrievalProcessingException unableToPerformPostRetrievalProcessingException) {
            return;
        }
        importInteractor.display(obsProject, file);
        ActionLog.performed("Open", obsProject, "from disk");
    }

    public void setShowsConfirmationDialog(boolean bl) {
        this.showsConfirmationDialog = bl;
    }

    @Override
    public boolean postRetrieveProcessing(@NonNull ObsProject obsProject) throws PostRetrievalActionInterface.UnableToPerformPostRetrievalProcessingException {
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        if (AlmaPolicies.getInstance().isSupplementalCallEnabled()) {
            ObsProposal obsProposal;
            ImportInteractor importInteractor = (ImportInteractor)this.getGui();
            boolean bl = false;
            try {
                bl = obsProject.getObsProposal().isSupplementalCallProposal();
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(ImportPerformer.class).warning("Unable to determine obsproposal " + unknownEntityException.getMessage());
                importInteractor.error("Unable to find the observing proposal node");
                return false;
            }
            if (!bl) {
                if (!importInteractor.getConfirmation("Do you want to convert project to an ACA supplemental call proposal?", "Yes", "No")) {
                    return true;
                }
                this.projectRecycler.recycleProjectAsNewProject(obsProject);
            }
            try {
                obsProposal = obsProject.getObsProposal();
            }
            catch (UnknownEntityException unknownEntityException) {
                throw new PostRetrievalActionInterface.UnableToPerformPostRetrievalProcessingException(unknownEntityException);
            }
            if (obsProposal.isProjectSunBased() || obsProposal.isVLBIorPhasedArray()) {
                GUIUtilities.error(null, "Unable to recycle a solar or VLBI project as an ACA supplemental call proposal");
                return false;
            }
            obsProposal.setCycle(AlmaPolicies.getInstance().getSupplementalCallCycleNumber());
            obsProject.setIsDDT(false);
            RetrieveAsNewACASupplementalCallProposalPerformer.convertAllScienceGoalsToACASupplementalCfPStandard(obsProposal);
            try {
                Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.decomposeIncludingFiles(obsProject);
                ImpexFactory.updateRevisionNumbersOfDocuments(boBundle);
            }
            catch (UnknownEntityException | IOException throwable) {
                Log.logger(this.getClass()).warning("Unable to reset the revision number of document: " + throwable.getMessage());
            }
            obsProject.resetAfterImport();
        }
        return true;
    }
}

