/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.Interactor;
import alma.obsprep.ot.actions.RetrieveAsNewPerformer;
import alma.obsprep.ot.actions.RetrieveInteractor;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.ProjectRepository;
import java.io.IOException;

public class RetrieveAsNewDDTProposalPerformer
extends RetrieveAsNewPerformer {
    public RetrieveAsNewDDTProposalPerformer(Interactor interactor, ProjectRepository projectRepository) {
        super(interactor, projectRepository);
    }

    @Override
    public boolean postRetrieveProcessing(ObsProject obsProject) {
        ObsProposal obsProposal;
        RetrieveInteractor retrieveInteractor = (RetrieveInteractor)this.getGui();
        if (!this.isProjectDDT && !retrieveInteractor.getUserConfirmation("Converting proposal to DDT. Cancel if this is not what you intended.", "Convert", "Cancel")) {
            return false;
        }
        this.projectRecycler.recycleProjectAsNewProject(obsProject);
        try {
            obsProposal = obsProject.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            retrieveInteractor.error((Exception)((Object)unknownEntityException));
            return false;
        }
        obsProposal.setCycle(AlmaPolicies.getInstance().getDDTCycleNumber());
        obsProject.setIsDDT(true);
        try {
            Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.decomposeIncludingFiles(obsProject);
            ImpexFactory.updateRevisionNumbersOfDocuments(boBundle);
        }
        catch (UnknownEntityException | IOException throwable) {
            Log.logger(RetrieveAsNewDDTProposalPerformer.class).warning("Unable to reset the revision number of document: " + throwable.getMessage());
        }
        obsProject.resetAfterImport();
        return true;
    }
}

