/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.PhaseISciencePlanCollection;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.SummaryFeedbackInteractor;
import alma.obsprep.ot.actions.SummaryFeedbackPerformer;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.summaryfeedback.FeedbackSummary;
import alma.obsprep.services.summaryfeedback.FeedbackSummaryObsProject;
import alma.obsprep.services.summaryfeedback.FeedbackSummaryObsProposal;
import alma.obsprep.services.summaryfeedback.FeedbackSummaryScienceGoal;
import alma.obsprep.services.summaryfeedback.FeedbackSummarySgCollection;
import alma.obsprep.services.summaryfeedback.ObsProposalScienceGoalNavigator;
import alma.obsprep.services.summaryfeedback.SummaryFrame;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.data.StatusData;
import org.apache.commons.lang3.StringUtils;

public class SummaryFeedbackAction
extends OTAction
implements SummaryFeedbackInteractor,
EventReceiver {
    protected BusinessObject m_selectedBO = null;
    protected ProjectTreeNode m_selectedNode = null;

    public SummaryFeedbackAction() {
        SummaryFeedbackPerformer summaryFeedbackPerformer = new SummaryFeedbackPerformer(this);
        this.setPerformer(summaryFeedbackPerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
    }

    @Override
    public void show() {
        Object object;
        FeedbackSummary feedbackSummary = null;
        boolean bl = false;
        Object object2 = this.m_selectedBO;
        if (object2 instanceof ScienceGoal) {
            object = (ScienceGoal)object2;
            try {
                feedbackSummary = new FeedbackSummaryScienceGoal((ScienceGoal)object);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                GUIUtilities.warning(null, "Unable to run clustering algorithm : " + invalidObsProgramParametersException.getMessage());
                return;
            }
            bl = true;
        } else {
            object2 = this.m_selectedBO;
            if (object2 instanceof ObsProject) {
                ObsProject obsProject = (ObsProject)object2;
                try {
                    feedbackSummary = new FeedbackSummaryObsProject(obsProject);
                }
                catch (WizardSBGenerationException wizardSBGenerationException) {
                    GUIUtilities.warning(null, "Unable to generate summary : " + StringUtils.substringAfter((String)wizardSBGenerationException.getMessage(), (String)":"));
                }
                bl = true;
            } else {
                object2 = this.m_selectedBO;
                if (object2 instanceof ObsProposal) {
                    ObsProposal obsProposal = (ObsProposal)object2;
                    feedbackSummary = new FeedbackSummaryObsProposal(obsProposal);
                } else {
                    object2 = this.m_selectedBO;
                    if (object2 instanceof PhaseISciencePlanCollection) {
                        PhaseISciencePlanCollection phaseISciencePlanCollection = (PhaseISciencePlanCollection)object2;
                        if ((object2 = phaseISciencePlanCollection.getObsProposal()).getAbstractScienceGoalCount() == 0) {
                            GUIUtilities.warning(null, "No ScienceGoal");
                            return;
                        }
                        ObsProposalScienceGoalNavigator obsProposalScienceGoalNavigator = new ObsProposalScienceGoalNavigator((ObsProposal)object2, true);
                        feedbackSummary = new FeedbackSummarySgCollection((ObsProposal)object2, obsProposalScienceGoalNavigator);
                        bl = true;
                    } else {
                        throw new IllegalArgumentException("Unexpected BusinessObject : " + this.m_selectedBO.getClass());
                    }
                }
            }
        }
        object = new SummaryFrame(feedbackSummary);
        ((SummaryFrame)object).setShowNavigationButtons(bl);
        ((SummaryFrame)object).showPanel();
    }

    private void setNameFor(BusinessObject businessObject) {
        String string;
        if (businessObject instanceof ObsProject && this.isPhaseIProject()) {
            string = "Show Printable Summary of Proposal and Science Goals";
        } else if (businessObject instanceof ScienceGoal && this.isPhaseIScienceGoal()) {
            string = "Show Printable Summary of ScienceGoal";
        } else if (businessObject instanceof ObsProposal && this.isPhaseIProject()) {
            string = "Show Printable Summary of Proposal";
        } else if (businessObject instanceof PhaseISciencePlanCollection) {
            string = "Show Printable Summary of all Science Goals";
        } else {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        this.setEnabled(true);
        this.putValue("Name", string);
    }

    private boolean isPhaseIProject() {
        Object object = this.m_selectedBO;
        if (object instanceof ObsProject) {
            ObsProject obsProject = (ObsProject)object;
            if ((object = obsProject.getStatus()) == StatusData.STATE_NEWPHASE1 || object == StatusData.STATE_PHASE1SUBMITTED) {
                return true;
            }
        } else {
            object = this.m_selectedBO;
            if (object instanceof ObsProposal) {
                ObsProposal obsProposal = (ObsProposal)object;
                try {
                    object = obsProposal.getObsProject();
                    if (object.getStatus() == StatusData.STATE_NEWPHASE1 || object.getStatus() == StatusData.STATE_PHASE1SUBMITTED) {
                        return true;
                    }
                }
                catch (UnknownEntityException unknownEntityException) {
                    unknownEntityException.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    private boolean isPhaseIScienceGoal() {
        return this.m_selectedBO.getParent() instanceof ObsProposal;
    }

    @Override
    public void receiveEvent(Event event) {
        this.m_selectedNode = (ProjectTreeNode)event.getSource();
        this.m_selectedBO = (BusinessObject)this.m_selectedNode.getUserObject();
        this.setNameFor(this.m_selectedBO);
    }
}

