/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.workbooks.WorkbookPage;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.WizardInteractor;
import alma.obsprep.ot.actions.WizardPerformer;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.ProjectResetListener;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.util.GUIUtilities;

public class WizardAction
extends OTAction
implements WizardInteractor,
EventReceiver,
RoleDirectoryService.UserAuthenticatesListener,
ProjectResetListener {
    protected BusinessObject m_selectedBO = null;
    protected BusinessObject m_parentBO = null;
    protected ProjectTreeNode m_selectedNode = null;
    protected ProjectTreeNode m_parentNode = null;
    private final ProjectTree phase2;
    private final ObservingToolGui gui;

    public WizardAction(ProjectTree projectTree, ObservingToolGui observingToolGui) {
        this.phase2 = projectTree;
        this.gui = observingToolGui;
        WizardPerformer wizardPerformer = new WizardPerformer(this);
        this.setPerformer(wizardPerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
        ImpexFactory.getInstance().addProjectImportListener(this);
        RoleDirectoryService.addUserAuthenticatesListener(this);
    }

    @Override
    public boolean shouldScienceGoalKnowItGotGenerated() {
        return true;
    }

    @Override
    public boolean confirmOverwrite() {
        AbstractScienceGoal abstractScienceGoal = this.getScienceGoals()[0];
        Log.Logger logger = Log.logger((Object)this);
        if (logger.finest()) {
            ObsUnitSet obsUnitSet;
            String string = abstractScienceGoal == null ? String.format("%s(%h).confirmOverwrite(), params == null", this.getClass().getSimpleName(), this.hashCode()) : ((obsUnitSet = abstractScienceGoal.getObsUnitSet()) == null ? String.format("%s(%h).confirmOverwrite(), params @ %h, OUS == null", this.getClass().getSimpleName(), this.hashCode(), abstractScienceGoal.hashCode()) : String.format("%s(%h).confirmOverwrite(), params @ %h, OUS @ %h", this.getClass().getSimpleName(), this.hashCode(), abstractScienceGoal.hashCode(), obsUnitSet.hashCode()));
            logger.finest(string);
        }
        if (abstractScienceGoal == null || abstractScienceGoal.getObsUnitSet() == null) {
            return true;
        }
        if (System.getProperty("alma.obsprep.noconfirmations") == null) {
            return GUIUtilities.confirm(DIALOG_OVERWRITE_PROGRAM, "Overwrite the previously generated ObsUnitSet for this Science Goal?");
        }
        return true;
    }

    private void setEnabledFor(BusinessObject businessObject) {
        AbstractScienceGoal abstractScienceGoal = this.getScienceGoal(businessObject);
        if (!RoleDirectoryServiceHelper.isUserP2G()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(abstractScienceGoal != null);
    }

    @Override
    public void receiveEvent(Event event) {
        if (this.phase2.isDndReadonly()) {
            this.setEnabled(false);
            return;
        }
        this.m_selectedNode = (ProjectTreeNode)event.getSource();
        this.m_parentNode = (ProjectTreeNode)this.m_selectedNode.getParent();
        this.m_selectedBO = (BusinessObject)this.m_selectedNode.getUserObject();
        this.m_parentBO = this.m_parentNode != null ? (BusinessObject)this.m_parentNode.getUserObject() : null;
        this.setEnabledFor(this.m_selectedBO);
    }

    private AbstractScienceGoal getScienceGoal(BusinessObject businessObject) {
        BusinessObject businessObject2;
        BusinessObject businessObject3 = businessObject2 = businessObject instanceof WorkbookPage ? businessObject.getParent() : businessObject;
        if (businessObject2 instanceof AbstractScienceGoal && businessObject2.getParent() instanceof ObsProgram) {
            return (AbstractScienceGoal)businessObject2;
        }
        return null;
    }

    @Override
    public AbstractScienceGoal[] getScienceGoals() {
        AbstractScienceGoal abstractScienceGoal = this.getScienceGoal(this.m_selectedBO);
        if (abstractScienceGoal == null) {
            GUIUtilities.error(DIALOG_NO_PARAMS, String.format("No parameters associated with selected object (of type %s)", this.m_selectedBO.getClass().getSimpleName()));
        }
        return new AbstractScienceGoal[]{abstractScienceGoal};
    }

    @Override
    public void error(String string, Exception exception) {
        Log.logger((Object)this).info(string + " due to: " + exception);
    }

    @Override
    public void busy(boolean bl) {
        this.gui.showAsBusy(bl);
    }

    @Override
    public boolean requestConfirmation(String string) {
        return true;
    }

    @Override
    public void projectDocumentReset(ObsProject obsProject, ImpexFactory.WorkingPersistenceData workingPersistenceData) {
        if (this.m_selectedBO == null) {
            return;
        }
        this.setEnabledFor(this.m_selectedBO);
    }

    @Override
    public void userHasAuthenticated() {
        if (this.m_selectedBO == null) {
            return;
        }
        this.setEnabledFor(this.m_selectedBO);
    }
}

