/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsattachment.DocumentLink;
import alma.obsprep.bo.obsattachment.ObsAttachment;
import alma.obsprep.bo.obsattachment.data.DocumentLinkData;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.data.ObsProjectData;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTBasicTextArea;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.editors.investigator.InvestigatorSearchDialog;
import alma.obsprep.ot.editors.investigator.InvestigatorsEditor;
import alma.obsprep.ot.editors.jointproposals.JointProposalEditor;
import alma.obsprep.ot.editors.obsproject.OpenDuplicationsURLAction;
import alma.obsprep.ot.gui.toplevel.EditorDisablerController;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.ObservingToolGuiProjectCompartment;
import alma.obsprep.ot.models.obsproject.ObsProposalModel;
import alma.obsprep.util.GUIUtilities;
import com.itextpdf.text.pdf.PdfReader;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.help.CSH;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ObsProposalEditor
extends EditorWithGridBagLayout {
    private static final String CANNOT_PERFORM_THIS_OPERATION_WHEN_ATTACHMENTS_ARE_UNAVAILABLE = "cannot perform this operation when attachments are unavailable";
    static final String REGULAR_PROPOSAL = "Regular";
    private InvestigatorsEditor investigatorEditor;
    public static final String HASPHD_YES = "Yes";
    public static final String HASPHD_NO = "No";
    public final String[] investigatorHasPhDOptions = new String[]{"No", "Yes"};
    private static final long serialVersionUID = -7266042743152960270L;
    private static AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
    private static int MAX_ABSTRACT_CHARACTERS = almaPolicies.getMaxAbstractCharacters();
    private static int MAX_SCIENCE_CASE_PAGES = almaPolicies.getMaxScienceCasePages();
    private static int MAX_MANAGEMENT_PLAN_CASE_PAGES = almaPolicies.getMaxManagementPlanPages();
    private static int MAX_SCIENCE_CASE_LARGE_PROGRAM_PAGES = almaPolicies.getMaxScienceCasePagesForLargeProgram();
    public static final String DUPLICATIONS_INFO_LINK = "http://almascience.org/proposing/duplications";
    public static final String USER_REGISTRATIONLINK = "https://asa.alma.cl/UserRegistration/secure/updateAccount.jsp";
    public static final FieldID THIS_FID = new FieldID("ObsProposalEditor");
    public static final FieldID CATEGORY_FID = new FieldID("ObsProposalEditor.scientificCategory");
    public static final FieldID KEYWORDS_FID = new FieldID("ObsProposalEditor.keywords");
    public static final FieldID ABSTRACT_FID = new FieldID("ObsProposalEditor.abstract");
    public static final FieldID PROPOSALTYPE_FID = new FieldID("ObsProposalEditor.proposalType");
    public static final FieldID ADVANCEDPROPOSALTYPE_FID = new FieldID("ObsProposalEditor.advancedProposalType");
    public static final FieldID SUPPORTREQ_FID = new FieldID("ObsProposalEditor.supportRequired");
    public static final FieldID RELATEDPROPS_FID = new FieldID("ObsProposalEditor.relatedProposals");
    public static final FieldID PREVIOUSPROPS_FID = new FieldID("ObsProposalEditor.previousProposals");
    public static final FieldID DUPLICATE_OBSERVATION_FID = new FieldID("ObsProposalEditor.duplicateObservatons");
    public static final FieldID DATERECEIVED_FID = new FieldID("ObsProposalEditor.dateReceived");
    public static final FieldID PRCGRADE_FID = new FieldID("ObsProposalEditor.prcGrade");
    public static final FieldID CYCLE_FID = new FieldID("ObsProposalEditor.cycle");
    public static final FieldID STAFFCONTACT_FID = new FieldID("ObsProposalEditor.staffContact");
    public static final FieldID CONTACTPERSON_FID = new FieldID("ObsProposalEditor.contactPerson");
    public static final FieldID AVAILABILITY_MSG_FID = new FieldID("ObsProposalEditor.availabilityMessage");
    public static final FieldID ATTACH_SCIENCE_CASE_DOC_FID = new FieldID("ObsProposalEditor.attachScienceCase");
    public static final FieldID DETACH_SCIENCE_CASE_DOC_FID = new FieldID("ObsProposalEditor.detachScienceCase");
    public static final FieldID ATTACH_MANAGEMENT_PLAN_DOC_FID = new FieldID("ObsProposalEditor.attachManagementPlanCase");
    public static final FieldID DETACH_MANAGEMENT_PLAN_DOC_FID = new FieldID("ObsProposalEditor.detachManagementPlanCase");
    public static final FieldID SCIDOCUMENT_FID = new FieldID("ObsProposalEditor.scienceCaseDocument");
    public static final FieldID MANAGEMENT_PLAN_DOCUMENT_FID = new FieldID("ObsProposalEditor.managementPlanDocument");
    public static final FieldID VIEW_SCIENCE_CASE_DOC_FID = new FieldID("ObsProposalEditor.viewScienceCase");
    public static final FieldID VIEW_MANAGEMENT_PLAN_DOC_FID = new FieldID("ObsProposalEditor.viewManagementPlan");
    public static final FieldID ATTACH_TECHDOC_FID = new FieldID("ObsProposalEditor.attachTechnicalCase");
    public static final FieldID DETACH_TECHDOC_FID = new FieldID("ObsProposalEditor.detachTechnicalCase");
    public static final FieldID TECHDOCUMENT_FID = new FieldID("ObsProposalEditor.TechnicalCaseDocument");
    public static final FieldID VIEW_TECHDOC_FID = new FieldID("ObsProposalEditor.viewTechnicalCase");
    public static final FieldID ATTACH_FIGS_FID = new FieldID("ObsProposalEditor.attachFigures");
    public static final FieldID DETACH_FIGS_FID = new FieldID("ObsProposalEditor.detachFigures");
    public static final FieldID FIGURES_FID = new FieldID("ObsProposalEditor.figures");
    public static final FieldID VIEW_FIGS_FID = new FieldID("ObsProposalEditor.viewFigures");
    public static final FieldID ATTACH_TABS_FID = new FieldID("ObsProposalEditor.attachTables");
    public static final FieldID DETACH_TABS_FID = new FieldID("ObsProposalEditor.detachTables");
    public static final FieldID TABLES_FID = new FieldID("ObsProposalEditor.tables");
    public static final FieldID VIEW_TABS_FID = new FieldID("ObsProposalEditor.viewTables");
    public static final FieldID STUDENT_FID = new FieldID("ObsProposalEditor.student");
    public static final FieldID FID_SCIENCE_CASE_LABEL = new FieldID("ObsProposalEditor.scienceCaseLabel");
    public static final FieldID FID_MANAGEMENT_PLAN_LABEL = new FieldID("ObsProposalEditor.managementPlanLabel");
    public static final FieldID FID_DUPLICATIONS_LABEL = new FieldID("ObsProposalEditor.duplicationsLabel");
    public static final FieldID REVIEWERHASPHD_FID = new FieldID("ObsProposalEditor.reviewerHasPhD");
    public static final FieldID SELECT_MENTOR_FID = new FieldID("ObsProposalEditor.selectMentor");
    public static final FieldID MENTOR_NAME_FID = new FieldID("ObsProposalEditor.mentorName");
    public static final FieldID MENTOR_HAS_PHD_FID = new FieldID("ObsProposalEditor.mentorHasPhD");
    public static final FieldID MENTOR_FID = new FieldID("ObsProposalEditor.mentor");
    private JFileChooser fileSelector;
    private final ObservingToolController otc;
    private static final int FILENAME_COLUMNS = 30;
    private static final int EDITOR_WIDTH = 800;
    private static final int LABEL_WIDTH = 80;
    private static final int FIGURES_MAX_PAGES = 2;
    private static final int TECHNICAL_CASE_MAX_PAGES = 2;
    private static final int TABLES_MAX_PAGES = 2;
    private JPanel scienceCaseDocumentsGroupPanel;
    private JPanel managementPlanDocumentsGroupPanel;
    static final Map<FieldID, String> tooltips = new HashMap<FieldID, String>();
    private OTButtonGroup categoryButtons;
    private JList<String> keywordList;
    private OTButtonGroup normalProposalButtons;
    private OTButtonGroup advancedProposalButtons;
    private JPanel reviewerPanel;
    private JPanel mentorGroup;
    private JPanel managementPlanPanel;
    private JComponent jointProposalComponentGroup;
    private static Map<FieldID, String> documentClassMap;
    private static Map<String, Long> attachmentMaxSizes;
    private static Map<String, Integer> attachmentMaxPages;

    public ObsProposalEditor(Model model, ObservingToolController observingToolController) {
        this.setName("ObsProposalEditor");
        this.otc = observingToolController;
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public ObsProposalModel getModel() {
        return (ObsProposalModel)super.getModel();
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (FieldIDs.projectStatusFID.equals(fieldID) && object instanceof String) {
            String string = (String)object;
            this.setProposalTypeButtonsEnabled(ObsProjectData.STATUS_NEWPHASE1.equals(string) || ObsProject.STATUS_NEWPHASE2.equals(string));
        } else if (THIS_FID.equals(fieldID)) {
            this.configureEditorForStandardView();
        }
        super.modelChanged(model, fieldID, object);
    }

    private void setProposalTypeButtonsEnabled(boolean bl) {
        SwingUtilities.invokeLater(() -> {
            this.normalProposalButtons.setEnabled(bl);
            this.advancedProposalButtons.setEnabled(bl);
            this.setProposalTypeSelectionOptionsForJointProposals();
        });
    }

    @Override
    protected void addComponents(String string) {
        this.addProposalGroup();
        this.jointProposalComponentGroup = this.addJointProposalGroup();
        this.addInvestigatorsGroup();
        this.addReviewersGroup();
        this.addDocumentGroup();
        this.addDuplicateObservationGroup();
        this.addFeedbackGroup();
    }

    private JComponent addJointProposalGroup() {
        JointProposalEditor jointProposalEditor = new JointProposalEditor(this.getModel().getJointProposalModel());
        this.registerSubView(jointProposalEditor);
        return this.addNonCollapsingGroup(jointProposalEditor, "Joint Proposals");
    }

    private void addReviewersGroup() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        ComponentCollection componentCollection = new ComponentCollection();
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = this.createNewLayout(jPanel2);
        JButton jButton = new JButton();
        jButton.setText("<html><a href=\"https://asa.alma.cl/UserRegistration/secure/updateAccount.jsp\">https://asa.alma.cl/UserRegistration/secure/updateAccount.jsp</a></html>");
        jButton.setActionCommand(USER_REGISTRATIONLINK);
        jButton.setHorizontalAlignment(2);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setOpaque(false);
        jButton.addActionListener(new OpenDuplicationsURLAction());
        JLabel jLabel = new JLabel();
        jLabel.setText("<html>Please designate a reviewer who will participate in the distributed review process. The reviewer may be the PI of the proposal or one of the other investigators. <BR>A student (without a PhD) may serve as the reviewer only if they are the PI of the proposal and a mentor (with a PhD) is identified. <BR>The mentor does not need to be an investigator on the proposal.<p><BR>Reviewers are requested to:</p> <p><BR><UL><LI> Abide by the maximum number of Proposal Sets that are to be assigned for review to any individual (refer to the Proposer's Guide for more information). </LI> <LI> Update their user profiles with combinations of scientific categories and keywords which describe their area(s) of expertise using the new 'Expertise' <BR> tab in the link below. Available expertise information will be used in the distribution of proposal assignments. </LI> </UL> </html>");
        jPanel.add(jLabel);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jLabel);
        this.addComponent(jPanel2, gridBagLayout2, gridBagConstraints, jButton);
        componentCollection.remember(jPanel2);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addVerticalSpace(jPanel2, gridBagLayout2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        jPanel3.add(new JLabel("Reviewer has a PhD?"));
        OTButtonGroup oTButtonGroup = this.makeOTButtonGroup(REVIEWERHASPHD_FID, this.investigatorHasPhDOptions, tooltips.get(REVIEWERHASPHD_FID));
        jPanel3.add(oTButtonGroup);
        jPanel.add(jPanel3);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.mentorGroup = this.createNewGroup();
        GridBagLayout gridBagLayout3 = this.createNewLayout(this.mentorGroup);
        GridBagConstraints gridBagConstraints2 = this.createNewConstraints();
        JButton jButton2 = this.makeButton(SELECT_MENTOR_FID, "Select Mentor", tooltips.get(SELECT_MENTOR_FID));
        OTButtonGroup oTButtonGroup2 = this.makeOTButtonGroup(MENTOR_HAS_PHD_FID, this.investigatorHasPhDOptions, tooltips.get(MENTOR_HAS_PHD_FID));
        OTTextField oTTextField = this.makeTextField(MENTOR_NAME_FID, false, tooltips.get(MENTOR_NAME_FID));
        this.addComponent(this.mentorGroup, gridBagLayout3, gridBagConstraints2, jButton2);
        this.addVerticalSpace(this.mentorGroup, gridBagLayout3, gridBagConstraints2);
        this.addLabeledComponent((JComponent)this.mentorGroup, gridBagLayout3, gridBagConstraints2, "Mentor name ", (JComponent)oTTextField);
        this.addVerticalSpace(this.mentorGroup, gridBagLayout3, gridBagConstraints2);
        this.addLabeledComponent((JComponent)this.mentorGroup, gridBagLayout3, gridBagConstraints2, "Mentor has a PhD?", (JComponent)oTButtonGroup2);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, this.mentorGroup);
        this.reviewerPanel = (JPanel)this.addNonCollapsingGroup(jPanel, "Reviewer Information");
        CSH.setHelpIDString((Component)this.reviewerPanel, (String)"TOC-The Phase 1 Proposal: Basic Details-Reviewer Information");
    }

    private void addProposalGroup() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.projectNameFID, "Proposal Title", tooltips.get(FieldIDs.projectNameFID));
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        OTTextField oTTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, CYCLE_FID, "Proposal Cycle", tooltips.get(CYCLE_FID));
        oTTextField.setEditable(false);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addOTTextArea(jPanel, gridBagLayout, gridBagConstraints, ABSTRACT_FID, 720, 150, "<html>Abstract<br>(max. " + MAX_ABSTRACT_CHARACTERS + " characters)</html>", tooltips.get(ABSTRACT_FID), true);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        String[] stringArray = almaPolicies.getKnownProposalTypes();
        String[] stringArray2 = almaPolicies.getObservatoryTypes();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        this.normalProposalButtons = this.addOTButtonGroup(jPanel, gridBagLayout, gridBagConstraints, PROPOSALTYPE_FID, "Proposal Type", tooltips.get(PROPOSALTYPE_FID), stringArray, 3, 150);
        this.advancedProposalButtons = this.addOTButtonGroup(jPanel, gridBagLayout, gridBagConstraints, ADVANCEDPROPOSALTYPE_FID, "Proposal Type", tooltips.get(ADVANCEDPROPOSALTYPE_FID), stringArray3, 3, 150);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        String[] stringArray4 = almaPolicies.getKnownScientificCategories();
        this.categoryButtons = this.addOTButtonGroup(jPanel, gridBagLayout, gridBagConstraints, CATEGORY_FID, "Scientific Category", tooltips.get(CATEGORY_FID), stringArray4, 3, 150);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.keywordList = this.addJList(jPanel, gridBagLayout, gridBagConstraints, KEYWORDS_FID, "<html>Please select one <br>or two keywords</html>", tooltips.get(KEYWORDS_FID), new String[0]);
        this.keywordList.setSelectionMode(2);
        this.keywordList.setLayoutOrientation(0);
        this.keywordList.setVisibleRowCount(5);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        JPanel jPanel2 = this.createLineContainer();
        JCheckBox jCheckBox = this.makeCheckBox(STUDENT_FID, "<html>This option should be checked if the proposed project <br>is intended to obtain data for a student thesis</html>");
        jPanel2.add(jCheckBox);
        this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Student project", (JComponent)jPanel2);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        JPanel jPanel3 = (JPanel)this.addNonCollapsingGroup(jPanel, "Proposal Information");
        CSH.setHelpIDString((Component)jPanel3, (String)"TOC-The Phase 1 Proposal: Basic Details-Proposal Information");
    }

    public void setAdvancedProposalsVisible(boolean bl) {
        bl = false;
        if (bl) {
            if (!this.advancedProposalButtons.isVisible()) {
                this.advancedProposalButtons.setVisible(true);
                try {
                    String string = this.normalProposalButtons.getSelectedItem();
                    if (string == null) {
                        this.advancedProposalButtons.clearSelection();
                    } else {
                        this.getModel().publish(ADVANCEDPROPOSALTYPE_FID, string);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    this.getModel().resetProposalType();
                    this.advancedProposalButtons.clearSelection();
                }
            }
            if (this.normalProposalButtons.isVisible()) {
                this.normalProposalButtons.setVisible(false);
            }
        } else {
            if (!this.normalProposalButtons.isVisible()) {
                this.normalProposalButtons.setVisible(true);
                try {
                    String string = this.advancedProposalButtons.getSelectedItem();
                    String[] stringArray = this.normalProposalButtons.getAllItems();
                    boolean bl2 = false;
                    for (String string2 : stringArray) {
                        if (!string.equals(string2)) continue;
                        this.getModel().publish(PROPOSALTYPE_FID, string);
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        this.getModel().resetProposalType();
                        this.normalProposalButtons.clearSelection();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    this.getModel().resetProposalType();
                    this.normalProposalButtons.clearSelection();
                }
            }
            if (this.advancedProposalButtons.isVisible()) {
                this.advancedProposalButtons.setVisible(false);
            }
        }
    }

    private void addInvestigatorsGroup() {
        this.investigatorEditor = new InvestigatorsEditor(this.getModel(), this.otc);
        this.registerSubView(this.investigatorEditor);
        JPanel jPanel = (JPanel)this.addNonCollapsingGroup(this.investigatorEditor, "Investigators");
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-The Phase 1 Proposal: Basic Details-Investigators");
    }

    private void addDocumentGroup() {
        this.scienceCaseDocumentsGroupPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(this.scienceCaseDocumentsGroupPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.managementPlanDocumentsGroupPanel = this.createNewGroup();
        GridBagLayout gridBagLayout2 = this.createNewLayout(this.managementPlanDocumentsGroupPanel);
        GridBagConstraints gridBagConstraints2 = this.createNewConstraints();
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        ComponentCollection componentCollection = new ComponentCollection();
        JLabel jLabel = this.makeLabel("Please ensure that your science case is properly anonymized following instructions on the Science Portal");
        componentCollection.remember(jLabel);
        this.addComponentArray(this.scienceCaseDocumentsGroupPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel(AVAILABILITY_MSG_FID, "", null));
        this.addComponentArray(this.scienceCaseDocumentsGroupPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        JLabel jLabel2 = this.makeLabel("Science Case (Mandatory, PDF, " + MAX_SCIENCE_CASE_PAGES + " pages max.)");
        this.register(jLabel2, FID_SCIENCE_CASE_LABEL);
        componentCollection.remember(jLabel2);
        OTTextField oTTextField = this.makeTextField(SCIDOCUMENT_FID, false, tooltips.get(SCIDOCUMENT_FID));
        oTTextField.setColumns(30);
        oTTextField.setFocusable(false);
        componentCollection.remember(oTTextField);
        componentCollection.remember(this.makeButton(ATTACH_SCIENCE_CASE_DOC_FID, "Attach", tooltips.get(ATTACH_SCIENCE_CASE_DOC_FID)));
        componentCollection.remember(this.makeButton(DETACH_SCIENCE_CASE_DOC_FID, "Detach", tooltips.get(DETACH_SCIENCE_CASE_DOC_FID)));
        JButton jButton = this.makeButton(VIEW_SCIENCE_CASE_DOC_FID, "View", tooltips.get(VIEW_SCIENCE_CASE_DOC_FID));
        componentCollection.remember(jButton);
        this.addComponentArray(this.scienceCaseDocumentsGroupPanel, gridBagLayout, gridBagConstraints, componentCollection);
        jButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        JPanel jPanel = (JPanel)this.addNonCollapsingGroup(this.scienceCaseDocumentsGroupPanel, "Science Case");
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-The Phase 1 Proposal: Basic Details-Science Case");
        componentCollection = new ComponentCollection();
        JLabel jLabel3 = this.makeLabel("Management Plan (PDF, " + MAX_MANAGEMENT_PLAN_CASE_PAGES + " page max.)");
        this.register(jLabel3, FID_MANAGEMENT_PLAN_LABEL);
        componentCollection.remember(jLabel3);
        oTTextField = this.makeTextField(MANAGEMENT_PLAN_DOCUMENT_FID, false, tooltips.get(MANAGEMENT_PLAN_DOCUMENT_FID));
        oTTextField.setColumns(30);
        oTTextField.setFocusable(false);
        componentCollection.remember(oTTextField);
        componentCollection.remember(this.makeButton(ATTACH_MANAGEMENT_PLAN_DOC_FID, "Attach", tooltips.get(ATTACH_MANAGEMENT_PLAN_DOC_FID)));
        componentCollection.remember(this.makeButton(DETACH_MANAGEMENT_PLAN_DOC_FID, "Detach", tooltips.get(DETACH_MANAGEMENT_PLAN_DOC_FID)));
        jButton = this.makeButton(VIEW_MANAGEMENT_PLAN_DOC_FID, "View", tooltips.get(VIEW_MANAGEMENT_PLAN_DOC_FID));
        componentCollection.remember(jButton);
        this.addComponentArray(this.managementPlanDocumentsGroupPanel, gridBagLayout2, gridBagConstraints2, componentCollection);
        jButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        this.managementPlanPanel = (JPanel)this.addNonCollapsingGroup(this.managementPlanDocumentsGroupPanel, "Management Plan");
        CSH.setHelpIDString((Component)this.managementPlanPanel, (String)"TOC-The Phase 1 Proposal: Basic Details-Management Plan");
    }

    private void addDuplicateObservationGroup() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        ComponentCollection componentCollection = new ComponentCollection();
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = this.createNewLayout(jPanel2);
        JButton jButton = new JButton();
        jButton.setText("<html><a href=\"https://asa.alma.cl/UserRegistration/secure/updateAccount.jsp\">https://asa.alma.cl/UserRegistration/secure/updateAccount.jsp</a></html>");
        jButton.setActionCommand(DUPLICATIONS_INFO_LINK);
        jButton.setHorizontalAlignment(2);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setOpaque(false);
        jButton.addActionListener(new OpenDuplicationsURLAction());
        JLabel jLabel = new JLabel();
        jLabel.setText("<HTML><p>Briefly justify any new observations that duplicate archival data or accepted programs.</p> <p>Information regarding the ALMA Duplication Policy and how to search archival data and accepted programs can be found at:</p></HTML>");
        jPanel.add(jLabel);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        componentCollection.remember(jButton);
        this.addComponentArray(jPanel, gridBagLayout2, gridBagConstraints, componentCollection);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        OTBasicTextArea oTBasicTextArea = this.makeOTBasicTextArea(DUPLICATE_OBSERVATION_FID, tooltips.get(FieldIDs.duplicateObservationsFID), 720, 80, true);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, oTBasicTextArea);
        oTBasicTextArea.setFocusable(true);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        JPanel jPanel3 = (JPanel)this.addNonCollapsingGroup(jPanel, "Duplicate observations");
        CSH.setHelpIDString((Component)jPanel3, (String)"TOC-The Phase 1 Proposal: Basic Details-Duplicate observations");
    }

    private void addFeedbackGroup() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        OTTextField oTTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.codeFID, "Project Code", tooltips.get(FieldIDs.codeFID));
        oTTextField.setEditable(false);
        oTTextField.setFocusable(false);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        oTTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, PRCGRADE_FID, "PRC Grade", tooltips.get(PRCGRADE_FID));
        oTTextField.setEditable(false);
        oTTextField.setFocusable(false);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        oTTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, DATERECEIVED_FID, "Date Received", tooltips.get(DATERECEIVED_FID));
        oTTextField.setEditable(false);
        oTTextField.setFocusable(false);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        JPanel jPanel2 = this.addGroup(jPanel, "Observatory Use Only", true);
        CSH.setHelpIDString((Component)jPanel2, (String)"TOC-The Phase 1 Proposal: Basic Details-Observatory Use Only");
    }

    @Override
    protected void build() {
        super.build("ObsProposal");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        Iterable<Investigator> iterable;
        ObsProposalModel obsProposalModel = this.getModel();
        if (fieldID.equals(THIS_FID)) {
            this.configureEditorForStandardView();
            this.setDocumentControlButtons();
            this.setProposalTypeSelectionOptionsForJointProposals();
            return;
        }
        if (fieldID.equals(MANAGEMENT_PLAN_DOCUMENT_FID) || fieldID.equals(SCIDOCUMENT_FID) || fieldID.equals(FIGURES_FID) || fieldID.equals(TECHDOCUMENT_FID) || fieldID.equals(TABLES_FID)) {
            DocumentLink documentLink = (DocumentLink)((Object)object);
            String string = documentLink == null ? "" : documentLink.getFileName();
            super.update(fieldID, string);
            return;
        }
        if (fieldID.equals(ATTACH_MANAGEMENT_PLAN_DOC_FID) || fieldID.equals(ATTACH_SCIENCE_CASE_DOC_FID) || fieldID.equals(ATTACH_FIGS_FID) || fieldID.equals(ATTACH_TECHDOC_FID) || fieldID.equals(ATTACH_TABS_FID)) {
            try {
                this.attachDocument(documentClassMap.get(fieldID));
            }
            catch (UnknownEntityException unknownEntityException) {
                throw new AssertionError((Object)CANNOT_PERFORM_THIS_OPERATION_WHEN_ATTACHMENTS_ARE_UNAVAILABLE);
            }
            this.setDocumentControlButtons();
            return;
        }
        if (fieldID.equals(REVIEWERHASPHD_FID) || fieldID.equals(FieldIDs.investigatorSetPiFID)) {
            if (this.mentorGroup != null && obsProposalModel != null) {
                this.mentorGroup.setVisible(obsProposalModel.isMentorRequired());
            }
        } else if (fieldID.equals(SELECT_MENTOR_FID)) {
            iterable = InvestigatorSearchDialog.showDialog(true, "Select Mentor");
            if (!iterable.isEmpty()) {
                obsProposalModel.update(this, MENTOR_FID, iterable.get(0));
            }
        } else {
            if (fieldID.equals(DETACH_MANAGEMENT_PLAN_DOC_FID) || fieldID.equals(DETACH_SCIENCE_CASE_DOC_FID) || fieldID.equals(DETACH_FIGS_FID) || fieldID.equals(DETACH_TECHDOC_FID) || fieldID.equals(DETACH_TABS_FID)) {
                try {
                    this.detachDocument(documentClassMap.get(fieldID));
                }
                catch (UnknownEntityException unknownEntityException) {
                    throw new AssertionError((Object)CANNOT_PERFORM_THIS_OPERATION_WHEN_ATTACHMENTS_ARE_UNAVAILABLE);
                }
                this.setDocumentControlButtons();
                return;
            }
            if (fieldID.equals(VIEW_MANAGEMENT_PLAN_DOC_FID) || fieldID.equals(VIEW_SCIENCE_CASE_DOC_FID) || fieldID.equals(VIEW_FIGS_FID) || fieldID.equals(VIEW_TECHDOC_FID) || fieldID.equals(VIEW_TABS_FID)) {
                try {
                    File file = obsProposalModel.getAttachments().getDocumentLink(documentClassMap.get(fieldID)).getTemporaryFileToView();
                    if (file != null && file.exists()) {
                        this.showFile(file);
                    }
                }
                catch (IOException iOException) {
                    GUIUtilities.warning(null, "Could not create a temporary file : " + iOException.getMessage());
                }
                catch (UnknownEntityException unknownEntityException) {
                    throw new AssertionError((Object)CANNOT_PERFORM_THIS_OPERATION_WHEN_ATTACHMENTS_ARE_UNAVAILABLE);
                }
                return;
            }
        }
        if (fieldID.equals(DATERECEIVED_FID)) {
            iterable = null;
            if (object != null) {
                iterable = object instanceof String ? (String)object : ((Date)object).toString();
            }
            super.update(fieldID, iterable);
        }
        if (fieldID.equals(CATEGORY_FID)) {
            if (object != null && object.equals("")) {
                this.categoryButtons.clearSelection();
                this.keywordList.clearSelection();
                this.keywordList.setListData((String[])new String[0]);
            } else {
                iterable = almaPolicies.getScienceCodeForCategory((String)object);
                ObsProposal obsProposal = obsProposalModel.getObsProposal();
                String[] stringArray = obsProposal.getKeyword();
                String[] stringArray2 = almaPolicies.getScienceKeywords((String)((Object)iterable));
                if (stringArray2 == null) {
                    stringArray2 = new String[]{};
                }
                this.suspendEvents(this.keywordList);
                this.keywordList.setListData((String[])stringArray2);
                this.resumeEvents(this.keywordList);
                super.update(KEYWORDS_FID, stringArray);
            }
        } else if (fieldID.equals(PROPOSALTYPE_FID)) {
            ObservingToolGuiProjectCompartment observingToolGuiProjectCompartment;
            if (object != null && object.equals("")) {
                this.normalProposalButtons.clearSelection();
            }
            if ((observingToolGuiProjectCompartment = ((ObservingToolGui)((Object)(iterable = this.otc.getGui()))).primaryProjectCompartment()) != null) {
                Action action = observingToolGuiProjectCompartment.getProjectTiedActions().runProjectSummaryDisplay;
                if (object != null && object.equals("VLBI")) {
                    action.setEnabled(false);
                } else {
                    action.setEnabled(true);
                }
                String string = StringUtils.containsIgnoreCase((CharSequence)((String)object), (CharSequence)"large") ? String.format("Science Case (Mandatory, PDF, %d pages max.)", MAX_SCIENCE_CASE_LARGE_PROGRAM_PAGES) : String.format("Science Case (Mandatory, PDF, %d pages max.)", MAX_SCIENCE_CASE_PAGES);
                assert (string != null);
                JLabel jLabel = (JLabel)this.getComponent(FID_SCIENCE_CASE_LABEL);
                jLabel.setText(string);
                this.investigatorEditor.update(fieldID, object);
                this.configureEditorForStandardView();
            }
        } else if (fieldID.equals(ADVANCEDPROPOSALTYPE_FID)) {
            if (object != null && object.equals("")) {
                this.advancedProposalButtons.clearSelection();
            }
        } else if (fieldID.equals(CYCLE_FID)) {
            iterable = obsProposalModel;
            if (iterable != null) {
                String string = ((ObsProposalModel)iterable).isDDT() ? " (DDT)" : "";
                super.update(CYCLE_FID, object + string);
                if (this.investigatorEditor != null) {
                    this.investigatorEditor.update(CYCLE_FID, object);
                }
                return;
            }
        } else if (fieldID.equals(JointProposalEditor.JOINT_PROPOSAL_TYPE_FID) && object instanceof String) {
            this.setProposalTypeSelectionOptionsForJointProposals();
        } else if (fieldID.equals(JointProposalEditor.IS_JOINT_PROPOSAL_FID) && object instanceof String) {
            this.setProposalTypeSelectionOptionsForJointProposals();
        }
        super.update(fieldID, object);
    }

    private void setProposalTypeSelectionOptionsForJointProposals() {
        boolean bl = this.getModel().getJointProposalModel().getJointProposalsEnabled();
        String string = this.getModel().getJointProposalModel().getJointProposalType();
        boolean bl2 = StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"Partner");
        boolean bl3 = !bl || !bl2;
        String string2 = almaPolicies.getProposalTypeForCode("L");
        String string3 = almaPolicies.getProposalTypeForCode("P");
        String string4 = almaPolicies.getProposalTypeForCode("V");
        this.normalProposalButtons.getButtonStream().filter(abstractButton -> abstractButton.getText().contains(string2)).findFirst().ifPresent(abstractButton -> abstractButton.setEnabled(bl3));
        this.normalProposalButtons.getButtonStream().filter(abstractButton -> abstractButton.getText().contains(string2)).findFirst().ifPresent(abstractButton -> abstractButton.setEnabled(bl3));
        boolean bl4 = bl && !bl2 || !bl;
        this.normalProposalButtons.getButtonStream().filter(abstractButton -> abstractButton.getText().contains(string2)).findFirst().ifPresent(abstractButton -> abstractButton.setEnabled(bl3));
    }

    private void attachDocument(@NonNull String string) throws UnknownEntityException {
        String string2;
        boolean bl;
        File file;
        block8: {
            if (string == null) {
                throw new NullPointerException("documentClass is marked non-null but is null");
            }
            JFileChooser jFileChooser = this.getFileChooser();
            jFileChooser.setDialogTitle("Open");
            jFileChooser.setMultiSelectionEnabled(false);
            if (jFileChooser.showOpenDialog(this) != 0) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            bl = false;
            try {
                ObsAttachment obsAttachment = this.getModel().getObsProposal().getDocuments();
                if (obsAttachment == null) break block8;
                for (DocumentLink documentLink : string2 = obsAttachment.getDocumentLink()) {
                    if (!documentLink.getFileName().equals(file.getName())) continue;
                    bl = true;
                    break;
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
        }
        if (bl) {
            string2 = "Duplicate filename: " + file.getName() + " already attached";
            GUIUtilities.error(null, string2);
            return;
        }
        try {
            this.validateFile(file, string);
            this.getModel().attachDocument(file, string);
        }
        catch (IllegalAttachmentException illegalAttachmentException) {
            GUIUtilities.warning(null, illegalAttachmentException.getMessage());
        }
    }

    private void validateFile(@NonNull File file, @NonNull String string) throws IllegalAttachmentException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (string == null) {
            throw new NullPointerException("documentClass is marked non-null but is null");
        }
        if (!file.exists()) {
            String string2 = "File does not exist : " + file.getName();
            throw new IllegalAttachmentException(string2);
        }
        if (file.getName().length() >= 50) {
            throw new IllegalAttachmentException("The file name must contain fewer than 50 characters.");
        }
        long l = file.length();
        ObsProposal obsProposal = this.getModel().getObsProposal();
        assert (obsProposal != null);
        long l2 = attachmentMaxSizes.get(string);
        int n = attachmentMaxPages.get(string);
        if (string.equals(DocumentLinkData.DOCUMENTCLASS_SCIENCE_CASE) && obsProposal.isLargeProgram()) {
            n = attachmentMaxPages.get("DOCUMENTCLASS_LARGE_PROGRAM_SCIENCE_CASE");
            l2 = attachmentMaxSizes.get("DOCUMENTCLASS_LARGE_PROGRAM_SCIENCE_CASE");
        }
        if (l > l2) {
            String string3 = String.format("%s document must be smaller than %.1f MB : %s %.1f MB", string, (double)l2 / 1024.0 / 1024.0, file.getName(), (double)l / 1024.0 / 1024.0);
            throw new IllegalAttachmentException(string3);
        }
        boolean bl = false;
        try {
            bl = this.getModel().getObsProposal().getJointProposal().isPartnerJointProposal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try (PdfReader pdfReader = null;){
            pdfReader = new PdfReader((InputStream)new FileInputStream(file));
            if (!pdfReader.isOpenedWithFullPermissions()) {
                String string4 = "You can not use a pdf file protected by a password.";
                throw new IllegalAttachmentException(string4);
            }
            int n2 = pdfReader.getNumberOfPages();
            if (n2 > n && !bl) {
                String string5 = String.format("Maximum number of pages allowed for the %s document is %d, while %s has %d pages.", string, n, file.getName(), n2);
                throw new IllegalAttachmentException(string5);
            }
        }
    }

    private void detachDocument(@NonNull String string) throws UnknownEntityException {
        if (string == null) {
            throw new NullPointerException("documentClass is marked non-null but is null");
        }
        this.getModel().detachDocument(string);
    }

    public void setManagementPlanButtons() {
        boolean bl;
        ObsAttachment obsAttachment;
        if (this.managementPlanDocumentsGroupPanel == null) {
            return;
        }
        try {
            obsAttachment = this.getModel().gettrueAttachments();
            bl = true;
        }
        catch (UnknownEntityException unknownEntityException) {
            obsAttachment = null;
            bl = false;
        }
        boolean bl2 = obsAttachment != null && obsAttachment.gettrueDocumentLink(DocumentLinkData.DOCUMENTCLASS_MANAGEMENT_PLAN) != null;
        this.getComponent(ATTACH_MANAGEMENT_PLAN_DOC_FID).setEnabled(bl);
        this.getComponent(DETACH_MANAGEMENT_PLAN_DOC_FID).setEnabled(bl && bl2);
        this.getComponent(VIEW_MANAGEMENT_PLAN_DOC_FID).setEnabled(bl && bl2);
        JLabel jLabel = (JLabel)this.getComponent(AVAILABILITY_MSG_FID);
        jLabel.setText(bl ? "" : "NOTE: DOCUMENTS ARE NOT AVAILABLE");
    }

    public void setDocumentControlButtons() {
        this.setScienceCaseButtons();
        this.setManagementPlanButtons();
    }

    public void setScienceCaseButtons() {
        boolean bl;
        ObsAttachment obsAttachment;
        if (this.scienceCaseDocumentsGroupPanel == null) {
            return;
        }
        try {
            obsAttachment = this.getModel().gettrueAttachments();
            bl = true;
        }
        catch (UnknownEntityException unknownEntityException) {
            obsAttachment = null;
            bl = false;
        }
        boolean bl2 = obsAttachment != null && obsAttachment.gettrueDocumentLink(DocumentLinkData.DOCUMENTCLASS_SCIENCE_CASE) != null;
        this.getComponent(ATTACH_SCIENCE_CASE_DOC_FID).setEnabled(bl);
        this.getComponent(DETACH_SCIENCE_CASE_DOC_FID).setEnabled(bl && bl2);
        this.getComponent(VIEW_SCIENCE_CASE_DOC_FID).setEnabled(bl && bl2);
        JLabel jLabel = (JLabel)this.getComponent(AVAILABILITY_MSG_FID);
        jLabel.setText(bl ? "" : "NOTE: DOCUMENTS ARE NOT AVAILABLE");
    }

    private void showFile(@NonNull File file) {
        block12: {
            Desktop desktop;
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            if (!file.exists()) {
                GUIUtilities.warning(null, "File not found : " + file);
                return;
            }
            Log.Logger logger = Log.logger((Object)this);
            try {
                desktop = Desktop.getDesktop();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                GUIUtilities.warning(null, "Cannot launch viewer: Either your platform doesn't support this feature or it is not configured");
                return;
            }
            try {
                if (logger.fine()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(">>>>>>>>>>>> ObsProposal <<<<<<<<<<<<<<<<");
                    stringBuilder.append(this.getModel().getObsProposal().toXml());
                    stringBuilder.append("\n");
                    stringBuilder.append(">>>>>>>>>>>> ObsAttachment <<<<<<<<<<<<<<<<");
                    try {
                        stringBuilder.append(this.getModel().getAttachments().toXml());
                    }
                    catch (Exception exception) {
                        stringBuilder.append("problem: " + exception);
                    }
                    logger.fine(stringBuilder.toString());
                }
                desktop.open(file);
            }
            catch (IOException iOException) {
                if (!file.canRead()) {
                    GUIUtilities.warning(null, "Can not open the file : " + file);
                    return;
                }
                String string = System.getProperty("os.name");
                if (string == null || !string.toLowerCase().startsWith("windows")) break block12;
                try {
                    Runtime.getRuntime().exec("rundll32 url.dll, FileProtocolHandler " + file.getAbsolutePath());
                }
                catch (IOException iOException2) {
                    logger.warning(iOException.getMessage());
                    logger.warning(iOException2.getMessage());
                }
            }
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileSelector == null) {
            this.fileSelector = GuiFactory.getFactory().giveFileChooser(this);
        }
        return this.fileSelector;
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        ObservingToolController observingToolController = new ObservingToolController();
        ObsProposal obsProposal = ObsProposal.createObsProposal();
        ObsProposalModel obsProposalModel = new ObsProposalModel(null);
        ObsProposalEditor obsProposalEditor = new ObsProposalEditor((Model)obsProposalModel, observingToolController);
        obsProposalModel.setDocument(obsProposal);
        EditorWithGridBagLayout.runTestApp(obsProposalEditor, 800, 1000);
    }

    private void configureEditorForStandardView() {
        boolean bl;
        ObsProposalModel obsProposalModel = this.getModel();
        boolean bl2 = obsProposalModel.isDDT();
        this.jointProposalComponentGroup.setVisible(!bl2);
        if (bl2) {
            obsProposalModel.setJointProposalEnabled(false);
        }
        boolean bl3 = AlmaPolicies.getInstance().isSupplementalCallEnabled();
        boolean bl4 = bl = obsProposalModel.isDPRRequired() || bl3;
        if (this.managementPlanPanel != null) {
            this.managementPlanPanel.setVisible(obsProposalModel.isLargeProgram());
        }
        if (!bl) {
            if (this.reviewerPanel != null) {
                this.reviewerPanel.setVisible(false);
            }
            return;
        }
        try {
            ObsProject obsProject;
            try {
                obsProject = ObservingToolController.getOTGui().getPrimaryProject();
            }
            catch (Exception exception) {
                return;
            }
            ObsProposal obsProposal = obsProject.getObsProposal();
            if (obsProject.isProjectWithStatus(ObsProjectData.STATUS_NEWPHASE1)) {
                boolean bl5 = obsProposal.isSupplementalCallProposal();
                List<String> list = Arrays.asList(almaPolicies.getKnownProposalTypes());
                list.stream().filter(string -> !string.equals(REGULAR_PROPOSAL)).forEach(string -> this.normalProposalButtons.find((String)string).setEnabled(!bl5));
                if (bl5) {
                    String string2 = null;
                    try {
                        string2 = this.normalProposalButtons.getSelectedItem();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    if (!StringUtils.equals((CharSequence)string2, (CharSequence)REGULAR_PROPOSAL)) {
                        list.stream().filter(string -> string.equals(REGULAR_PROPOSAL)).findFirst().ifPresent(string -> this.normalProposalButtons.find((String)string).doClick());
                    }
                } else {
                    list.stream().filter(string -> string.equals(REGULAR_PROPOSAL)).findFirst().ifPresent(string -> this.normalProposalButtons.find((String)string).setEnabled(true));
                }
                this.setProposalTypeSelectionOptionsForJointProposals();
            }
            this.reviewerPanel.setVisible(bl);
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(this.getClass()).warning("Unable to determine if this is a supplemental call " + unknownEntityException.getMessage());
        }
        this.setDocumentControlButtons();
    }

    static {
        tooltips.put(FieldIDs.projectNameFID, "The title of the proposal.");
        tooltips.put(FieldIDs.codeFID, "Code assigned to the project");
        tooltips.put(CATEGORY_FID, "A scientific category for the proposal, chosen from the list");
        tooltips.put(KEYWORDS_FID, "Select the appropriate science category keywords, maximum 2 keywords");
        tooltips.put(ABSTRACT_FID, "A short, textual, abstract of the proposal, maximum " + MAX_ABSTRACT_CHARACTERS + " characters");
        tooltips.put(PROPOSALTYPE_FID, "<html>Proposal type, chosen from the list </html>");
        tooltips.put(ADVANCEDPROPOSALTYPE_FID, "<html>Proposal type, chosen from the list </html>");
        tooltips.put(SUPPORTREQ_FID, "");
        tooltips.put(PRCGRADE_FID, "Grade assigned to the project");
        tooltips.put(RELATEDPROPS_FID, "<html>Related ALMA proposals from this Cycle (code, title, PI name)</html>");
        tooltips.put(PREVIOUSPROPS_FID, "<html>Related ALMA proposals from previous Cycles (code, title, PI name and Publication Status)</html>");
        tooltips.put(DATERECEIVED_FID, "The date this proposal was submitted to the observatory.");
        tooltips.put(CYCLE_FID, "The proposal submission cycle for which this proposal will be/was first submitted");
        tooltips.put(STAFFCONTACT_FID, "");
        tooltips.put(CONTACTPERSON_FID, "");
        tooltips.put(REVIEWERHASPHD_FID, "Does the reviewer of the supplemental proposal have a PhD");
        tooltips.put(ATTACH_SCIENCE_CASE_DOC_FID, "Attach the mandatory science case document (" + MAX_SCIENCE_CASE_PAGES + " pages max, " + MAX_SCIENCE_CASE_LARGE_PROGRAM_PAGES + " for large programs");
        tooltips.put(DETACH_SCIENCE_CASE_DOC_FID, "Remove the science case document");
        tooltips.put(SCIDOCUMENT_FID, "The filename of the science case document.");
        tooltips.put(MANAGEMENT_PLAN_DOCUMENT_FID, "The filename of the management plan document.");
        tooltips.put(VIEW_SCIENCE_CASE_DOC_FID, "View the document using the default application.");
        tooltips.put(ATTACH_TECHDOC_FID, "Attach the technical case document (2 pages max)");
        tooltips.put(DETACH_TECHDOC_FID, "Remove the technical case document");
        tooltips.put(TECHDOCUMENT_FID, "The filename of the technical case document.");
        tooltips.put(VIEW_TECHDOC_FID, "View the document using the default application.");
        tooltips.put(ATTACH_FIGS_FID, "Attach optional supporting figures (1 file, 2 pages max)");
        tooltips.put(DETACH_FIGS_FID, "Remove the suppoorting document");
        tooltips.put(FIGURES_FID, "The filename of the supporting document");
        tooltips.put(VIEW_FIGS_FID, "View the document using the default application.");
        tooltips.put(ATTACH_TABS_FID, "Attach optional supporting tables (1 file, 2 pages max)");
        tooltips.put(DETACH_TABS_FID, "Remove the suppoorting document");
        tooltips.put(TABLES_FID, "The filename of the supporting document");
        tooltips.put(VIEW_TABS_FID, "View the document using the default application.");
        documentClassMap = new HashMap<FieldID, String>();
        documentClassMap.put(ATTACH_SCIENCE_CASE_DOC_FID, DocumentLinkData.DOCUMENTCLASS_SCIENCE_CASE);
        documentClassMap.put(DETACH_SCIENCE_CASE_DOC_FID, DocumentLinkData.DOCUMENTCLASS_SCIENCE_CASE);
        documentClassMap.put(VIEW_SCIENCE_CASE_DOC_FID, DocumentLinkData.DOCUMENTCLASS_SCIENCE_CASE);
        documentClassMap.put(ATTACH_MANAGEMENT_PLAN_DOC_FID, DocumentLinkData.DOCUMENTCLASS_MANAGEMENT_PLAN);
        documentClassMap.put(DETACH_MANAGEMENT_PLAN_DOC_FID, DocumentLinkData.DOCUMENTCLASS_MANAGEMENT_PLAN);
        documentClassMap.put(VIEW_MANAGEMENT_PLAN_DOC_FID, DocumentLinkData.DOCUMENTCLASS_MANAGEMENT_PLAN);
        documentClassMap.put(ATTACH_TECHDOC_FID, DocumentLinkData.DOCUMENTCLASS_TECHNICAL_CASE);
        documentClassMap.put(DETACH_TECHDOC_FID, DocumentLinkData.DOCUMENTCLASS_TECHNICAL_CASE);
        documentClassMap.put(VIEW_TECHDOC_FID, DocumentLinkData.DOCUMENTCLASS_TECHNICAL_CASE);
        documentClassMap.put(ATTACH_FIGS_FID, DocumentLinkData.DOCUMENTCLASS_FIGURES);
        documentClassMap.put(DETACH_FIGS_FID, DocumentLinkData.DOCUMENTCLASS_FIGURES);
        documentClassMap.put(VIEW_FIGS_FID, DocumentLinkData.DOCUMENTCLASS_FIGURES);
        documentClassMap.put(ATTACH_TABS_FID, DocumentLinkData.DOCUMENTCLASS_TABLES);
        documentClassMap.put(DETACH_TABS_FID, DocumentLinkData.DOCUMENTCLASS_TABLES);
        documentClassMap.put(VIEW_TABS_FID, DocumentLinkData.DOCUMENTCLASS_TABLES);
        attachmentMaxSizes = new HashMap<String, Long>();
        attachmentMaxSizes.put("DOCUMENTCLASS_LARGE_PROGRAM_SCIENCE_CASE", 0x1E00000L);
        attachmentMaxSizes.put(DocumentLinkData.DOCUMENTCLASS_SCIENCE_CASE, 0x1400000L);
        attachmentMaxSizes.put(DocumentLinkData.DOCUMENTCLASS_TECHNICAL_CASE, 0x100000L);
        attachmentMaxSizes.put(DocumentLinkData.DOCUMENTCLASS_FIGURES, 0x500000L);
        attachmentMaxSizes.put(DocumentLinkData.DOCUMENTCLASS_TABLES, 0x500000L);
        attachmentMaxSizes.put(DocumentLinkData.DOCUMENTCLASS_MANAGEMENT_PLAN, 0x100000L);
        attachmentMaxPages = new HashMap<String, Integer>();
        attachmentMaxPages.put("DOCUMENTCLASS_LARGE_PROGRAM_SCIENCE_CASE", MAX_SCIENCE_CASE_LARGE_PROGRAM_PAGES);
        attachmentMaxPages.put(DocumentLinkData.DOCUMENTCLASS_SCIENCE_CASE, MAX_SCIENCE_CASE_PAGES);
        attachmentMaxPages.put(DocumentLinkData.DOCUMENTCLASS_TECHNICAL_CASE, 2);
        attachmentMaxPages.put(DocumentLinkData.DOCUMENTCLASS_FIGURES, 2);
        attachmentMaxPages.put(DocumentLinkData.DOCUMENTCLASS_TABLES, 2);
        attachmentMaxPages.put(DocumentLinkData.DOCUMENTCLASS_MANAGEMENT_PLAN, MAX_MANAGEMENT_PLAN_CASE_PAGES);
    }

    private static class IllegalAttachmentException
    extends Exception {
        private static final long serialVersionUID = -8511679659893303119L;

        public IllegalAttachmentException(String string) {
            super(string);
        }

        public IllegalAttachmentException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

