/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.mapper;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.annotations.FieldPatternI;
import alma.obsprep.bo.annotations.PointingPatternI;
import alma.obsprep.ot.editors.spatialvisual.BaseSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.BOFigureListManager;
import alma.obsprep.ot.editors.spatialvisual.mapper.FieldMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.FovFigure;
import alma.obsprep.ot.editors.spatialvisual.mapper.Mapper;
import alma.obsprep.ot.editors.spatialvisual.mapper.PatternFigure;
import alma.obsprep.ot.editors.spatialvisual.mapper.PointingMapper;
import alma.obsprep.util.astro.PointingCoordsConverter;
import alma.valuetypes.SkyCoordinates;
import java.awt.geom.Point2D;
import javax.swing.ListSelectionModel;
import jsky.coords.CoordinateConverter;
import jsky.image.gui.MainImageDisplay;
import org.junit.Assert;

public class PointingMapperModel
extends FieldMapperModel {
    public PointingMapperModel(BaseSpatialVisualModel baseSpatialVisualModel) {
        super(baseSpatialVisualModel);
    }

    public PointingMapper getPointingMapper() {
        return (PointingMapper)this.mapper;
    }

    @Override
    public void publish() {
        FieldPatternI fieldPatternI = this.getFieldPattern();
        if (fieldPatternI == null || !fieldPatternI.isPointingPattern()) {
            return;
        }
        PointingPatternI pointingPatternI = (PointingPatternI)fieldPatternI;
        boolean bl = true;
        if (pointingPatternI.getPhaseCenterCoordinatesCount() <= AlmaPolicies.getInstance().getMaxNumberPointings()) {
            for (SkyCoordinates skyCoordinates : pointingPatternI.getPhaseCenterCoordinates()) {
                this.publishPointing(skyCoordinates, bl);
                bl = false;
            }
        }
    }

    public SkyCoordinates[] getPhaseCenterCoordinates() {
        FieldPatternI fieldPatternI = this.getFieldPattern();
        if (fieldPatternI == null || !fieldPatternI.isPointingPattern()) {
            return null;
        }
        PointingPatternI pointingPatternI = (PointingPatternI)fieldPatternI;
        return pointingPatternI.getPhaseCenterCoordinates();
    }

    public int getPhaseCenterCoordinatesCount() {
        FieldPatternI fieldPatternI = this.getFieldPattern();
        if (fieldPatternI == null || !fieldPatternI.isPointingPattern()) {
            return 0;
        }
        PointingPatternI pointingPatternI = (PointingPatternI)fieldPatternI;
        return pointingPatternI.getPhaseCenterCoordinatesCount();
    }

    public void importPattern() {
        this.getPointingMapper().importPointing();
    }

    @Override
    protected void updateBO(PatternFigure patternFigure) {
        MainImageDisplay.CoordSystemType coordSystemType;
        FovFigure fovFigure;
        FieldPatternI fieldPatternI = this.getFieldPattern();
        if (!fieldPatternI.isPointingPattern()) {
            return;
        }
        try {
            fovFigure = (FovFigure)patternFigure;
        }
        catch (ClassCastException classCastException) {
            return;
        }
        try {
            coordSystemType = this.mapper.getImageCoordinateSystem();
        }
        catch (Mapper.NoImageWCSException noImageWCSException) {
            Log.logger(PointingMapperModel.class).warning("Unable to determine the coordinate system of the loaded image");
            return;
        }
        Assert.assertNotNull((Object)coordSystemType);
        CoordinateConverter coordinateConverter = this.getPointingMapper().getCoordinateConverter();
        PointingCoordsConverter pointingCoordsConverter = this.getPointingMapper().getPointingCoordsConverter();
        double d = fovFigure.getBounds().getCenterX();
        double d2 = fovFigure.getBounds().getCenterY();
        Point2D.Double double_ = new Point2D.Double(d, d2);
        coordinateConverter.screenToWorldCoords(double_, false);
        if (fieldPatternI.isAbsolutePointingPattern()) {
            SkyCoordinates skyCoordinates = (SkyCoordinates)fovFigure.getBusinessObject();
            String string = skyCoordinates.getSystem();
            switch (coordSystemType) {
                case UNKNOWN: 
                case EQUATORIAL: {
                    skyCoordinates.setAbsoluteCoordinatesInJ2000Deg(double_);
                    break;
                }
                case GALACTIC: {
                    skyCoordinates.setAbsoluteCoordinatesInGalacticDeg(double_);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown coordinate system detected : " + coordSystemType);
                }
            }
            skyCoordinates.convertToSystem(string);
        } else {
            SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates();
            switch (coordSystemType) {
                case UNKNOWN: 
                case EQUATORIAL: {
                    skyCoordinates.setAbsoluteCoordinatesInJ2000Deg(double_);
                    break;
                }
                case GALACTIC: {
                    skyCoordinates.setAbsoluteCoordinatesInGalacticDeg(double_);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown coordinate system detected : " + coordSystemType);
                }
            }
            SkyCoordinates skyCoordinates2 = (SkyCoordinates)fovFigure.getBusinessObject();
            pointingCoordsConverter.setOrigin(this.getTargetCenter());
            pointingCoordsConverter.absoluteToOffset(skyCoordinates, skyCoordinates2);
        }
        this.updateFormEditor();
    }

    public void publishPointing(SkyCoordinates skyCoordinates, boolean bl) {
        this.getPointingMapper().update(skyCoordinates, bl);
    }

    protected SkyCoordinates addPatternPointing() {
        if (this.isSingleMode) {
            this.initialize();
        }
        return this.getSpatialVisualModel().getVisualModelHelper().addPointing();
    }

    protected void deletePatternPointing(SkyCoordinates skyCoordinates) {
        if (this.isSingleMode) {
            this.initialize();
        } else {
            this.getSpatialVisualModel().getVisualModelHelper().deletePointing(skyCoordinates);
        }
    }

    protected SkyCoordinates getTargetCenter() {
        return this.getSpatialVisualModel().getVisualModelHelper().getTargetCenter();
    }

    public FieldPatternI getFieldPattern() {
        return this.getSpatialVisualModel().getVisualModelHelper().getFieldPattern();
    }

    public BOFigureListManager getBoFigureListManager() {
        return this.getPointingMapper().getBoFigureListManager();
    }

    public boolean isFovFigureSelectionEnabled() {
        return this.getPointingMapper().isFovFigureSelectionEnabled();
    }

    public void setTableSelectionModel(ListSelectionModel listSelectionModel) {
        this.getPointingMapper().setTableSelectionModel(listSelectionModel);
    }
}

