/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.valuetypes;

import alma.obsprep.bo.annotations.SkyField;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.valuetypes.CoordsTypeEnum;
import alma.obsprep.ot.editors.valuetypes.OffsetEditor;
import alma.obsprep.ot.editors.valuetypes.SkyCoordsEditor;
import alma.obsprep.ot.editors.valuetypes.SystemNotEditableSkyCoordsEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.valuetypes.CoordsModel;
import alma.valuetypes.SkyCoordinates;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class CoordsEditor
extends EditorWithGridBagLayout {
    OffsetEditor offsetEditor;
    SkyCoordsEditor absoluteCoordsOffsetEditor;
    public static final FieldID FID_COORDS_TYPE = new FieldID("CoordsEditor.coordsType");
    public static final FieldID FID_COORDS_SYSTEM = new FieldID("CoordsEditor.coordsSystem");

    public CoordsEditor(boolean bl, Model model) {
        this.setModel(model);
        OffsetEditor.OffsetEditorBuilder offsetEditorBuilder = OffsetEditor.getOffsetBuilder();
        offsetEditorBuilder.withIsCollapsible(true).withIsSystemUserModifiable(bl).withModel(this.getModel().getOffsetCoordsModel());
        this.offsetEditor = offsetEditorBuilder.build();
        this.absoluteCoordsOffsetEditor = bl ? new SkyCoordsEditor(this.getModel().getSkyCoordsModel()) : new SystemNotEditableSkyCoordsEditor(this.getModel().getSkyCoordsModel());
        this.registerSubView(this.offsetEditor);
        this.registerSubView(this.absoluteCoordsOffsetEditor);
        this.build();
        model.publish();
    }

    @Override
    public CoordsModel getModel() {
        return (CoordsModel)super.getModel();
    }

    @Override
    protected void addComponents(String string) {
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        OTButtonGroup oTButtonGroup = this.makeOTButtonGroup(FID_COORDS_TYPE, CoordsTypeEnum.values(), new String[]{"Relative coordinate type", "Absolute coordinate type"});
        oTButtonGroup.setName("CoordsEditor.CoordsTypeLabel");
        oTButtonGroup.setButtonName(CoordsTypeEnum.Absolute.getBOMapping(), "CoordsEditor.AbsoluteButton");
        oTButtonGroup.setButtonName(CoordsTypeEnum.Relative.getBOMapping(), "CoordsEditor.RelativeButton");
        JLabel jLabel = this.makeLabel("Coords Type");
        Box box = Box.createHorizontalBox();
        box.add(jLabel);
        box.add(oTButtonGroup);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.addComponent(box);
        this.addComponent(this.offsetEditor);
        this.addComponent(this.absoluteCoordsOffsetEditor);
        oTButtonGroup.setSelectedItem(CoordsTypeEnum.Relative.getUILabel());
        this.update(FID_COORDS_TYPE, CoordsTypeEnum.Relative.getBOMapping());
    }

    public OTButtonGroup getCoordsTypeComponents() {
        return (OTButtonGroup)this.getComponent(FID_COORDS_TYPE);
    }

    @Override
    protected void build() {
        super.build("SkyCoordinates");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        super.update(fieldID, object);
        if (fieldID.equals(FID_COORDS_TYPE)) {
            OTButtonGroup oTButtonGroup = (OTButtonGroup)this.getComponent(FID_COORDS_TYPE);
            if (object != null && oTButtonGroup.getSelectedItem().equals(CoordsTypeEnum.Absolute.getUILabel())) {
                this.absoluteCoordsOffsetEditor.setVisible(true);
                this.offsetEditor.setVisible(false);
                this.absoluteCoordsOffsetEditor.getModel().publish();
            } else {
                this.absoluteCoordsOffsetEditor.setVisible(false);
                this.offsetEditor.setVisible(true);
                this.offsetEditor.getModel().publish();
            }
        }
    }

    @Override
    public List<JComponent> getUserRestrictedEditableComponents() {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        arrayList.addAll(this.absoluteCoordsOffsetEditor.getUserRestrictedEditableComponents());
        arrayList.addAll(this.offsetEditor.getUserRestrictedEditableComponents());
        return arrayList;
    }

    public static CoordsEditorBuilder coordsEditor() {
        return new CoordsEditorBuilder();
    }

    public static void main(String[] stringArray) {
        SinglePoint singlePoint;
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Single Field Editor");
        jFrame.setPreferredSize(new Dimension(600, 600));
        jFrame.setDefaultCloseOperation(3);
        SinglePoint singlePoint2 = singlePoint = SinglePoint.createSinglePoint();
        singlePoint.getCentre().setType(SkyCoordinates.TYPE_RELATIVE);
        CoordsModel coordsModel = new CoordsModel((SkyField)((Object)singlePoint2));
        CoordsEditor coordsEditor = new CoordsEditor(true, coordsModel);
        jFrame.getContentPane().setLayout(new BoxLayout(jFrame.getContentPane(), 3));
        jFrame.getContentPane().add(coordsEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static class CoordsEditorBuilder {
        private boolean systemPIModifiable;
        private Model model;

        public CoordsEditorBuilder withSystemPIModifiable(boolean bl) {
            this.systemPIModifiable = bl;
            return this;
        }

        public CoordsEditorBuilder withModel(Model model) {
            this.model = model;
            return this;
        }

        public CoordsEditor build() {
            return new CoordsEditor(this.systemPIModifiable, this.model);
        }
    }
}

