/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.obsprep.ot.gui.toplevel.FoldTextPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.stream.Stream;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

class Information
extends JPanel
implements ActionListener {
    private final Box box;
    private JPopupMenu popupMenu;

    Information() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(new JEditorPane().getBackground());
        this.box = new Box(1);
        this.add((Component)this.box, "North");
        this.addJPanelPopupMenu();
    }

    private void addJPanelPopupMenu() {
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Copy Text");
        jMenuItem.addActionListener(this);
        this.popupMenu.add(jMenuItem);
        this.setComponentPopupMenu(this.popupMenu);
    }

    void addMessage(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new NullPointerException("summary is marked non-null but is null");
        }
        if (string2 == null) {
            throw new NullPointerException("detail is marked non-null but is null");
        }
        FoldTextPane foldTextPane = new FoldTextPane(string, string2);
        foldTextPane.setComponentPopupMenu(this.popupMenu);
        this.box.add(foldTextPane);
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        Stream.of(this.box.getComponents()).filter(component -> component instanceof FoldTextPane).map(component -> (FoldTextPane)component).forEach(foldTextPane -> {
            if (!StringUtils.isEmpty((CharSequence)foldTextPane.getSelectedText())) {
                stringBuilder.append(foldTextPane.getSelectedText());
            }
        });
        StringSelection stringSelection = new StringSelection(stringBuilder.length() > 0 ? stringBuilder.toString() : "");
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }
}

