/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.scripting.BatchOT;
import alma.obsprep.ot.scripting.PythonEnv;
import java.io.File;
import java.io.IOException;
import org.python.core.PyException;

public class ObservingToolBatch {
    private static Log.Logger logger = null;
    private static final int SUCCESS = 0;
    private static final int FAILURE = 1;
    private static PythonEnv python;

    public static void main(String[] stringArray) throws IOException {
        int n;
        BatchOT batchOT = null;
        try {
            batchOT = new BatchOT();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ObservingToolBatch.exit(1);
        }
        logger = Log.logger(ObservingToolBatch.class);
        if (stringArray.length == 0) {
            logger.severe("No script name given, exiting.");
            ObservingToolBatch.exit(1);
        }
        String string = stringArray[0];
        File file = new File(".");
        String string2 = file.getCanonicalPath();
        logger.info("Starting ObservingTool " + InitServices.getUserVersion() + " in batch mode from " + string2);
        String[] stringArray2 = null;
        if (stringArray.length > 1) {
            n = stringArray.length - 1;
            stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = stringArray[i + 1];
            }
        }
        PythonEnv.initialize(null, null, stringArray2);
        python = PythonEnv.getInstance(System.out, false, System.getProperties().getProperty("python.ot.libs"));
        batchOT.setHostingEnv(python);
        python.setVariable("batchOT", batchOT);
        n = 1;
        try {
            n = python.execfile(string);
        }
        catch (PyException pyException) {
            String string3 = python.message(pyException);
            logger.severe("Execution of " + string + " failed: " + string3);
            ObservingToolBatch.exit(1);
        }
        if (n != 0) {
            logger.severe("Execution of " + string + " failed (retcode=" + n + ")");
            ObservingToolBatch.exit(1);
        }
        logger.info("Exiting");
        ObservingToolBatch.exit(0);
    }

    private static void exit(int n) {
        python.getConsoleStream().flush();
        System.out.flush();
        System.err.flush();
        System.exit(n);
    }
}

