/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.AttachableToTarget;
import alma.obsprep.bo.annotations.SpectralSpecDocument;
import alma.obsprep.bo.schedblock.ACACorrelatorConfiguration;
import alma.obsprep.bo.schedblock.ACAPhaseSwitchingConfiguration;
import alma.obsprep.bo.schedblock.ACASpectrometerCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BLCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.DataRateChangeListener;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.SquareLawSetup;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.defaulters.CircularDependencyException;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.schedblock.BaseBandConfigEditor;
import alma.obsprep.ot.editors.schedblock.SpectralSpecBaseEditor;
import alma.obsprep.ot.editors.schedblock.SpectralSpecVisualEditor;
import alma.obsprep.ot.models.schedblock.ACAPhaseSwitchingConfigurationModel;
import alma.obsprep.ot.models.schedblock.BaseBandConfigModel;
import alma.obsprep.ot.models.schedblock.BaseBandConfigTabbedModel;
import alma.obsprep.ot.models.schedblock.SquareLawSetupModel;
import alma.obsprep.ot.models.schedblock.SwitchingCycleModel;
import alma.obsprep.ot.models.schedblock.UsedByTargetModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.ot.valdef.schedblock.DefFrequencySetup;
import alma.obsprep.ot.valdef.schedblock.DefReceiverType;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SpectralSpecModel
extends Model {
    private UsedByTargetModel usedByTargetModel = null;
    private ValueUnitPairModel restFrequencyModel = null;
    private ValueUnitPairModel integrationTimeModel = null;
    private ValueUnitPairModel subscanDurationModel = null;
    private ValueUnitPairModel integrationDurationModel = null;
    private ValueUnitPairModel channelAverageDurationModel = null;
    private ValueUnitPairModel dumpDurationModel = null;
    private SwitchingCycleModel switchCycleModel = null;
    private ACAPhaseSwitchingConfigurationModel phaseSwitchingConfigurationModel = null;
    private SquareLawSetupModel squareLawSetupModel = null;
    private BaseBandConfigTabbedModel baseBandConfigTabbedModel = null;
    private DefFrequencySetup freqSetupDefaulter = null;
    private DefReceiverType receiverTypeDefaulter = null;
    private final DataRateChangeListener dataRateChangeListener;
    private SpectralSpecDocument context;
    private final Collection<SpectralLine> overlayLines = new ArrayList<SpectralLine>();
    boolean isPublishingFirstBBFrequency = false;

    public void setOverlayLines(Collection<SpectralLine> collection) {
        this.overlayLines.clear();
        if (collection != null) {
            this.overlayLines.addAll(collection);
        }
    }

    public Collection<SpectralLine> getOverlayLines() {
        return Collections.unmodifiableCollection(this.overlayLines);
    }

    public SpectralSpecModel(SpectralSpec spectralSpec) {
        super(spectralSpec);
        this.usedByTargetModel = new UsedByTargetModel(null);
        this.restFrequencyModel = new ValueUnitPairModel();
        this.integrationTimeModel = new ValueUnitPairModel();
        this.subscanDurationModel = new ValueUnitPairModel();
        this.integrationDurationModel = new ValueUnitPairModel();
        this.channelAverageDurationModel = new ValueUnitPairModel();
        this.dumpDurationModel = new ValueUnitPairModel();
        this.phaseSwitchingConfigurationModel = new ACAPhaseSwitchingConfigurationModel(null);
        this.squareLawSetupModel = new SquareLawSetupModel(null);
        this.baseBandConfigTabbedModel = new BaseBandConfigTabbedModel(null);
        this.switchCycleModel = new SwitchingCycleModel(spectralSpec);
        this.registerSubModel(this.restFrequencyModel);
        this.registerSubModel(this.integrationTimeModel);
        this.registerSubModel(this.subscanDurationModel);
        this.registerSubModel(this.integrationDurationModel);
        this.registerSubModel(this.channelAverageDurationModel);
        this.registerSubModel(this.dumpDurationModel);
        this.registerSubModel(this.phaseSwitchingConfigurationModel);
        this.registerSubModel(this.squareLawSetupModel);
        this.registerSubModel(this.baseBandConfigTabbedModel);
        ModelChangeSubscriber modelChangeSubscriber = (model, fieldID, object) -> {
            SpectralSpec spectralSpec;
            Object object2 = this.getDocument();
            if (object2 != null && this.getDocument() instanceof SpectralSpec && (spectralSpec = (SpectralSpec)object2).getAbstractCorrelatorConfiguration() != null) {
                spectralSpec.getAbstractCorrelatorConfiguration().dataRateChanged();
            }
        };
        this.integrationDurationModel.subscribe(modelChangeSubscriber);
        this.channelAverageDurationModel.subscribe(modelChangeSubscriber);
        this.dataRateChangeListener = dataRateChangeEvent -> {
            if (dataRateChangeEvent.getSource() == this.getSpectralSpec()) {
                this.baseBandConfigTabbedModel.dataRateChanged();
            }
        };
        this.setDocument(spectralSpec);
    }

    public SpectralSpec getSpectralSpec() {
        try {
            return (SpectralSpec)this.getDocument();
        }
        catch (ClassCastException classCastException) {
            String string = "Unexpected document for " + this.getClass().getSimpleName() + " : " + this.document.getClass();
            Log.logger((Object)this).warning(string);
            return null;
        }
    }

    public BaseBandConfigModel getBaseBandConfigModel() {
        return this.getBaseBandConfigTabbedModel().getSubModel();
    }

    @Override
    public void publish() {
        if (this.isPublishingFirstBBFrequency) {
            this.getRestFrequencyModel().publish();
            SpectralSpec spectralSpec = this.getSpectralSpec();
            this.publish(SpectralSpecBaseEditor.RECEIVERBAND_FID, spectralSpec.getReceiverBandName());
            return;
        }
        SpectralSpec spectralSpec = this.getSpectralSpec();
        this.publish(SpectralSpecBaseEditor.documentFID, this.document);
        if (spectralSpec != null) {
            this.publish(SpectralSpecBaseEditor.SPECTRALSPECNAME_FID, spectralSpec.getName());
            this.getRestFrequencyModel().publish();
            this.publish(SpectralSpecBaseEditor.TRANSITIONNAME_FID, spectralSpec.getTransitionName());
            this.publish(SpectralSpecBaseEditor.RECEIVERBAND_FID, spectralSpec.getReceiverBandName());
            this.publish(SpectralSpecVisualEditor.spectralSelectOtherLinesFID, spectralSpec.getOverlayLines());
            this.getIntegrationTimeModel().publish();
            this.getSubscanDurationModel().publish();
            this.publish(SpectralSpecBaseEditor.RECEIVERTYPE_FID, spectralSpec.getReceiverType());
            if (spectralSpec != null) {
                this.publish(SpectralSpecBaseEditor.USESQUARELAW_FID, spectralSpec.hasSquareLawSetup());
            }
            this.squareLawSetupModel.publish();
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
            this.getIntegrationDurationModel().publish();
            this.getSubscanDurationModel().publish();
            this.getChannelAverageDurationModel().publish();
            this.getBaseBandConfigTabbedModel().publish();
            if (abstractCorrelatorConfiguration != null) {
                this.publish(SpectralSpecBaseEditor.APCDATASETS_FID, abstractCorrelatorConfiguration.getAPCDataSets());
                this.publish(SpectralSpecBaseEditor.CAM_FID, abstractCorrelatorConfiguration.getCAM());
                this.publish(SpectralSpecBaseEditor.LOOFFSETTING_FID, abstractCorrelatorConfiguration.getLOOffsettingMode());
                this.publish(SpectralSpecBaseEditor.WALSH180_FID, abstractCorrelatorConfiguration.getEnable180DegreeWalshFunction());
                this.publish(SpectralSpecBaseEditor.WALSH90_FID, abstractCorrelatorConfiguration.getEnable90DegreeWalshFunction());
                try {
                    this.getDumpDurationModel().publish();
                }
                catch (ClassCastException classCastException) {
                    try {
                        this.getPhaseSwitchingConfigurationModel().publish();
                    }
                    catch (ClassCastException classCastException2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        Object object2 = null;
        SpectralSpec spectralSpec = this.getSpectralSpec();
        if (fieldID == SpectralSpecBaseEditor.SPECTRALSPECNAME_FID) {
            String string = (String)object;
            spectralSpec.setName(string);
            object2 = string;
        } else if (fieldID.equals(SpectralSpecBaseEditor.USESQUARELAW_FID)) {
            Boolean bl = (Boolean)object;
            SpectralSpec spectralSpec2 = spectralSpec;
            if (spectralSpec2 != null) {
                if (bl.booleanValue()) {
                    SquareLawSetup squareLawSetup = spectralSpec2.getSquareLawSetup();
                    if (squareLawSetup.getIntegrationDuration().isZero()) {
                        squareLawSetup.setIntegrationDuration(Time.createTime((double)16.0, (String)Time.UNIT_MS));
                    }
                    this.getSquareLawSetupModel().setDocument((Object)squareLawSetup);
                } else {
                    spectralSpec2.setSquareLawSetup(null);
                }
                this.publish(SpectralSpecBaseEditor.documentFID, spectralSpec2);
                object2 = bl;
            }
        } else if (fieldID.equals(SpectralSpecBaseEditor.APCDATASETS_FID)) {
            String string = (String)object;
            spectralSpec.getCorrelatorConfiguration().setAPCDataSets(string);
            object2 = string;
        } else if (fieldID.equals(SpectralSpecBaseEditor.CAM_FID)) {
            String string = (String)object;
            spectralSpec.getCorrelatorConfiguration().setCAM(string);
            object2 = string;
            this.publishDataProducts();
        } else if (fieldID.equals(SpectralSpecBaseEditor.LOOFFSETTING_FID)) {
            String string = (String)object;
            spectralSpec.getCorrelatorConfiguration().setLOOffsettingMode(string);
            object2 = string;
        } else if (fieldID.equals(SpectralSpecBaseEditor.WALSH180_FID)) {
            Boolean bl = (Boolean)object;
            spectralSpec.getCorrelatorConfiguration().setEnable180DegreeWalshFunction(bl);
            object2 = bl;
        } else if (fieldID.equals(SpectralSpecBaseEditor.WALSH90_FID)) {
            Boolean bl = (Boolean)object;
            spectralSpec.getCorrelatorConfiguration().setEnable90DegreeWalshFunction(bl);
            object2 = bl;
        } else if (fieldID == SpectralSpecBaseEditor.RECEIVERBAND_FID) {
            String string = (String)object;
            spectralSpec.setReceiverBandName(string);
            object2 = string;
        } else if (fieldID == SpectralSpecBaseEditor.TRANSITIONNAME_FID) {
            String string = (String)object;
            spectralSpec.setTransitionName(string);
            object2 = string;
        } else if (fieldID.equals(SpectralSpecBaseEditor.ID_ADJUST_FID)) {
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
            if (abstractCorrelatorConfiguration == null) {
                return object;
            }
            CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(abstractCorrelatorConfiguration.getCorrelatorType());
            double d = abstractCorrelatorConfiguration.getIntegrationDuration().getContentInUnits(Time.UNIT_S);
            double d2 = abstractCorrelatorConfiguration.getChannelAverageDuration().getContentInUnits(Time.UNIT_S);
            double d3 = correlatorExpert.calcIntegrationDurationInsecs(d, d2);
            spectralSpec.getCorrelatorConfiguration().getIntegrationDuration().setContentAndUnit((ValueUnitPair)Time.createTimeSec(d3));
            this.getIntegrationDurationModel().publish();
        } else if (fieldID.equals(SpectralSpecBaseEditor.CAD_ADJUST_FID)) {
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
            if (abstractCorrelatorConfiguration == null) {
                return object;
            }
            CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(abstractCorrelatorConfiguration.getCorrelatorType());
            double d = abstractCorrelatorConfiguration.getChannelAverageDuration().getContentInUnits(Time.UNIT_S);
            double d4 = 0.001;
            try {
                BLCorrelatorConfiguration bLCorrelatorConfiguration = (BLCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
                d4 = bLCorrelatorConfiguration.getDumpDuration().getContentInUnits(Time.UNIT_S);
            }
            catch (ClassCastException classCastException) {
                d4 = AbstractCorrelatorConfiguration.CAM_FAST.equals(abstractCorrelatorConfiguration.getCAM()) ? 0.001 : 0.016;
            }
            double d5 = correlatorExpert.calcChannelAverageDurationInsecs(d, d4);
            spectralSpec.getCorrelatorConfiguration().getChannelAverageDuration().setContentAndUnit((ValueUnitPair)Time.createTimeSec(d5));
            this.getChannelAverageDurationModel().publish();
        } else if (fieldID.equals(SpectralSpecBaseEditor.DD_ADJUST_FID)) {
            try {
                BLCorrelatorConfiguration bLCorrelatorConfiguration = (BLCorrelatorConfiguration)((Object)spectralSpec.getCorrelatorConfiguration());
                CorrelatorExpert correlatorExpert = CorrelatorExpert.getBLInstance();
                double d = bLCorrelatorConfiguration.getDumpDuration().getContentInUnits(Time.UNIT_MS);
                double d6 = correlatorExpert.calcDumpDurationInmsecs(d);
                bLCorrelatorConfiguration.getDumpDuration().setContentAndUnit((ValueUnitPair)Time.createTime((double)d6, (String)Time.UNIT_MS));
                this.getDumpDurationModel().publish();
            }
            catch (Exception exception) {}
        } else if (SpectralSpecBaseEditor.LINE_CATALOG_FID.equals(fieldID)) {
            List list;
            if (object instanceof List && !(list = (List)object).isEmpty()) {
                SpectralSpec spectralSpec3 = spectralSpec;
                FrequencySetup frequencySetup = spectralSpec3.getFrequencySetup();
                Frequency frequency = frequencySetup.getRestFrequency();
                SpectralLine spectralLine = (SpectralLine)list.get(0);
                Frequency frequency2 = spectralLine.getFrequency();
                frequency.setUnit(Frequency.UNIT_GHZ);
                frequency.setContent(frequency2.getContentInGHz());
                frequencySetup.setTransitionName(spectralLine.getTitle());
                this.publish();
            }
        } else if (SpectralSpecVisualEditor.spectralSelectOtherLinesFID.equals(fieldID) && object instanceof List) {
            SpectralSpec spectralSpec4 = spectralSpec;
            if (spectralSpec4 != null) {
                List list = (List)object;
                spectralSpec4.setOverlayLines(list);
            }
            object2 = object;
        } else {
            object2 = this.restFrequencyModel.update(editor, fieldID, object);
        }
        return object2;
    }

    @Override
    public void setDocument(Object object) {
        try {
            this.context = (SpectralSpecDocument)object;
            this.document = object == null ? null : this.context.getSpectralSpec();
        }
        catch (ClassCastException classCastException) {
            this.context = null;
            this.document = null;
        }
        this.publish();
        this.publish(SpectralSpecBaseEditor.documentFID, this.document);
        SpectralSpec spectralSpec = this.getSpectralSpec();
        if (this.document == null) {
            return;
        }
        this.getUsedByTargetModel().setDocument((AttachableToTarget)((Object)spectralSpec), this.isTargetContext());
        if (spectralSpec != null) {
            Frequency frequency = spectralSpec.getRestFrequency();
            this.getRestFrequencyModel().setDocument((Object)frequency);
            this.getBaseBandConfigTabbedModel().setDocument(spectralSpec);
            spectralSpec.setSourceVelocity(this.getSourceVelocity());
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
            if (abstractCorrelatorConfiguration != null) {
                ACASpectrometerCorrelatorConfiguration aCASpectrometerCorrelatorConfiguration;
                ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration;
                this.getIntegrationDurationModel().setDocument(abstractCorrelatorConfiguration.getIntegrationDuration());
                this.getChannelAverageDurationModel().setDocument(abstractCorrelatorConfiguration.getChannelAverageDuration());
                if (abstractCorrelatorConfiguration instanceof BLCorrelatorConfiguration) {
                    BLCorrelatorConfiguration bLCorrelatorConfiguration = (BLCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
                    this.getDumpDurationModel().setDocument(bLCorrelatorConfiguration.getDumpDuration());
                } else if (abstractCorrelatorConfiguration instanceof ACACorrelatorConfiguration) {
                    ACACorrelatorConfiguration aCACorrelatorConfiguration = (ACACorrelatorConfiguration)((Object)abstractCorrelatorConfiguration);
                    ACAPhaseSwitchingConfiguration aCAPhaseSwitchingConfiguration2 = aCACorrelatorConfiguration.getACAPhaseSwitchingConfiguration();
                    if (aCAPhaseSwitchingConfiguration2 != null) {
                        this.getPhaseSwitchingConfigurationModel().setDocument((Object)aCAPhaseSwitchingConfiguration2);
                    }
                } else if (abstractCorrelatorConfiguration instanceof ACASpectrometerCorrelatorConfiguration && (aCAPhaseSwitchingConfiguration = (aCASpectrometerCorrelatorConfiguration = (ACASpectrometerCorrelatorConfiguration)((Object)abstractCorrelatorConfiguration)).getACAPhaseSwitchingConfiguration()) != null) {
                    this.getPhaseSwitchingConfigurationModel().setDocument((Object)aCAPhaseSwitchingConfiguration);
                }
                abstractCorrelatorConfiguration.activateDataRateCalculator();
                abstractCorrelatorConfiguration.getDataRateCalculator().updateDataRateForConfig(abstractCorrelatorConfiguration);
            } else {
                this.getIntegrationDurationModel().setDocument(null);
                this.getChannelAverageDurationModel().setDocument(null);
                this.getPhaseSwitchingConfigurationModel().setDocument(null);
            }
            this.getSquareLawSetupModel().setDocument((Object)spectralSpec.gettrueSquareLawSetup());
            this.setupDefaulters();
            spectralSpec.addDataRateChangeListener(this.dataRateChangeListener);
            this.getSwitchCycleModel().setDocument(spectralSpec);
        } else {
            this.getRestFrequencyModel().setDocument(null);
            this.getIntegrationTimeModel().setDocument(null);
            this.getIntegrationDurationModel().setDocument(null);
            this.getSubscanDurationModel().setDocument(null);
            this.getChannelAverageDurationModel().setDocument(null);
            this.getPhaseSwitchingConfigurationModel().setDocument(null);
            this.getSquareLawSetupModel().setDocument(null);
            this.getSwitchCycleModel().setDocument(null);
        }
    }

    private void setupDefaulters() {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        if (this.freqSetupDefaulter != null) {
            this.freqSetupDefaulter.deactivate();
        }
        try {
            this.freqSetupDefaulter = new DefFrequencySetup(spectralSpec, this);
        }
        catch (CircularDependencyException circularDependencyException) {
            circularDependencyException.printStackTrace();
            GUIUtilities.error(null, "Failure setting up model defaults.", circularDependencyException);
        }
        if (this.receiverTypeDefaulter != null) {
            this.receiverTypeDefaulter.deactivate();
        }
        try {
            this.receiverTypeDefaulter = new DefReceiverType(spectralSpec, this);
        }
        catch (CircularDependencyException circularDependencyException) {
            circularDependencyException.printStackTrace();
            GUIUtilities.error(null, "Failure setting up model defaults.", circularDependencyException);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        for (int i = 0; i < spectralSpec.getBaseBandCount(); ++i) {
            this.setupDefaulters(spectralSpec.getBaseBandSpecification(i));
        }
    }

    private void setupDefaulters(BaseBandSpecification baseBandSpecification) {
    }

    private void publishDataProducts() {
        BaseBandConfigModel baseBandConfigModel = this.baseBandConfigTabbedModel.getSubModel();
        AbstractBaseBandConfig abstractBaseBandConfig = baseBandConfigModel.getBaseBandConfig();
        if (abstractBaseBandConfig != null) {
            baseBandConfigModel.publish(BaseBandConfigEditor.PRODUCTS_FID, abstractBaseBandConfig.getDataProducts());
        }
    }

    public boolean isTargetContext() {
        return this.context instanceof Target;
    }

    public FieldSource getVelocitySource() {
        Target target = null;
        if (this.getContext() != null) {
            SchedBlock schedBlock;
            SpectralSpec spectralSpec = this.getSpectralSpec();
            Target[] targetArray = spectralSpec.getTargetList();
            List<Target> list = null;
            try {
                list = spectralSpec.getObservingGroupDopplerTargetsForSpectralSpec();
                if (list.size() > 0) {
                    return list.get(0).getFieldSource();
                }
            }
            catch (SpectralSpec.NoAbstractScienceGoalFoundAsParentException | SpectralSpec.SpectralSpecAncestorIsAnObservatoryGoalException exception) {
                Log.logger(SpectralSpecModel.class).fine("Unable to determine the main target for spectral spec: " + spectralSpec.getName());
            }
            assert (list == null || list.size() == 0);
            if (targetArray != null && targetArray.length > 0) {
                for (int i = 0; i < targetArray.length; ++i) {
                    if (!targetArray[i].hasScienceParameters()) continue;
                    target = targetArray[i];
                    break;
                }
            }
            if (target == null && (schedBlock = spectralSpec.getSchedBlock()) != null) {
                target = schedBlock.getSchedulingConstraints().getRepresentativeTarget();
            }
        }
        return target == null ? null : target.getFieldSource();
    }

    public Velocity getSourceVelocity() {
        FieldSource fieldSource = this.getVelocitySource();
        if (fieldSource == null) {
            return Velocity.createVelocity();
        }
        return fieldSource.getSourceVelocityInReferenceFrame();
    }

    public UsedByTargetModel getUsedByTargetModel() {
        return this.usedByTargetModel;
    }

    public ValueUnitPairModel getRestFrequencyModel() {
        return this.restFrequencyModel;
    }

    public ValueUnitPairModel getIntegrationTimeModel() {
        return this.integrationTimeModel;
    }

    public ValueUnitPairModel getSubscanDurationModel() {
        return this.subscanDurationModel;
    }

    public ValueUnitPairModel getIntegrationDurationModel() {
        return this.integrationDurationModel;
    }

    public ValueUnitPairModel getChannelAverageDurationModel() {
        return this.channelAverageDurationModel;
    }

    public ValueUnitPairModel getDumpDurationModel() {
        return this.dumpDurationModel;
    }

    public SwitchingCycleModel getSwitchCycleModel() {
        return this.switchCycleModel;
    }

    public ACAPhaseSwitchingConfigurationModel getPhaseSwitchingConfigurationModel() {
        return this.phaseSwitchingConfigurationModel;
    }

    public SquareLawSetupModel getSquareLawSetupModel() {
        return this.squareLawSetupModel;
    }

    public BaseBandConfigTabbedModel getBaseBandConfigTabbedModel() {
        return this.baseBandConfigTabbedModel;
    }

    public SpectralSpecDocument getContext() {
        return this.context;
    }
}

