/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.valuetypes;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.obsprep.bo.SingleContinuumObservingFrequency;
import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.valuetypes.ObservingFrequencyEditor;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.obsprep.ot.models.sciencegoals.BLCorrelatorModes;
import alma.obsprep.ot.models.sciencegoals.SpectralSetupParametersModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.valuetypes.Frequency;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import lombok.NonNull;

public class ObservingFrequencyModel
extends Model {
    public static final FieldID FREQUENCY_TYPE_FID = new FieldID("FrequencyModel.FrequencyType");
    public static final FieldID EDITOR_LABEL_FID = new FieldID("FrequencyModel.EditorLabel");
    public static final FieldID REST_FREQ_FEEDBACK_LABEL_FID = new FieldID("FrequencyModel.FeedbackLabel");
    public static final FieldID REST_FREQ_FEEDBACK_AREA_FID = new FieldID("FrequencyModel.FeedbackArea");
    public static final FieldID BAND_SELECTED_FID = new FieldID("FrequencyModel.bandSelected");
    public static final FieldID RESET_TO_STANDARD_FREQ_FID = new FieldID("FrequencyModel.resetToStandardFrequency");
    public static final FieldID CORRELATOR_MODE = new FieldID("FrequencyModel.correlatorMode");
    public static final FieldID RESOLUTION_MODE_SELECTABLE = new FieldID("FrequencyModel.resolutionModeSelectable");
    private final ValueUnitPairModel frequencyModel = new ValueUnitPairModel();
    private boolean isUpdateCentralFrequencyWhenBandChanges = true;
    private final ModelChangeSubscriber centralFreqSubscriber = (model, fieldID, object) -> this.publish();
    private Integer receiverBandNumber;

    public ObservingFrequencyModel(Object object2) {
        super(object2);
        this.frequencyModel.subscribe(this.centralFreqSubscriber);
        this.registerSubModel(this.frequencyModel);
    }

    public ObservingFrequency getObservingFrequency() {
        return (ObservingFrequency)this.getDocument();
    }

    @Override
    public void publish() {
        if (this.document != null) {
            ObservingFrequency observingFrequency = this.getObservingFrequency();
            this.publish(FREQUENCY_TYPE_FID, observingFrequency.getFrequencyType().toString());
            this.publishFeedbackFrequency();
            try {
                this.receiverBandNumber = ReceiverBand.getReceiverBand(observingFrequency.getSkyFrequency()).getNumber();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            this.setUpdateCentralFrequencyWhenBandChanges(false);
            this.publish(BAND_SELECTED_FID, this.receiverBandNumber);
            this.setUpdateCentralFrequencyWhenBandChanges(true);
            this.publish(CORRELATOR_MODE, BLCorrelatorModes.valueOfBOMapping(this.getSpectralSetupParameters().getSingleContinuumCorrelatorMode()).getUILabel());
        }
    }

    private Frequency getFeedbackFrequency() {
        ObservingFrequency observingFrequency = this.getObservingFrequency();
        return observingFrequency.getFrequencyType() == ObservingFrequency.FrequencyType.SKY_FREQUENCY ? observingFrequency.getRestFrequency() : observingFrequency.getSkyFrequency();
    }

    private void publishFeedbackFrequency() {
        this.publish(REST_FREQ_FEEDBACK_AREA_FID, (Object)this.getFeedbackFrequency());
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID == FREQUENCY_TYPE_FID) {
            String string = (String)object;
            this.getObservingFrequency().setFrequencyType(ObservingFrequency.FrequencyType.getFrequencyType(string));
            this.publishFeedbackFrequency();
            return string;
        }
        if (fieldID == BAND_SELECTED_FID) {
            if (this.isUpdateCentralFrequencyWhenBandChanges()) {
                try {
                    this.receiverBandNumber = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                this.setStandardFrequency(ReceiverBand.getReceiverBand(this.receiverBandNumber));
            }
            this.publishSingleContinuumResolutionEnabled(Optional.of(Boolean.TRUE));
        }
        if (fieldID == RESET_TO_STANDARD_FREQ_FID) {
            if (this.receiverBandNumber == null) {
                return null;
            }
            this.setStandardFrequency(ReceiverBand.getReceiverBand(this.receiverBandNumber));
            this.publishSingleContinuumResolutionEnabled(Optional.of(Boolean.TRUE));
        }
        if (fieldID == ObservingFrequencyEditor.INPUT_FREQUENCY_VUP) {
            this.publish();
        }
        if (fieldID == CORRELATOR_MODE) {
            String string = (String)object;
            SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
            spectralSetupParameters.setSingleContinuumCorrelatorMode(string);
            if (string.equals(BLCorrelatorModes.TDM.getBOMapping())) {
                Stream.of(spectralSetupParameters.getAbstractScienceSpectralWindow()).forEach(abstractScienceSpectralWindow -> abstractScienceSpectralWindow.getAdvancedWindowSetup().setSmoothingFactor(1));
            } else if (string.equals(BLCorrelatorModes.FDM.getBOMapping())) {
                Stream.of(spectralSetupParameters.getAbstractScienceSpectralWindow()).forEach(abstractScienceSpectralWindow -> abstractScienceSpectralWindow.getAdvancedWindowSetup().setSmoothingFactor(2));
            }
        }
        return object;
    }

    private SpectralSetupParameters getSpectralSetupParameters() {
        SingleContinuumObservingFrequency singleContinuumObservingFrequency = (SingleContinuumObservingFrequency)this.document;
        return singleContinuumObservingFrequency.getSpectralSetupParameters();
    }

    private void setStandardFrequency(ReceiverBand receiverBand) {
        Iterable<SummaryTableRow> iterable;
        if (!(this.getDocument() instanceof SingleContinuumObservingFrequency)) {
            return;
        }
        SpectralSetupParameters spectralSetupParameters = ((SingleContinuumObservingFrequency)this.getDocument()).getSpectralSetupParameters();
        if (!spectralSetupParameters.isSingleContinuum()) {
            return;
        }
        CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization(spectralSetupParameters.getPolarisation());
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (spectralSetupParameters.getObservatoryGoal() == null) {
                iterable = spectralSetupParameters.getScienceGoal();
                if (iterable == null) {
                    return;
                }
                bl = ((ScienceGoal)iterable).getObsProposal().isVLBIorPhasedArray() || ((ScienceGoal)iterable).getObsProposal().isPhasedArray();
                bl2 = ((ScienceGoal)iterable).isSolarScienceGoal();
            }
        }
        catch (UnknownEntityException | NullPointerException throwable) {
            Log.logger(ObservingFrequencyModel.class).warning("Unable to determine if the project is a VLBI or Solar project");
            return;
        }
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        if (bl) {
            boolean bl3 = false;
            try {
                bl3 = ObsProposal.isProposalPhasedArray();
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(ObservingFrequencyEditor.class).warning("Unable to determine if we are in VLBI pulsar mode " + unknownEntityException.getMessage());
            }
            iterable = bl3 ? almaCapabilities.getVLBIPhaserFrequencies() : almaCapabilities.getVLBIFrequencies();
        } else {
            iterable = bl2 ? almaCapabilities.getSolarBands().stream().map(solarBand -> OTConfigurationHelper.getFrequency(solarBand.getStandardFrequency())).toList() : (corrPolarization.equals((Object)CorrPolarization.FULL) ? almaCapabilities.getPolarizationFrequencies() : almaCapabilities.getContinuumFrequencies());
        }
        Frequency frequency = null;
        for (Frequency frequency2 : iterable) {
            if (!ReceiverBand.getReceiverBand(frequency2).equals(receiverBand)) continue;
            frequency = frequency2;
            break;
        }
        if (frequency == null) {
            return;
        }
        this.frequencyModel.update(null, this.frequencyModel.getValueFID(), frequency.getContentInUnits(this.frequencyModel.getVUP().getUnit()));
        this.frequencyModel.publish();
        this.publishSingleContinuumResolutionEnabled(Optional.of(Boolean.TRUE));
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        boolean bl = this.getObservingFrequency().getInputFrequency().isZero();
        if (object instanceof SingleContinuumObservingFrequency) {
            SingleContinuumObservingFrequency singleContinuumObservingFrequency = (SingleContinuumObservingFrequency)object;
            SpectralSetupParameters spectralSetupParameters = singleContinuumObservingFrequency.getSpectralSetupParameters();
            if (spectralSetupParameters.isSingleContinuum() && this.getObservingFrequency().getFrequencyType().equals((Object)ObservingFrequency.FrequencyType.REST_FREQUENCY)) {
                Frequency frequency = this.getObservingFrequency().getSkyFrequency();
                this.getObservingFrequency().setInputFrequency(frequency);
                this.getObservingFrequency().setFrequencyType(ObservingFrequency.FrequencyType.SKY_FREQUENCY);
            }
            this.publishSingleContinuumResolutionEnabled(Optional.empty());
        }
        this.frequencyModel.setDocument((Object)this.getObservingFrequency().getInputFrequency());
        if (bl) {
            this.publish(BAND_SELECTED_FID, 3);
            SwingUtilities.invokeLater(() -> this.setStandardFrequency(ReceiverBand.getReceiverBand(3)));
        }
        this.publish();
    }

    private void publishSingleContinuumResolutionEnabled(@NonNull Optional<Boolean> optional) {
        boolean bl;
        if (optional == null) {
            throw new NullPointerException("isSingleContinuumSetupValid is marked non-null but is null");
        }
        Object object = this.getDocument();
        if (!(object instanceof SingleContinuumObservingFrequency)) {
            return;
        }
        SingleContinuumObservingFrequency singleContinuumObservingFrequency = (SingleContinuumObservingFrequency)object;
        SpectralSetupParameters spectralSetupParameters = singleContinuumObservingFrequency.getSpectralSetupParameters();
        ScienceGoal scienceGoal = spectralSetupParameters.getScienceGoal();
        try {
            bl = !scienceGoal.isSolarScienceGoal() && !ObsProposal.isVLBIRelated() && optional.orElseGet(() -> spectralSetupParameters.getAbstractScienceSpectralWindowCount() == 4) != false;
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ObservingFrequencyModel.class).warning("Unable to determine if we are solar/VLBI : " + unknownEntityException.getMessage());
            bl = true;
        }
        this.publish(RESOLUTION_MODE_SELECTABLE, bl);
    }

    public CorrPolarization getPolarization() {
        SpectralSetupParametersModel spectralSetupParametersModel = (SpectralSetupParametersModel)this.getParentModel();
        return spectralSetupParametersModel.getPolarization();
    }

    public boolean isContinuumSkyFrequencyMutable() {
        boolean bl;
        boolean bl2;
        block5: {
            bl2 = false;
            bl = false;
            try {
                bl = ObsProposal.isVLBIRelated();
                SpectralSetupParametersModel spectralSetupParametersModel = (SpectralSetupParametersModel)this.getParentModel();
                if (spectralSetupParametersModel != null) {
                    SingleFieldScienceGoalModel singleFieldScienceGoalModel = (SingleFieldScienceGoalModel)spectralSetupParametersModel.getParentModel();
                    if (singleFieldScienceGoalModel != null) {
                        Object object = singleFieldScienceGoalModel.getDocument();
                        if (object instanceof ScienceGoal) {
                            ScienceGoal scienceGoal = (ScienceGoal)object;
                            bl2 = scienceGoal.isSolarScienceGoal();
                        }
                        break block5;
                    }
                    return false;
                }
                return false;
            }
            catch (UnknownEntityException unknownEntityException) {
                return false;
            }
        }
        return bl2 || bl;
    }

    public ValueUnitPairModel getFrequencyModel() {
        return this.frequencyModel;
    }

    public void setUpdateCentralFrequencyWhenBandChanges(boolean bl) {
        this.isUpdateCentralFrequencyWhenBandChanges = bl;
    }

    public boolean isUpdateCentralFrequencyWhenBandChanges() {
        return this.isUpdateCentralFrequencyWhenBandChanges;
    }
}

