/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;

public class TPSpectralScanSourceSplitter
extends SourceClusterDetector {
    private static CacheAccess<Integer, Collection<ScienceGoal>> tpScienceGoalClusterCache = JCS.getInstance((String)"TPSourceClusterCache");

    public TPSpectralScanSourceSplitter(@NonNull ScienceGoal scienceGoal) {
        super(scienceGoal);
        if (scienceGoal == null) {
            throw new NullPointerException("primaryScienceGoal is marked non-null but is null");
        }
    }

    @Override
    public Collection<ScienceGoal> splitScienceGoalIntoSourceClusters() throws InvalidObsProgramParametersException {
        int n = this.originalScienceGoal.toXml().hashCode();
        Collection collection = (Collection)tpScienceGoalClusterCache.get((Object)n);
        if (collection != null) {
            return collection;
        }
        List<Set<TargetParameters>> list = Arrays.stream(this.originalScienceGoal.getTargetParameters()).map(Set::of).toList();
        List<ScienceGoal> list2 = this.groupSpatiallyAdjacentSourcesIntoScienceGoals(list);
        list2.stream().forEach(ScienceGoal::determineACAScheduling);
        tpScienceGoalClusterCache.put((Object)n, list2);
        return list2;
    }
}

