/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.configuration.OTXMLConfigurationReader;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.util.LogLoggerProviderImpl;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.UnitMapConfigurator;
import alma.valuetypes.Angle;
import alma.valuetypes.UserAngle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBException;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.lang3.StringUtils;

public final class Shadowing {
    private static Shadowing instance = null;
    private static Map<String, ShadowingConfiguration> shadowingDataMap = new ConcurrentHashMap<String, ShadowingConfiguration>();
    private static CacheAccess<String, ShadowingData> shadowingCache = JCS.getInstance((String)"shadowingCache");

    private Shadowing() {
    }

    private static void refreshConfiguration() {
        try {
            shadowingDataMap.clear();
            Shadowing.loadShadowingData();
            Shadowing.loadShadowingDataFiles();
        }
        catch (OTXMLConfigurationReader.InvalidOTCOnfigurationException | InvalidConfigurationParametersException | UnableToReadShadowingFileException | JAXBException throwable) {
            throw new RuntimeException("Failed to refresh configuration", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Shadowing getInstance() {
        if (instance != null) return instance;
        Class<Shadowing> clazz = Shadowing.class;
        synchronized (Shadowing.class) {
            if (instance != null) return instance;
            instance = new Shadowing();
            Shadowing.refreshConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void sortConfigurationDeclinationMaps() {
        if (shadowingDataMap.keySet().isEmpty()) {
            throw new NoDataFound("No shadowing data is in the maps");
        }
        ShadowingConfiguration shadowingConfiguration = null;
        for (String string : shadowingDataMap.keySet()) {
            shadowingConfiguration = shadowingDataMap.get(string);
            shadowingConfiguration.sortShadowingDetails();
        }
    }

    private static void loadShadowingDataFiles() throws UnableToReadShadowingFileException {
        Set<String> set = shadowingDataMap.keySet();
        for (String string : set) {
            Object object;
            Object object2;
            String string2 = System.getProperty("Telescope", "ESALMA");
            String string3 = string2 + "Shadowing-" + string + ".dat";
            URL uRL = null;
            try {
                object2 = new File(System.getProperty("otData.dir", "\\config\\otData"));
                assert (object2 != null);
                uRL = MiscUtils.findResource((File)object2, string3);
                Log.logger(Shadowing.class).finest("Reading shadowing file : " + string3);
            }
            catch (Exception exception) {
                object = "Error accessing " + string3 + " file: " + exception.getMessage();
                Log.logger(Shadowing.class).warning((String)object);
                exception.printStackTrace(System.err);
                throw new UnableToReadShadowingFileException((String)object);
            }
            assert (uRL != null);
            object2 = null;
            try {
                object2 = new BufferedReader(new InputStreamReader(uRL.openStream()));
            }
            catch (IOException iOException) {
                String string4 = "Unable to open shadowing file : " + string3 + ": " + iOException.getMessage();
                Log.logger(Shadowing.class).warning(string4);
                throw new UnableToReadShadowingFileException(string4);
            }
            assert (object2 != null);
            int n = 0;
            assert (shadowingDataMap != null);
            if (!shadowingDataMap.containsKey(string)) {
                shadowingDataMap.put(string, new ShadowingConfiguration(string));
            }
            ShadowingConfiguration shadowingConfiguration = shadowingDataMap.get(string);
            assert (shadowingConfiguration != null);
            try {
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    Object object3;
                    ++n;
                    if ((object = StringUtils.stripToNull((String)object)) == null || StringUtils.startsWith((CharSequence)object, (CharSequence)"#")) continue;
                    String[] stringArray = ((String)object).replaceAll("\\s+", " ").split(" ");
                    if (stringArray.length != 2) {
                        object3 = String.format("Line %d is expected to have two fields, %d found.", n, stringArray.length);
                        ((BufferedReader)object2).close();
                        Log.logger(Shadowing.class).warning((String)object3);
                        throw new UnableToReadShadowingFileException((String)object3);
                    }
                    object3 = null;
                    Double d = null;
                    try {
                        object3 = Double.valueOf(stringArray[0]);
                        d = Double.valueOf(stringArray[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ((BufferedReader)object2).close();
                        String string5 = String.format("Unable to process line %d and convert to real numbers : %s", n, object);
                        Log.logger(Shadowing.class).warning(string5);
                        throw new UnableToReadShadowingFileException(string5);
                    }
                    assert (object3 != null && d != null);
                    shadowingConfiguration.add(new ShadowingData((Double)object3, d));
                }
                ((BufferedReader)object2).close();
            }
            catch (IOException iOException) {
                Log.logger(Shadowing.class).warning("Unable to close file " + string3 + ": " + iOException.getMessage());
                throw new UnableToReadShadowingFileException("Unable to close file : " + string3);
            }
        }
        Shadowing.sortConfigurationDeclinationMaps();
    }

    private static ShadowingConfiguration getConfiguration(String string) throws UnableToDetermineConfigurationException {
        if (string == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: configName");
        }
        return shadowingDataMap.get(string);
    }

    private static void loadShadowingData() throws InvalidConfigurationParametersException, JAXBException, OTXMLConfigurationReader.InvalidOTCOnfigurationException {
        List<String> list = OTXMLConfigurationReader.getInstance().getOTConfiguration().getShadowing().getConfiguration();
        if (list.isEmpty()) {
            Log.logger(Shadowing.class).warning("No shadowing configurations have been detected in the configuration");
        }
        list.stream().forEach(string -> Shadowing.addConfiguration(new ShadowingConfiguration((String)string)));
    }

    private static void addConfiguration(ShadowingConfiguration shadowingConfiguration) {
        shadowingDataMap.put(shadowingConfiguration.getName(), shadowingConfiguration);
    }

    private static ShadowingData getShadowingDataForDeclination(String string, Angle angle) throws InvalidConfigurationParametersException, UnableToDetermineConfigurationException {
        Shadowing.getInstance();
        if (string == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: configuration");
        }
        if (angle == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: declination");
        }
        if (!shadowingDataMap.containsKey(string)) {
            throw new NoDataFound("shadowingDataMap does not contain data for configuration : " + string);
        }
        ShadowingData shadowingData = null;
        double d = Double.POSITIVE_INFINITY;
        double d2 = angle.getContentInUnits(Angle.UNIT_DEG);
        String string2 = Double.toString((double)string.hashCode() + d2);
        ShadowingData shadowingData2 = (ShadowingData)shadowingCache.get((Object)string2);
        if (shadowingData2 != null) {
            return shadowingData2;
        }
        boolean bl = false;
        for (ShadowingData shadowingData3 : Shadowing.getConfiguration((String)string).shadowingDetails) {
            double d3 = shadowingData3.getDec().getContentInUnits(Angle.UNIT_DEG);
            double d4 = Math.abs(d3 - d2);
            if (shadowingData == null) {
                shadowingData = shadowingData3;
                d = d4;
                continue;
            }
            if (d4 < d) {
                shadowingData = shadowingData3;
                d = d4;
                bl = false;
                continue;
            }
            if (bl) break;
            bl = true;
        }
        assert (shadowingData != null);
        if (Log.logger(Shadowing.class).fine()) {
            Log.logger(Shadowing.class).fine(String.format("Optimum declination for candidate declination %.4g degs for %s is %.4g with shadowing=%.4g", angle.getContentInUnits(Angle.UNIT_DEG), string, shadowingData.getDec().getContentInUnits(Angle.UNIT_DEG), shadowingData.getShadowingPercentage()));
        }
        assert (shadowingData != null);
        shadowingCache.put((Object)string2, shadowingData);
        return shadowingData;
    }

    public static double getShadowingPercentageForDeclination(String string, Angle angle) {
        double d = 0.0;
        try {
            ShadowingData shadowingData = Shadowing.getShadowingDataForDeclination(string, angle);
            if (shadowingData != null) {
                d = shadowingData.getShadowingPercentage();
            }
        }
        catch (InvalidConfigurationParametersException | UnableToDetermineConfigurationException | IllegalArgumentException exception) {
            d = 0.0;
        }
        return d;
    }

    private static void miniAssert(double d, double d2, String string) {
        if (d == d2) {
            Log.logger(Shadowing.class).info("TEST OK: " + string + "  was " + d);
        } else {
            Log.logger(Shadowing.class).warning("TEST FAIL:  " + string + "  was  expected to be " + d + " and was " + d2);
        }
    }

    public static void main(String[] stringArray) {
        Log.setRuntimeImplementation((Log.LoggerProvider)new LogLoggerProviderImpl());
        UnitMapConfigurator.configureUnitMaps();
        Shadowing.miniAssert(Shadowing.getShadowingPercentageForDeclination("ACA", Angle.createAngle((double)-67.0, (String)Angle.UNIT_DEG)), 2.85, "Shadowing Pct for ACA at -67 degrees");
        Shadowing.miniAssert(Shadowing.getShadowingPercentageForDeclination("C40-8", Angle.createAngle((double)-67.0, (String)Angle.UNIT_DEG)), 0.0, "Shadowing Pct for C40-8 (a non shadowed array) at -67 degrees");
    }

    static {
        shadowingDataMap = new LinkedHashMap<String, ShadowingConfiguration>();
    }

    public static class UnableToReadShadowingFileException
    extends Exception {
        private static final long serialVersionUID = -6829886701997275722L;

        public UnableToReadShadowingFileException(String string) {
            super(string);
        }
    }

    public static class NoDataFound
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1017843542609156175L;

        public NoDataFound(String string) {
            super(string);
        }
    }

    private static final class ShadowingConfiguration {
        private ArrayList<ShadowingData> shadowingDetails;
        private String configurationName;

        private ShadowingConfiguration(String string) {
            this.configurationName = string;
            this.shadowingDetails = new ArrayList();
        }

        private void sortShadowingDetails() {
            ShadowingDataComparator shadowingDataComparator = new ShadowingDataComparator();
            Collections.sort(this.shadowingDetails, shadowingDataComparator);
        }

        private void add(ShadowingData shadowingData) {
            Log.logger(Shadowing.class).finest("Adding shadowing details : " + shadowingData.toString());
            this.shadowingDetails.add(shadowingData);
        }

        private String getName() {
            return this.configurationName;
        }

        public static class ShadowingDataComparator<T>
        implements Comparator<ShadowingData> {
            @Override
            public int compare(ShadowingData shadowingData, ShadowingData shadowingData2) {
                return shadowingData.getDec().compareTo((AbstractDoubleWithUnit)shadowingData2.getDec());
            }
        }
    }

    private static final class ShadowingData
    implements Comparable<ShadowingData> {
        private Angle dec = null;
        private Double shadowingPercentage = null;

        public String toString() {
            return "ShadowingData [dec=" + this.dec + ", shadowingPct=" + this.shadowingPercentage + "]";
        }

        private ShadowingData(double d, double d2) {
            this.dec = UserAngle.createUserAngle(d, Angle.UNIT_DEG);
            this.shadowingPercentage = d2;
        }

        private Angle getDec() {
            return this.dec;
        }

        private double getShadowingPercentage() {
            return this.shadowingPercentage;
        }

        @Override
        public int compareTo(ShadowingData shadowingData) {
            if (this.getDec().isGreaterThan((AbstractDoubleWithUnit)shadowingData.getDec())) {
                return 1;
            }
            if (this.getDec().isLessThan((AbstractDoubleWithUnit)shadowingData.getDec())) {
                return -1;
            }
            return 0;
        }
    }

    public static class UnableToDetermineConfigurationException
    extends Exception {
        private static final long serialVersionUID = 1375772038754743074L;

        public UnableToDetermineConfigurationException(String string) {
            super(string);
        }
    }
}

