/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.RepresentativeFlagExpertInterface;
import java.util.ArrayList;
import java.util.stream.Stream;
import lombok.NonNull;

public class ContinuumAndLineRepresentativeSPWFlagExpert
implements RepresentativeFlagExpertInterface {
    @Override
    public void setSPWRepresentativeFlag(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        ArrayList arrayList = new ArrayList();
        schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter).forEach(target -> {
            SpectralSpec spectralSpec = target.getSpectralSpec();
            if (!target.isRepresentativeTarget() && !arrayList.contains(spectralSpec)) {
                Stream<BaseBand> stream = Stream.of(spectralSpec.getBaseBand());
                stream.flatMap(baseBand -> Stream.of(baseBand.getSingleSpectralWindow())).forEach(abstractSpectralWindow -> abstractSpectralWindow.setRepresentativeWindow(false));
            } else {
                arrayList.add(spectralSpec);
            }
        });
    }
}

