/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.obsproject.NonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.BLSpectralWindow;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.DGCExpertInterface;
import alma.obsprep.services.generator.refactored.DGCOnlineCalibratorExpert;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserFrequency;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;

public abstract class DGCExpert
implements DGCExpertInterface {
    final Collection<ReceiverBand> dgcLegalBands = AlmaCapabilities.getInstance().getDGCB2BReceiverBands();
    public static final Set<DGCTypeEnum> allDGCStrategies = EnumSet.of(DGCTypeEnum.DGCBandToBand, DGCTypeEnum.DGCBandwidthSwitching);

    protected abstract B2BSchedulingOutcome isB2BRequirementsMet(@NonNull ScienceGoal var1);

    protected abstract BWSWSchedulingOutcome isBWSWRequirementsMet(@NonNull ScienceGoal var1);

    public static DGCExpertInterface getExpert(boolean bl) {
        return new DGCOnlineCalibratorExpert(bl);
    }

    @Override
    public Set<DGCTypeEnum> dgcObservingStrategiesRequired(ScienceGoal scienceGoal, boolean bl) {
        EnumSet<DGCTypeEnum> enumSet = EnumSet.of(DGCTypeEnum.None);
        if (scienceGoal == null || bl && scienceGoal.getCalibrationSetupParameters().getIsDGCOverride()) {
            return enumSet;
        }
        EnumSet<DGCTypeEnum> enumSet2 = EnumSet.noneOf(DGCTypeEnum.class);
        if (this.isBWSWRequirementsMet(scienceGoal).isBWSWToBeScheduled()) {
            enumSet2.add(DGCTypeEnum.DGCBandwidthSwitching);
        }
        if (this.isB2BRequirementsMet(scienceGoal).isB2BToBeScheduled()) {
            enumSet2.add(DGCTypeEnum.DGCBandToBand);
        }
        return enumSet2.isEmpty() ? enumSet : enumSet2;
    }

    protected void createTDMSpectralSetup(@NonNull SpectralSpec spectralSpec, @NonNull SpectralSetupParameters spectralSetupParameters) {
        if (spectralSpec == null) {
            throw new NullPointerException("tdmPhaseSpectralSpec is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("tdmSSP is marked non-null but is null");
        }
        Frequency frequency = spectralSetupParameters.getRepresentativeFrequency().deepCopy();
        int n = 0;
        spectralSetupParameters.setSpectralType(SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM);
        spectralSetupParameters.clearAbstractScienceSpectralWindow();
        for (AbstractBaseBandConfig abstractBaseBandConfig : spectralSpec.getBaseBandConfig()) {
            int n2 = 0;
            for (SpectralWindowI spectralWindowI : abstractBaseBandConfig.getSpectralWindow()) {
                Frequency frequency2 = ((BLSpectralWindow)spectralWindowI).getSkyFrequency();
                ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createSingleContinuum();
                scienceSpectralWindow.setCenterFrequency(frequency2);
                scienceSpectralWindow.setBandWidth(UserFrequency.createUserFrequencyGHZ(2.0));
                spectralSetupParameters.addScienceSpectralWindow(n, n2++, scienceSpectralWindow);
            }
            ++n;
        }
        spectralSetupParameters.setOverrideLO1(Optional.of(spectralSpec.getFrequencySetup().getLO1Frequency().deepCopy()));
        spectralSetupParameters.setRepresentativeFrequency(frequency);
    }

    protected boolean isNonOverlappingBandwidthBWSWCompliant(ScienceGoal scienceGoal) {
        NonOverlappingBandwidthCalculator nonOverlappingBandwidthCalculator = NonOverlappingBandwidthCalculator.getCalculator(scienceGoal.getSpectralSetupParameters(), scienceGoal.getKeyTargetParameters());
        Frequency frequency = nonOverlappingBandwidthCalculator.calculatePerPoln();
        if (frequency == null) {
            return false;
        }
        return frequency.isLessThan((AbstractDoubleWithUnit)Frequency.createFrequencyGHZ(0.9375));
    }

    public static enum DGCTypeEnum {
        None("None"),
        DGCBandwidthSwitching("BWSW"),
        DGCBandToBand("B2B");

        private final String label;

        private DGCTypeEnum(String string2) {
            this.label = string2;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum BWSWSchedulingOutcome {
        Scheduled(true),
        NotScheduled(false),
        FailedToCommunicateWithCalibratorServer(true),
        NoCalibratorFoundInCatalogue(false),
        ScienceGoalConfigurationIncompatible(false),
        BWSWWeakCalibratorFound(true),
        UnuseableBWSWCalibratorFound(false);

        private boolean isBWSWToBeScheduled = false;

        private BWSWSchedulingOutcome(boolean bl) {
            this.isBWSWToBeScheduled = bl;
        }

        public boolean isBWSWToBeScheduled() {
            return this.isBWSWToBeScheduled;
        }
    }

    public static enum B2BSchedulingOutcome {
        Scheduled(true),
        UseBWSW(false),
        NotScheduled(false),
        FailedToCommunicateWithCalibratorServer(true),
        RFFluxLessThanAntennaFlux(false),
        SuitableInBandCalibratorFound(false),
        NoCalibratorFoundInCatalogue(false),
        ScienceGoalConfigurationIncompatible(false),
        B2BWeakCalibratorFound(true),
        UnuseableB2BCalibratorFound(false);

        private boolean isB2BToBeScheduled = false;

        private B2BSchedulingOutcome(boolean bl) {
            this.isB2BToBeScheduled = bl;
        }

        public boolean isB2BToBeScheduled() {
            return this.isB2BToBeScheduled;
        }
    }
}

