/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.persistence.EntityIdUpdatedListenerInterface;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.MendMyStruct;
import alma.obsprep.ot.persistence.ProjectResetListener;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public class StaleSBDetector
implements ProjectResetListener,
EntityIdUpdatedListenerInterface {
    private ConcurrentHashMap<String, Integer> schedBlockFreshnessMap = new ConcurrentHashMap(100);
    private static StaleSBDetector instance = null;
    private final List<TestUtilities.Prune> pruneList = List.of(new TestUtilities.Prune("[\n\t ]*<prj:ObsUnitSetRef.*?/>", ""));

    public static synchronized StaleSBDetector getInstance() {
        if (instance == null) {
            instance = new StaleSBDetector();
        }
        return instance;
    }

    private StaleSBDetector() {
        ImpexFactory.getInstance().addProjectImportListener(this);
        MendMyStruct.addEntityChangeListener(this);
    }

    public boolean isSBNeedingRegenerating(SchedBlock schedBlock, ScienceGoal scienceGoal) {
        UserEditRestrictionController userEditRestrictionController = UserEditRestrictionController.getInstance();
        if (userEditRestrictionController.isPreExistingP2GMajorEditsInPlace(scienceGoal)) {
            return false;
        }
        if (!schedBlock.isDeletable()) {
            return false;
        }
        if (!this.getSchedBlockFreshnessMap().containsKey(schedBlock.getEntityID())) {
            return true;
        }
        int n = this.getSchedBlockFreshnessMap().get(schedBlock.getEntityID());
        int n2 = TestUtilities.pruneXml(scienceGoal.toXml(), this.pruneList).hashCode();
        return n == n2;
    }

    public synchronized void setSBInSyncWithGeneratingSG(@NonNull SchedBlock schedBlock, @NonNull ScienceGoal scienceGoal) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedSG is marked non-null but is null");
        }
        this.getSchedBlockFreshnessMap().put(schedBlock.getEntityID(), TestUtilities.pruneXml(scienceGoal.toXml(), this.pruneList).hashCode());
    }

    public ConcurrentHashMap<String, Integer> getSchedBlockFreshnessMap() {
        return this.schedBlockFreshnessMap;
    }

    @Override
    public void projectDocumentReset(ObsProject obsProject, ImpexFactory.WorkingPersistenceData workingPersistenceData) {
        this.schedBlockFreshnessMap = workingPersistenceData.getSchedBlockFreshnessMap();
    }

    @Override
    public void entityIdUpdated(String string, String string2) {
        if (this.schedBlockFreshnessMap.containsKey(string)) {
            Integer n = this.schedBlockFreshnessMap.get(string);
            this.schedBlockFreshnessMap.remove(string);
            this.schedBlockFreshnessMap.put(string2, n);
        }
    }

    public synchronized void resetSBFreshnessMap(@NonNull ObsProject obsProject) {
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        this.schedBlockFreshnessMap.clear();
        if (obsProject.getObsProgram() != null) {
            for (ScienceGoal scienceGoal : obsProject.getObsProgram().getAbstractScienceGoalScienceGoal()) {
                SchedBlockWorker.findSBsInSG((AbstractScienceGoal)((Object)scienceGoal)).forEach(schedBlock -> this.setSBInSyncWithGeneratingSG((SchedBlock)schedBlock, scienceGoal));
            }
        }
    }
}

