/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.StandardOUSStructureAssemblerInterface;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class StandardOUSStructureAssembler
implements StandardOUSStructureAssemblerInterface {
    private final List<SchedBlock> sbList = new ArrayList<SchedBlock>();
    private ObsUnitSet standardOUSSet;

    @Override
    public ObsUnitSet assembleStandardOUSStructure(@NonNull List<ObsUnitSet> list) {
        if (list == null) {
            throw new NullPointerException("ousesContainingSchedBlocks is marked non-null but is null");
        }
        this.standardOUSSet = ObsUnitSet.createObsUnitSet();
        for (ObsUnitSet obsUnitSet : list) {
            ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
            SchedBlockWorker.findSBsUnderOUS(arrayList, obsUnitSet);
            arrayList.stream().forEach(schedBlock -> {
                this.sbList.add((SchedBlock)schedBlock);
                this.standardOUSSet.addSchedBlock((SchedBlock)schedBlock);
            });
        }
        return this.standardOUSSet;
    }

    @Override
    public void resetOUSStructure() {
        if (this.standardOUSSet == null) {
            return;
        }
        this.sbList.stream().forEach(schedBlock -> schedBlock.referrers.remove((IBusinessObject)this.standardOUSSet, Referring.By.UmlComposition));
        this.sbList.clear();
    }
}

