/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.dgcpostprocessor;

import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.dgcpostprocessor.B2BACADGCParameterConfigurator;
import alma.obsprep.services.generator.refactored.dgcpostprocessor.B2BTMDGCParameterConfigurator;
import alma.obsprep.services.generator.refactored.dgcpostprocessor.BWSWACADGCParameterConfigurator;
import alma.obsprep.services.generator.refactored.dgcpostprocessor.BWSWTMDGCParameterConfigurator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import java.util.EnumSet;
import lombok.NonNull;

public class DGCObservingParametersFactory {
    public static DGCParameterConfiguratorInterface getParameterConfigurator(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = schedBlock.getSbGenerationContext().getSchemaToUseForSBGeneration();
        boolean bl = enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_B2B);
        boolean bl2 = enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_BWSW);
        assert (!bl2 || !bl);
        if (bl) {
            if (schedBlock.isForACA()) {
                return new B2BACADGCParameterConfigurator(schedBlock);
            }
            return new B2BTMDGCParameterConfigurator(schedBlock);
        }
        if (bl2) {
            if (schedBlock.isForACA()) {
                return new BWSWACADGCParameterConfigurator(schedBlock);
            }
            return new BWSWTMDGCParameterConfigurator(schedBlock);
        }
        throw new WizardSBGenerationException("Unknown DGC calibrator factoryrequested");
    }

    public static interface DGCParameterConfiguratorInterface {
        default public void configurePhaseCalibrators() {
        }

        default public void configureCheckSourceCalibrators() {
        }

        default public void configureDGCScienceCalibrators() {
        }

        default public void configureDGCRefCalibrators() {
        }

        default public void checkDataRates() {
        }

        default public void configureDGCReferenceBandpass() {
        }

        default public void configureDGCTargets() {
            this.configurePhaseCalibrators();
            this.configureCheckSourceCalibrators();
            this.configureDGCScienceCalibrators();
            this.configureDGCRefCalibrators();
            this.checkDataRates();
            this.configureDGCReferenceBandpass();
        }
    }
}

