/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntegrationTimeResolverInterface;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import lombok.NonNull;

public abstract class AbstractIntermediateTarget
implements IntermediateTarget,
IntegrationTimeResolverInterface {
    SBGenerationContext sbContext;
    protected Log.Logger logger = Log.logger((Object)this);
    protected ObservingGroupManager observingGroupManager;
    protected EnumSet<SBGeneratorTemplate.SBGenerationSchema> schemaToUseForSBGeneration;
    protected final Collection<IntermediateTarget> children = new ArrayList<IntermediateTarget>();
    protected List<Target> targets = new ArrayList<Target>();
    protected List<OrderedTarget> orderedTargets = new ArrayList<OrderedTarget>();
    protected int targetPriority = 99;
    protected String type = "";
    private String groupName;

    public abstract void assignMultipleVelocitySourceTargetsToObservingGroups(TargetWithIntent var1, SpectralSetupParameters var2, RequestedArray var3, ObservingGroupManager var4, Integer var5);

    @Override
    public void setTargets(List<Target> list) {
        this.targets = list;
    }

    @Override
    public List<Target> getTargets() {
        ArrayList<Target> arrayList = new ArrayList<Target>(this.targets);
        for (Target object : this.targets) {
            this.adjustCalibratorSubscanDurations(object);
        }
        for (IntermediateTarget intermediateTarget : this.children) {
            arrayList.addAll(intermediateTarget.getTargets());
        }
        return arrayList;
    }

    @Override
    public List<OrderedTarget> getOrderedTargets() {
        ArrayList<OrderedTarget> arrayList = new ArrayList<OrderedTarget>(this.orderedTargets);
        for (IntermediateTarget intermediateTarget : this.children) {
            arrayList.addAll(intermediateTarget.getOrderedTargets());
        }
        return arrayList;
    }

    @Override
    public Target getRepresentativeTarget() {
        return null;
    }

    protected void adjustCalibratorSubscanDurations(@NonNull Target target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        Time time = target.getSpectralSpec().getAbstractCorrelatorConfiguration().getIntegrationDuration();
        for (ObservingParameters observingParameters : target.getObservingParameters()) {
            if (!(observingParameters instanceof CalibratorParameters)) {
                return;
            }
            CalibratorParameters calibratorParameters = (CalibratorParameters)((Object)observingParameters);
            Time time2 = calibratorParameters.getSubScanDuration().adjustToIntegerMultipleOf(time);
            calibratorParameters.setSubScanDuration(time2);
        }
        int n = target.getFieldSource().getReferenceCount();
        if (n < 1) {
            return;
        }
        Reference reference = target.getFieldSource().getReference(0);
        Time time3 = reference.getSubScanDuration().adjustToIntegerMultipleOf(time);
        reference.setSubScanDuration(time3);
    }

    @Override
    public final Time determineIntegrationTimes(Boolean bl, SpectralSetupParameters spectralSetupParameters, @NonNull RequestedArray requestedArray) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        return bl != false ? this.determineFDMIntegrationTimes(spectralSetupParameters, requestedArray) : this.determineTDMIntegrationTimes(spectralSetupParameters, requestedArray);
    }

    @Override
    public final Time determineFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters, @NonNull RequestedArray requestedArray) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        switch (requestedArray.getArray()) {
            case ARRAY_12M: {
                return this.get12mFDMIntegrationTimes(spectralSetupParameters);
            }
            case ARRAY_7M: {
                return this.get7mFDMIntegrationTimes(spectralSetupParameters);
            }
            case ARRAY_TP: {
                return this.getTPFDMIntegrationTimes(spectralSetupParameters);
            }
        }
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unknown array detected");
    }

    @Override
    public final Time determineTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        switch (requestedArray.getArray()) {
            case ARRAY_12M: {
                return this.get12mTDMIntegrationTimes(spectralSetupParameters);
            }
            case ARRAY_7M: {
                return this.get7mTDMIntegrationTimes(spectralSetupParameters);
            }
            case ARRAY_TP: {
                return this.getTPTDMIntegrationTimes(spectralSetupParameters);
            }
        }
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unknown array detected");
    }

    @Override
    public Time getTPFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Not implemented for this calibration type");
    }

    @Override
    public Time get7mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Not implemented for this calibration type");
    }

    @Override
    public Time get12mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Not implemented for this calibration type");
    }

    @Override
    public Time getTPTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Not implemented for this calibration type");
    }

    @Override
    public Time get7mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Not implemented for this calibration type");
    }

    @Override
    public Time get12mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Not implemented for this calibration type");
    }

    public void addOrderedTarget(@NonNull Target target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        OrderedTarget orderedTarget = OrderedTarget.createOrderedTarget();
        orderedTarget.setTarget(target);
        this.orderedTargets.add(orderedTarget);
    }

    public void setObservingGroupManager(ObservingGroupManager observingGroupManager) {
        this.observingGroupManager = observingGroupManager;
    }

    public ObservingGroupManager getObservingGroupManager() {
        return this.observingGroupManager;
    }

    @Override
    public int getTargetPriority() {
        return this.targetPriority;
    }

    public void setTargetPriority(int n) {
        this.targetPriority = n;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public class UnableToGetSplitTuningsException
    extends Exception {
        public UnableToGetSplitTuningsException() {
        }

        public UnableToGetSplitTuningsException(String string) {
            super(string);
        }

        public UnableToGetSplitTuningsException(Throwable throwable) {
            super(throwable);
        }
    }
}

