/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntegrationTimeResolverInterface;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.PhaseCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.StandardCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Stream;
import lombok.NonNull;

public class CheckSourceIntermediateTarget
extends StandardCalIntermediateTarget {
    public CheckSourceIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext) {
        super(targetWithIntent, spectralSetupParameters, requestedArray, ObsType.CHECKSOURCE, observingGroupManager, n, ObservingGroupManager.ObservingGroupType.SCIENCE, enumSet, sBGenerationContext);
        if (sBGenerationContext.getArray().equals((Object)RequestedArray.TWELVE_M) && sBGenerationContext.getConfiguration().isLongBaselineConfiguration()) {
            this.getOrderedTargets().stream().filter(orderedTarget -> targetWithIntent.getObsType().equals((Object)ObsType.CHECKSOURCE)).forEach(orderedTarget -> orderedTarget.getTarget().getCheckSourceCalParametersList()[0].setSubScanDuration(Time.createTimeSec(18.144)));
        }
    }

    static boolean isC5C6WithHighFrequencyCustomisationRequired(@NonNull SBGenerationContext sBGenerationContext) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        Configuration configuration = sBGenerationContext.getConfiguration();
        if (configuration == null) {
            return false;
        }
        boolean bl = ConfigurationHelper.isConfigurationInSet(configuration, 5, 6);
        boolean bl2 = ReceiverBand.isReceiverBandInSet(sBGenerationContext.getReceiverBand(), 7, 8, 9, 10);
        return bl2 && bl;
    }

    @Override
    protected void determineAdditionalTargetsRequiredForSpectralScans(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, Integer n) {
    }

    @Override
    public void assignMultipleVelocitySourceTargetsToObservingGroups(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n) {
    }

    @Override
    public Time getTPFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) {
        return Time.createTime((double)20.0, (String)Time.UNIT_S);
    }

    @Override
    public Time getTPTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) {
        return Time.createTime((double)20.0, (String)Time.UNIT_S);
    }

    @Override
    public Time get12mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = null;
        time = this.determineLongBaselineConfigurationIntegrationTime();
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for non-longbaseline configurations");
        }
        return time;
    }

    @Override
    public Time get12mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = null;
        time = this.determineLongBaselineConfigurationIntegrationTime();
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for non-longbaseline configurations");
        }
        return time;
    }

    private Time determineLongBaselineConfigurationIntegrationTime() {
        if (this.sbContext.getConfiguration().isLongBaselineConfiguration()) {
            return Time.createTimeSec(18.0);
        }
        return null;
    }

    public static boolean isC7HighFrequencyInBandChecksourceCustomisationRequired(@NonNull SBGenerationContext sBGenerationContext) {
        Configuration configuration;
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        if (!sBGenerationContext.isTM1SB()) {
            return false;
        }
        SpectralSetupParameters spectralSetupParameters = sBGenerationContext.getGoal().getSpectralSetupParameters();
        try {
            configuration = Configuration.getConfigurationsToBeScheduled(sBGenerationContext.getGoal()).getMostExtendedTM1Configuration();
        }
        catch (Configuration.UnableToDetermineConfigurationException | InvalidObsProgramParametersException exception) {
            throw new WizardSBGenerationException("Unable to determine most extended 12-m configuration for setup: " + exception.getMessage());
        }
        return PhaseCalIntermediateTarget.HIGHBANDS.contains(spectralSetupParameters.getReceiverBand()) && ConfigurationHelper.isConfigurationInSet(configuration, 7);
    }

    public static void setCheckSourceCycleTimes(@NonNull SchedBlock schedBlock, double d) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            Object object;
            Time time = Time.createTime();
            Time time2 = null;
            Time time3 = null;
            ArrayList<Target> arrayList = new ArrayList<Target>();
            for (OrderedTarget orderedTarget : observingGroup.getOrderedTarget()) {
                object = orderedTarget.getTarget();
                for (ScienceParameters scienceParameters : object.getScienceParametersList()) {
                    time.aggregate(scienceParameters.getIntegrationTime().getTime());
                }
                if (object.hasPhaseCalParameters()) {
                    time2 = object.getPhaseCalParametersList()[0].getCycleTime();
                    time3 = object.getPhaseCalParametersList()[0].getSubScanDuration();
                }
                if (!object.hasCheckSourceCalParameters()) continue;
                arrayList.add((Target)object);
            }
            if (time.isZero() || time2 == null || arrayList.isEmpty()) continue;
            Time time4 = (Time)time.multiply(0.3333333333333333);
            Time time5 = (Time)((Time)((Time)time2.plus((AbstractDoubleWithUnit)Time.createTimeSec(7.0))).plus((AbstractDoubleWithUnit)time3)).multiply(d);
            for (Target target : arrayList) {
                object = target.getFirstCheckSourceCalParameters().orElseThrow(WizardSBGenerationException::new);
                if (time5.isGreaterThan((AbstractDoubleWithUnit)time4)) {
                    object.setCycleTime(time5);
                    continue;
                }
                object.setCycleTime(time4);
            }
        }
    }

    public static boolean isLongBaselineInBandChecksourceCustomisationRequired(@NonNull SBGenerationContext sBGenerationContext) {
        Configuration configuration;
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        if (!sBGenerationContext.isTM1SB()) {
            return false;
        }
        SpectralSetupParameters spectralSetupParameters = sBGenerationContext.getGoal().getSpectralSetupParameters();
        try {
            configuration = Configuration.getConfigurationsToBeScheduled(sBGenerationContext.getGoal()).getMostExtendedTM1Configuration();
        }
        catch (Configuration.UnableToDetermineConfigurationException | InvalidObsProgramParametersException exception) {
            throw new WizardSBGenerationException("Unable to determine most extended 12-m configuration for setup: " + exception.getMessage());
        }
        boolean bl = configuration.isLongBaselineConfiguration();
        if (ReceiverBand.isReceiverBandInSet(spectralSetupParameters.getReceiverBand(), 1, 2, 3, 4, 5, 6, 7) && bl) {
            return true;
        }
        return PhaseCalIntermediateTarget.HIGHBANDS.contains(spectralSetupParameters.getReceiverBand()) && bl;
    }

    @Override
    public void useAsTemplate(@NonNull IntermediateTarget intermediateTarget) {
        if (intermediateTarget == null) {
            throw new NullPointerException("intermediateTarget is marked non-null but is null");
        }
        this.setTargets(intermediateTarget.getTargets().stream().filter(target -> !target.hasPhaseCalParameters()).toList());
        this.targetPriority = intermediateTarget.getTargetPriority();
        this.orderedTargets = intermediateTarget.getOrderedTargets().stream().filter(orderedTarget -> !orderedTarget.getTarget().hasPhaseCalParameters()).toList();
    }

    public static void postProcessCheckSourceObservingParameters(@NonNull SchedBlock schedBlock, @NonNull ScienceGoal scienceGoal) throws SchedBlock.UnableToFindParentScienceGoalException {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (schedBlock.isTotalPowerAmpcalSB() || schedBlock.isTotalPowerScienceSB()) {
            return;
        }
        SBGenerationContext sBGenerationContext = schedBlock.getSbGenerationContext();
        if (sBGenerationContext.isVLBI()) {
            CheckSourceIntermediateTarget.configureVLBICheckSource(schedBlock);
        } else {
            boolean bl = CheckSourceIntermediateTarget.isLongBaselineInBandChecksourceCustomisationRequired(sBGenerationContext);
            double d = bl ? 4.0 : 3.0;
            CheckSourceIntermediateTarget.setCheckSourceCycleTimes(schedBlock, d);
        }
    }

    public static void configureVLBICheckSource(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        schedBlock.getAllTargets(CheckSourceCalParameters.CheckSourceParametersFilter).stream().forEach(target -> Stream.of(target.getCheckSourceCalParametersList()).forEach(checkSourceCalParameters -> {
            checkSourceCalParameters.setCycleTime(Time.createTime((double)10.0, (String)Time.UNIT_D));
            checkSourceCalParameters.setSubScanDuration(Time.createTimeSec(4.032));
            checkSourceCalParameters.setDefaultIntegrationTime(Time.createTimeSec(2.016));
            checkSourceCalParameters.setName("CheckSourceParameters(VLBI)");
        }));
    }
}

