/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.intermediatetarget.AtmosphericWindow;
import alma.obsprep.services.generator.refactored.intermediatetarget.AtmosphericWindowNotFoundException;
import alma.obsprep.services.generator.refactored.intermediatetarget.CheckSourceIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntegrationTimeResolverInterface;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.StandardCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.obsparams.ScienceGoalObservingParametersFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.AngularResolutionLimitsExpertFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.AngularResolutionLimitsExpertInterface;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.spectralspec.SpectralSpecFactory;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreator;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import lombok.NonNull;

public class PhaseCalIntermediateTarget
extends StandardCalIntermediateTarget
implements IntegrationTimeResolverInterface {
    private static Map<Integer, Time> longBaselineCheckSourceIntegrationTimes = Map.of(1, Time.createTimeSec(60.0), 2, Time.createTimeSec(54.0), 3, Time.createTimeSec(54.0), 4, Time.createTimeSec(54.0), 5, Time.createTimeSec(54.0), 6, Time.createTimeSec(54.0), 7, Time.createTimeSec(54.0), 8, Time.createTimeSec(49.0), 9, Time.createTimeSec(41.0), 10, Time.createTimeSec(30.0));
    public static final Collection<ReceiverBand> HIGHBANDS = List.of(ReceiverBand.getReceiverBand(8), ReceiverBand.getReceiverBand(9), ReceiverBand.getReceiverBand(10));
    private static final double CHECKSOURCE_AR_THRESHOLD_ARCSEC = 0.25;

    @Override
    protected void determineAdditionalTargetsRequiredForSpectralScans(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, Integer n) {
        block5: {
            EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sbContext.getSchemaToUseForSBGeneration();
            try {
                SpectralScan.SpectralScanTunings spectralScanTunings = spectralSetupParameters.getSpectralScan().getTunings();
                if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
                    int n2 = 1;
                    for (ArrayList<Frequency> arrayList : spectralScanTunings.getTunings()) {
                        SpectralSetupParameters spectralSetupParameters2 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, arrayList);
                        this.sspsDerivedFromSpectralScanTuning.add(spectralSetupParameters2);
                        Integer n3 = this.getObservingGroupManager().getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, n2);
                        Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n3, this.sbContext);
                        this.completeTargetConstruction(target, spectralSetupParameters2, requestedArray, targetWithIntent);
                        if (this.isCheckSourceNeeded(spectralSetupParameters2, requestedArray, this.sbContext, targetWithIntent.isDependentTargetsMandated())) {
                            this.createCheckSource(targetWithIntent, spectralSetupParameters2, requestedArray, n3, this.sbContext);
                        }
                        ++n2;
                    }
                    break block5;
                }
                throw new RuntimeException("Unexpected spectral scan generation mode detected " + enumSet);
            }
            catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
                Log.Logger logger = Log.logger((Object)this);
                logger.log(Level.WARNING, "Failed to add spectral scan tunings ", (Throwable)exception);
            }
        }
    }

    public PhaseCalIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext) {
        super(targetWithIntent, spectralSetupParameters, requestedArray, ObsType.PHASE, observingGroupManager, n, ObservingGroupManager.ObservingGroupType.SCIENCE, enumSet, sBGenerationContext);
        boolean bl;
        boolean bl2;
        this.setTargetPriority(2);
        boolean bl3 = sBGenerationContext.getArray().equals((Object)RequestedArray.TWELVE_M);
        boolean bl4 = sBGenerationContext.getConfiguration() != null && sBGenerationContext.getConfiguration().isLongBaselineConfiguration();
        this.setLongBaselineSubscanDuration(targetWithIntent, bl3, bl4);
        boolean bl5 = HIGHBANDS.contains(spectralSetupParameters.getReceiverBand());
        boolean bl6 = bl2 = bl3 || sBGenerationContext.getArray().equals((Object)RequestedArray.SEVEN_M);
        if (bl2 && bl5) {
            this.setInterferometricHFParameters(targetWithIntent);
        }
        if (sBGenerationContext.isSolar() && (sBGenerationContext.isTM1SB() || sBGenerationContext.isTM2SB())) {
            this.setInterferometricShortBaselineHFParameters(targetWithIntent);
        }
        if (bl = VLBIExpert.isPassivePhasingEnabled(sBGenerationContext.getGoal())) {
            this.setPassivePhasingParameters(targetWithIntent);
        }
        if (!enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN) && this.isCheckSourceNeeded(spectralSetupParameters, requestedArray, sBGenerationContext, targetWithIntent.isDependentTargetsMandated())) {
            if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
                this.createCheckSource(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, n), sBGenerationContext);
            } else if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.STANDARD)) {
                this.createCheckSource(targetWithIntent, spectralSetupParameters, requestedArray, observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, 1), sBGenerationContext);
            } else {
                throw new RuntimeException("Unknown SB generation schema type detected " + enumSet);
            }
        }
    }

    private void setPassivePhasingParameters(@NonNull TargetWithIntent targetWithIntent) {
        if (targetWithIntent == null) {
            throw new NullPointerException("phaseTarget is marked non-null but is null");
        }
        this.getTargets().stream().filter(target -> !(targetWithIntent instanceof QuerySource) && targetWithIntent.getObsType().equals((Object)ObsType.PHASE)).forEach(target -> {
            for (PhaseCalParameters phaseCalParameters : target.getPhaseCalParametersList()) {
                phaseCalParameters.setSubScanDuration(Time.createTimeSec(16.128));
                phaseCalParameters.setDefaultIntegrationTime(Time.createTimeSec(4.0));
            }
            String string = "VLBI Phasor";
            FieldSource fieldSource = target.getFieldSource();
            fieldSource.setName("VLBI Phasor");
        });
    }

    private void setInterferometricHFParameters(@NonNull TargetWithIntent targetWithIntent) {
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.getTargets().stream().filter(target -> targetWithIntent.getObsType().equals((Object)ObsType.PHASE)).forEach(target -> {
            for (PhaseCalParameters phaseCalParameters : target.getPhaseCalParametersList()) {
                phaseCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(phaseCalParameters.getDefaultIntegrationTime(), target));
            }
        });
    }

    private void setInterferometricShortBaselineHFParameters(@NonNull TargetWithIntent targetWithIntent) {
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.getTargets().stream().filter(target -> targetWithIntent.getObsType().equals((Object)ObsType.PHASE)).forEach(target -> {
            for (PhaseCalParameters phaseCalParameters : target.getPhaseCalParametersList()) {
                phaseCalParameters.setSubScanDuration(Time.createTimeSec(60.48));
                phaseCalParameters.setDefaultIntegrationTime(Time.createTimeSec(60.0));
            }
        });
    }

    private void setLongBaselineSubscanDuration(TargetWithIntent targetWithIntent, boolean bl, boolean bl2) {
        if (bl && bl2) {
            this.getTargets().stream().filter(target -> targetWithIntent.getObsType().equals((Object)ObsType.PHASE)).forEach(target -> {
                for (PhaseCalParameters phaseCalParameters : target.getPhaseCalParametersList()) {
                    phaseCalParameters.setSubScanDuration(Time.createTimeSec(18.144));
                }
            });
        }
    }

    private void createCheckSource(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, Integer n, SBGenerationContext sBGenerationContext) {
        Configuration configuration;
        Object object;
        Object object2;
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_CHECKSOURCE);
        querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
        if (targetWithIntent instanceof QuerySource) {
            object2 = (QuerySource)targetWithIntent;
            querySource.setQueryCenter(object2.getQueryCenter().deepCopy());
        } else if (targetWithIntent instanceof CalibrationTargetParameters) {
            object = (CalibrationTargetParameters)targetWithIntent;
            querySource.setQueryCenter(object.getSourceCoordinates().deepCopy());
        }
        object2 = TargetCreator.createTarget(querySource, spectralSetupParameters, n, sBGenerationContext);
        object2.getFieldSource().setName("Check source");
        object = new SpectralSpecFactory(sBGenerationContext);
        SpectralSpec spectralSpec = ((SpectralSpecFactory)object).getSpectralSpec(spectralSetupParameters, spectralSetupParameters.getSourceVelocity(), ObsType.SCIENCE, Optional.of(targetWithIntent));
        ((Target)object2).setSpectralSpec(spectralSpec);
        if (sBGenerationContext.isTM1SB()) {
            try {
                configuration = Configuration.getConfigurationsToBeScheduled(sBGenerationContext.getGoal()).getMostExtendedTM1Configuration();
            }
            catch (Configuration.UnableToDetermineConfigurationException | InvalidObsProgramParametersException exception) {
                throw new WizardSBGenerationException("Unable to determine most extended 12-m configuration for setup: " + exception.getMessage());
            }
        } else {
            configuration = sBGenerationContext.getConfiguration();
        }
        boolean bl = CheckSourceIntermediateTarget.isLongBaselineInBandChecksourceCustomisationRequired(sBGenerationContext);
        boolean bl2 = CheckSourceIntermediateTarget.isC7HighFrequencyInBandChecksourceCustomisationRequired(sBGenerationContext);
        boolean bl3 = CheckSourceIntermediateTarget.isC5C6WithHighFrequencyCustomisationRequired(sBGenerationContext);
        for (Target target : this.targets) {
            HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(target.getIntendedObservingGroupList()));
            if (!target.hasPhaseCalParameters() || !hashSet.contains(n)) continue;
            PhaseCalParameters phaseCalParameters = target.getPhaseCalParametersList()[0];
            for (CheckSourceCalParameters checkSourceCalParameters : ((Target)object2).getCheckSourceCalParametersList()) {
                int n2;
                checkSourceCalParameters.setName("Check source parameters");
                checkSourceCalParameters.setDataOrigin(phaseCalParameters.getDataOrigin());
                ScienceGoalObservingParametersFactory scienceGoalObservingParametersFactory = new ScienceGoalObservingParametersFactory(sBGenerationContext.getGoal(), spectralSpec, targetWithIntent, requestedArray, sBGenerationContext);
                checkSourceCalParameters.setSubScanDuration(scienceGoalObservingParametersFactory.getAlignedSubscanDuration(60.0));
                if (bl) {
                    n2 = sBGenerationContext.getGoal().getSpectralSetupParameters().getReceiverBand().getNumber();
                    Time time = longBaselineCheckSourceIntegrationTimes.get(n2);
                    checkSourceCalParameters.setDefaultIntegrationTime(time);
                    checkSourceCalParameters.setSubScanDuration(scienceGoalObservingParametersFactory.getAlignedSubscanDuration(time.getSecs()));
                    continue;
                }
                if (bl2) {
                    Time time = Time.createTimeSec(54.0);
                    checkSourceCalParameters.setDefaultIntegrationTime(time);
                    checkSourceCalParameters.setSubScanDuration(scienceGoalObservingParametersFactory.getAlignedSubscanDuration(time.getSecs()));
                    continue;
                }
                if (!bl3) continue;
                n2 = sBGenerationContext.getGoal().getSpectralSetupParameters().isWalshSwitching() ? 1 : 0;
                checkSourceCalParameters.setDefaultIntegrationTime(Time.createTimeSec(30.0));
                checkSourceCalParameters.setSubScanDuration(n2 != 0 ? Time.createTimeSec(30.72) : Time.createTimeSec(30.24));
            }
            boolean bl4 = configuration != null && configuration.isLongBaselineConfiguration();
            int n3 = HIGHBANDS.contains(spectralSetupParameters.getReceiverBand()) ? 1 : 0;
            if (bl4 || n3 != 0) {
                FieldSource fieldSource = target.getFieldSource().deepCopy();
                fieldSource.setName("Check");
                object2.setFieldSource(fieldSource);
                break;
            }
            object2.setFieldSource(target.getFieldSource());
            break;
        }
        this.targets.add(object2);
        Object object3 = OrderedTarget.createOrderedTarget();
        object3.setTarget((Target)object2);
        this.orderedTargets.add(object3);
    }

    boolean isCheckSourceNeeded(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull RequestedArray requestedArray, @NonNull SBGenerationContext sBGenerationContext, boolean bl) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        if (requestedArray.isTP()) {
            return false;
        }
        if (sBGenerationContext.isVLBI() && !bl) {
            return false;
        }
        if (bl) {
            return true;
        }
        if (HIGHBANDS.contains(spectralSetupParameters.getReceiverBand())) {
            return true;
        }
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        if (SingleFieldScienceGoalModel.isNarrowBWScienceGoal(scienceGoal)) {
            return true;
        }
        if (requestedArray.isACA7M()) {
            return false;
        }
        assert (RequestedArray.TWELVE_M.equals((Object)requestedArray));
        SBGeneratorTemplate.SchedBlockType schedBlockType = sBGenerationContext.getSBType();
        assert (EnumSet.of(SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION, SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION).contains((Object)schedBlockType)) : "Should only be 12-m SBs at this point";
        boolean bl2 = scienceGoal.getCalibrationSetupParameters().isEnhancedAstrometry();
        if (schedBlockType.equals((Object)SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION) && bl2) {
            return true;
        }
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        schedBlock.setSbGenerationContext(sBGenerationContext);
        AngularResolutionLimitsExpertInterface angularResolutionLimitsExpertInterface = AngularResolutionLimitsExpertFactory.getARLimitsExpert(schedBlockType);
        angularResolutionLimitsExpertInterface.setARLimitsInSBConstraints(scienceGoal, List.of(List.of(schedBlock)));
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        return schedulingConstraints.getMinAcceptableAngResolution().getArcsec() < 0.25 || schedulingConstraints.getMaxAcceptableAngResolution().getArcsec() < 0.25;
    }

    @Override
    public Time getTPFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("TP FDM calibration times are as yet unknown");
    }

    @Override
    public Time get7mFDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        Time time = null;
        if (spectralSetupParameters == null || spectralSetupParameters.getReceiverBand() == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine receiver band");
        }
        int n = spectralSetupParameters.getReceiverBand().getNumber();
        if (n == 1 || n == 3 || n == 4 || n == 6) {
            time = Time.createTime((double)1.0, (String)Time.UNIT_MIN);
        } else if (n == 9 || n == 8 || n == 10) {
            time = Time.createTime((double)1.0, (String)Time.UNIT_MIN);
        } else if (n == 5) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ175));
                if (atmosphericWindow.equals((Object)AtmosphericWindow.GHZ175)) {
                    time = Time.createTime((double)2.0, (String)Time.UNIT_MIN);
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)1.0, (String)Time.UNIT_MIN);
            }
        } else if (n == 7) {
            AtmosphericWindow atmosphericWindow = null;
            try {
                atmosphericWindow = AtmosphericWindow.determineAtmosphericWindow(spectralSetupParameters.getRepresentativeFrequency(), EnumSet.of(AtmosphericWindow.GHZ321, AtmosphericWindow.GHZ365));
                switch (atmosphericWindow) {
                    case GHZ321: {
                        time = Time.createTime((double)2.0, (String)Time.UNIT_MIN);
                        break;
                    }
                    case GHZ365: {
                        time = Time.createTime((double)2.0, (String)Time.UNIT_MIN);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown atmospheric window detected " + atmosphericWindow);
                    }
                }
            }
            catch (AtmosphericWindowNotFoundException atmosphericWindowNotFoundException) {
                time = Time.createTime((double)1.0, (String)Time.UNIT_MIN);
            }
        }
        if (time == null) {
            throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("Unable to determine integration time for 7m FDM and receiver band " + n);
        }
        return time;
    }

    @Override
    public Time getTPTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        throw new IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException("TP calibration times are as yet undetermined");
    }

    @Override
    public Time get7mTDMIntegrationTimes(SpectralSetupParameters spectralSetupParameters) throws IntegrationTimeResolverInterface.IntegrationTimeUndeterminedException {
        return this.get7mFDMIntegrationTimes(spectralSetupParameters);
    }
}

