/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.intermediatetarget;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.StandardCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.targetcreator.TargetCreator;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import lombok.NonNull;

public class PointingCalForScienceGroupIntermediateTarget
extends StandardCalIntermediateTarget {
    private static final String SPECTRAL_SCAN_SCIENCE_POINTING_LABEL = "Science pointing";

    @Override
    protected void determineAdditionalTargetsRequiredForSpectralScans(@NonNull TargetWithIntent targetWithIntent, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull RequestedArray requestedArray, Integer n) {
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (!this.sbContext.getSchemaToUseForSBGeneration().contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
            throw new IllegalArgumentException("SB generation schema should be spectral scan");
        }
        if (requestedArray.isTP()) {
            this.addTPSpectralScanSciencePointingCalibrators(targetWithIntent, spectralSetupParameters, requestedArray, n);
        } else {
            this.addInterferometricSpectralScanSciencePointingCalibrators(targetWithIntent, spectralSetupParameters, requestedArray);
        }
    }

    private void addTPSpectralScanSciencePointingCalibrators(@NonNull TargetWithIntent targetWithIntent, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull RequestedArray requestedArray, Integer n) {
        if (targetWithIntent == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        try {
            SpectralScan.SpectralScanTunings spectralScanTunings = spectralSetupParameters.getSpectralScan().getTunings();
            SpectralSetupParameters spectralSetupParameters2 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, (List<Frequency>)spectralScanTunings.getTunings().get(0));
            Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n, this.sbContext);
            this.completeTargetConstruction(target, spectralSetupParameters2, requestedArray, targetWithIntent);
            target.getFieldSource().setName(SPECTRAL_SCAN_SCIENCE_POINTING_LABEL);
            target.getFirstPointCalParameters().orElseThrow(WizardSBGenerationException::new).setCycleTime(Time.createTime((double)2.2, (String)Time.UNIT_H));
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
            Log.Logger logger = Log.logger((Object)this);
            logger.log(Level.WARNING, "Failed to create a point cal intermediate target for science group", (Throwable)exception);
        }
    }

    private void addInterferometricSpectralScanSciencePointingCalibrators(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray) {
        try {
            SpectralScan.SpectralScanTunings spectralScanTunings = spectralSetupParameters.getSpectralScan().getTunings();
            SpectralSetupParameters spectralSetupParameters2 = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(spectralSetupParameters, (List<Frequency>)spectralScanTunings.getTunings().get(0));
            int n = this.getObservingGroupManager().getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, 1);
            Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters2, n, this.sbContext);
            this.completeTargetConstruction(target, spectralSetupParameters2, requestedArray, targetWithIntent);
            target.getFieldSource().setName(SPECTRAL_SCAN_SCIENCE_POINTING_LABEL);
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
            Log.Logger logger = Log.logger((Object)this);
            logger.log(Level.WARNING, "Failed to create a point cal intermediate target for science group", (Throwable)exception);
        }
    }

    public PointingCalForScienceGroupIntermediateTarget(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet, SBGenerationContext sBGenerationContext) {
        super(targetWithIntent, spectralSetupParameters, requestedArray, ObsType.POINTING, observingGroupManager, n, ObservingGroupManager.ObservingGroupType.SCIENCE, enumSet, sBGenerationContext);
        this.setTargetPriority(1);
        Target target = (Target)this.targets.get(0);
        target.getObservingParameters(0).setName("PointingCalParameters (Science Group)");
        boolean bl = sBGenerationContext.getGoal().isSpectralScan();
        target.getFieldSource().setName(bl ? SPECTRAL_SCAN_SCIENCE_POINTING_LABEL : "Pointing Template (Science Group)");
    }

    public void assignMultipleVelocitySourceTargetsToObservingGroups(TargetWithIntent targetWithIntent, SpectralSetupParameters spectralSetupParameters, RequestedArray requestedArray, ObservingGroupManager observingGroupManager, Integer n, SBGenerationContext sBGenerationContext) {
        Target target = TargetCreator.createTarget(targetWithIntent, spectralSetupParameters, n, sBGenerationContext);
        this.completeTargetConstruction(target, spectralSetupParameters, requestedArray, targetWithIntent);
    }
}

