/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.obsparams;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationTimer;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.valuetypes.Time;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

abstract class PolarizationTimer
extends CalibrationTimer {
    private static Map<ReceiverBand, Time> bandSpecificIntegrationTimes = new HashMap<ReceiverBand, Time>();

    protected PolarizationTimer(SpectralSpec spectralSpec, SBGenerationContext sBGenerationContext) {
        super(spectralSpec, sBGenerationContext);
    }

    @Override
    public Time getCycleTime() {
        return Time.createTime((double)35.0, (String)Time.UNIT_MIN);
    }

    @Override
    public Time getScanDuration(@NonNull Time time) {
        if (time == null) {
            throw new NullPointerException("integrationTime is marked non-null but is null");
        }
        if (time.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)FIVE_MINS)) {
            double d = time.getContentInUnits(Time.UNIT_S);
            long l = Math.round(d % FIVE_MINS.getSecs());
            if (time.isEqual((AbstractDoubleWithUnit)Time.createTime((double)8.0, (String)Time.UNIT_MIN))) {
                return Time.createTimeSec(241.92);
            }
            if (l > 0L) {
                return Time.createTimeSec(60.48);
            }
            return Time.createTimeSec(302.4);
        }
        return this.getAlignedSubscanDuration(time);
    }

    @Override
    public Time getDefaultIntegrationTime() {
        Time time = null;
        ReceiverBand receiverBand = this.ss.getReceiverBand();
        assert (receiverBand != null);
        time = bandSpecificIntegrationTimes.get(receiverBand);
        if (time == null) {
            throw new RuntimeException("Unable to determine integration time for polarization calibration for band " + receiverBand);
        }
        return time;
    }

    static {
        bandSpecificIntegrationTimes.put(ReceiverBand.getReceiverBand("ALMA_RB_01"), Time.createTime((double)6.0, (String)Time.UNIT_MIN));
        bandSpecificIntegrationTimes.put(ReceiverBand.getReceiverBand("ALMA_RB_02"), Time.createTime((double)6.0, (String)Time.UNIT_MIN));
        bandSpecificIntegrationTimes.put(ReceiverBand.getReceiverBand("ALMA_RB_03"), Time.createTime((double)2.0, (String)Time.UNIT_MIN));
        bandSpecificIntegrationTimes.put(ReceiverBand.getReceiverBand("ALMA_RB_04"), Time.createTime((double)2.0, (String)Time.UNIT_MIN));
        bandSpecificIntegrationTimes.put(ReceiverBand.getReceiverBand("ALMA_RB_05"), Time.createTime((double)4.0, (String)Time.UNIT_MIN));
        bandSpecificIntegrationTimes.put(ReceiverBand.getReceiverBand("ALMA_RB_06"), Time.createTime((double)4.0, (String)Time.UNIT_MIN));
        bandSpecificIntegrationTimes.put(ReceiverBand.getReceiverBand("ALMA_RB_07"), Time.createTime((double)8.0, (String)Time.UNIT_MIN));
        bandSpecificIntegrationTimes.put(ReceiverBand.getReceiverBand("ALMA_RB_08"), Time.createTime((double)6.0, (String)Time.UNIT_MIN));
        bandSpecificIntegrationTimes.put(ReceiverBand.getReceiverBand("ALMA_RB_09"), Time.createTime((double)6.0, (String)Time.UNIT_MIN));
        bandSpecificIntegrationTimes.put(ReceiverBand.getReceiverBand("ALMA_RB_10"), Time.createTime((double)6.0, (String)Time.UNIT_MIN));
    }
}

