/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.targetcreator;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.targetcreator.CalibratorFieldSourceWorker;
import alma.obsprep.services.generator.refactored.targetcreator.FieldSourceWorkerUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Velocity;
import lombok.NonNull;

class QuerySourceFieldSourceWorker
extends CalibratorFieldSourceWorker {
    private static final double DEFAULT_PHASE_CAL_SEARCH_RADIUS_DEGS = 15.0;

    QuerySourceFieldSourceWorker() {
    }

    public static FieldSource getFieldSource(@NonNull alma.obsprep.bo.obsproject.QuerySource querySource, @NonNull RequestedArray requestedArray, @NonNull SpectralSpec spectralSpec, @NonNull SBGenerationContext sBGenerationContext) {
        Object object;
        if (querySource == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        FieldSource fieldSource = QuerySourceFieldSourceWorker.createCalibratorFieldSource();
        QuerySource querySource2 = QuerySource.createQuerySource(querySource);
        String string = querySource.getIntendedUse();
        if (querySource2.getQueryCenter().isDefaultCoordinates()) {
            object = sBGenerationContext.getGoal().getKeyTargetParameters();
            querySource2.setQueryCenter(object.getFieldCenterCoordinates().deepCopy());
        }
        switch (querySource.getObsType()) {
            case AMPLITUDE: {
                querySource2.setSearchRadius(Angle.createAngle((double)0.0, (String)Angle.UNIT_DEG));
                break;
            }
            case BANDPASS: {
                querySource2.setSearchRadius(Angle.createAngle((double)120.0, (String)Angle.UNIT_DEG));
                break;
            }
            case PHASE: {
                querySource2.setSearchRadius(QuerySourceFieldSourceWorker.getPhaseCalSearchRadii(sBGenerationContext));
                break;
            }
            case POINTING: {
                querySource2.setSearchRadius(Angle.createAngle((double)15.0, (String)Angle.UNIT_DEG));
            }
        }
        fieldSource.setIsQuery(true);
        fieldSource.setQuerySource(querySource2);
        fieldSource.setName(string);
        fieldSource.setSourceName("query");
        fieldSource.setSourceVelocity(Velocity.createVelocity());
        if (RequestedArray.TP.equals((Object)requestedArray) && ObsType.AMPLITUDE.equals((Object)querySource.getObsType())) {
            QuerySourceFieldSourceWorker.setUpTPAmplitudeRasterScan(fieldSource, spectralSpec);
        }
        object = FieldSourceWorkerUtils.getAtmosphericReferencePosition(spectralSpec, fieldSource);
        fieldSource.addReference((Reference)object);
        return fieldSource;
    }

    private static Angle getPhaseCalSearchRadii(@NonNull SBGenerationContext sBGenerationContext) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        Angle angle = Angle.createAngle((double)15.0, (String)Angle.UNIT_DEG);
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        ReceiverBand receiverBand = scienceGoal.getReceiverBand();
        if (receiverBand == null) {
            throw new WizardSBGenerationException();
        }
        int n = receiverBand.getNumber();
        if (sBGenerationContext.isTM1SB() || sBGenerationContext.isTM2SB()) {
            if (n >= 1 && n <= 6) {
                angle = QuerySourceFieldSourceWorker.getB1toB6SearchRadius(sBGenerationContext);
            } else if (n == 7) {
                angle = QuerySourceFieldSourceWorker.getB7SearchRadius(sBGenerationContext);
            } else if (n == 8) {
                angle = QuerySourceFieldSourceWorker.getB8SearchRadius(sBGenerationContext);
            } else if (n == 9) {
                angle = QuerySourceFieldSourceWorker.getB9SearchRadius(sBGenerationContext);
            } else if (n == 10) {
                angle = QuerySourceFieldSourceWorker.getB10SearchRadius(sBGenerationContext);
            }
        } else if (sBGenerationContext.is7mSB()) {
            if (n == 9) {
                angle = Angle.createAngleDegs(10.0);
            } else if (n == 10) {
                angle = Angle.createAngleDegs(8.0);
            }
        }
        return angle;
    }

    private static Angle getB10SearchRadius(@NonNull SBGenerationContext sBGenerationContext) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        Configuration configuration = QuerySourceFieldSourceWorker.getMostExtendedScheduledConfiguration(sBGenerationContext);
        int n = configuration.getNumber();
        Angle angle = Angle.createAngle((double)15.0, (String)Angle.UNIT_DEG);
        if (n >= 1 && n <= 2) {
            angle.setContent(8.0);
        } else if (n >= 3 && n <= 4) {
            angle.setContent(7.0);
        } else if (n >= 5 && n <= 6) {
            angle.setContent(6.0);
        } else if (n == 7) {
            angle.setContent(5.0);
        } else if (n == 8) {
            angle.setContent(3.0);
        } else if (n == 9) {
            angle.setContent(3.0);
        } else if (n == 10) {
            angle.setContent(2.0);
        }
        return angle;
    }

    private static Angle getB9SearchRadius(@NonNull SBGenerationContext sBGenerationContext) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        Configuration configuration = QuerySourceFieldSourceWorker.getMostExtendedScheduledConfiguration(sBGenerationContext);
        int n = configuration.getNumber();
        Angle angle = Angle.createAngle((double)15.0, (String)Angle.UNIT_DEG);
        if (n >= 1 && n <= 2) {
            angle.setContent(9.0);
        } else if (n >= 3 && n <= 4) {
            angle.setContent(8.0);
        } else if (n >= 5 && n <= 6) {
            angle.setContent(7.0);
        } else if (n == 7) {
            angle.setContent(6.0);
        } else if (n == 8) {
            angle.setContent(4.0);
        } else if (n == 9) {
            angle.setContent(4.0);
        } else if (n == 10) {
            angle.setContent(3.5);
        }
        return angle;
    }

    private static Angle getB8SearchRadius(@NonNull SBGenerationContext sBGenerationContext) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        Configuration configuration = QuerySourceFieldSourceWorker.getMostExtendedScheduledConfiguration(sBGenerationContext);
        int n = configuration.getNumber();
        Angle angle = Angle.createAngle((double)15.0, (String)Angle.UNIT_DEG);
        if (n >= 1 && n <= 4) {
            angle.setContent(9.0);
        } else if (n == 5 || n == 6) {
            angle.setContent(8.0);
        } else if (n == 7) {
            angle.setContent(7.0);
        } else if (n == 8) {
            angle.setContent(5.0);
        } else if (n == 9) {
            angle.setContent(5.0);
        } else if (n == 10) {
            angle.setContent(4.0);
        }
        return angle;
    }

    private static Angle getB7SearchRadius(@NonNull SBGenerationContext sBGenerationContext) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        @NonNull Configuration configuration = QuerySourceFieldSourceWorker.getMostExtendedScheduledConfiguration(sBGenerationContext);
        int n = configuration.getNumber();
        Angle angle = Angle.createAngle((double)15.0, (String)Angle.UNIT_DEG);
        if (n == 1 || n == 2) {
            angle.setContent(12.0);
        } else if (n == 3 || n == 4) {
            angle.setContent(11.0);
        } else if (n == 5 || n == 6) {
            angle.setContent(10.0);
        } else if (n == 7) {
            angle.setContent(7.0);
        } else if (n == 8) {
            angle.setContent(6.0);
        } else if (n >= 8 && n <= 10) {
            angle.setContent(5.0);
        }
        return angle;
    }

    private static Configuration getMostExtendedScheduledConfiguration(@NonNull SBGenerationContext sBGenerationContext) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        if (sBGenerationContext.isTM1SB()) {
            try {
                return Configuration.getConfigurationsToBeScheduled(sBGenerationContext.getGoal()).getMostExtendedTM1Configuration();
            }
            catch (Configuration.UnableToDetermineConfigurationException | InvalidObsProgramParametersException exception) {
                throw new WizardSBGenerationException("Unable to determine most extended 12-m configuration for setup: " + exception.getMessage());
            }
        }
        return sBGenerationContext.getConfiguration();
    }

    private static Angle getB1toB6SearchRadius(SBGenerationContext sBGenerationContext) {
        Angle angle = Angle.createAngle((double)15.0, (String)Angle.UNIT_DEG);
        int n = sBGenerationContext.getConfiguration().getNumber();
        if (n >= 7 && n <= 10) {
            angle.setContent(7.0);
        }
        return angle;
    }
}

