/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.losolutions;

import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.misc.ComboBoxCellEditor;
import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.editors.spectralvisual.ResourceColumnRenderer;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.losolutions.LOToolModel;
import alma.obsprep.services.losolutions.LOToolParameters;
import alma.obsprep.services.losolutions.LOToolTuningParametersEditor;
import alma.obsprep.services.losolutions.wrappers.SidebandPreferenceWrapper;
import alma.obsprep.services.losolutions.wrappers.SidebandSelectWrapper;
import alma.valuetypes.Frequency;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class LOToolEditor
extends EditorWithGridBagLayout {
    private static final String classBaseName = LOToolEditor.class.getSimpleName() + ".";
    public static final FieldID RECEIVERTYPE_FID = new FieldID(classBaseName + "receiverType");
    public static final FieldID SSBPANEL_FID = new FieldID(classBaseName + "SSBpanel");
    public static final FieldID DSBPANEL_FID = new FieldID(classBaseName + "DSBpanel");
    public static final FieldID ADDBUTTON_FID = new FieldID(classBaseName + "addButton");
    public static final FieldID DELETEBUTTON_FID = new FieldID(classBaseName + "deleteButton");
    public static final FieldID CALCBUTTON_FID = new FieldID(classBaseName + "calculateButton");
    public static final FieldID HARDWAREINFO_FID = new FieldID(classBaseName + "hardwareInfo");
    public static final FieldID REQUESTLO1_FID = new FieldID(classBaseName + "requestLO1");
    public static final FieldID LO1_VUP_FID = new FieldID(classBaseName + "LO1Frequency");
    public static final FieldID FEEDBACK_FID = new FieldID(classBaseName + "feedback");
    public static final FieldID CLOSEBUTTON_FID = new FieldID(classBaseName + "close");
    public static final FieldID RECEIVERBAND_FID = new FieldID(classBaseName + "receiverBands");
    protected Table ssbBasebandTable;
    protected Table dsbBasebandTable;
    public static final String UNDEFINED_RXB = "Unspecified";
    private static String[] selectableReceiverBands = new String[]{"Unspecified", "4", "5"};

    public LOToolEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public LOToolModel getModel() {
        return (LOToolModel)super.getModel();
    }

    @Override
    protected boolean wantGlobalButtons() {
        return false;
    }

    @Override
    protected void addComponents(String string) {
        this.constraints.weightx = 1.0;
        JPanel jPanel = this.addHardwareInfoGroup();
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Tools and Simulators-LO Configuration Tool-Hardware Info");
        jPanel = this.addSettingsGroup();
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Tools and Simulators-LO Configuration Tool-Settings");
        jPanel = this.addResultsGroup();
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Tools and Simulators-LO Configuration Tool-TuningParameters");
        this.addControlButtonBox();
    }

    private JPanel addSettingsGroup() {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.register(jPanel, SSBPANEL_FID);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, new JLabel("SSB Baseband Specs"));
        this.ssbBasebandTable = this.setupSSBBasebandTable();
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.ssbBasebandTable);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        JPanel jPanel2 = this.createNewGroup();
        GridBagLayout gridBagLayout2 = this.createNewLayout(jPanel2);
        GridBagConstraints gridBagConstraints2 = this.createNewConstraints();
        this.register(jPanel2, DSBPANEL_FID);
        this.addComponent(jPanel2, gridBagLayout2, gridBagConstraints2, new JLabel("DSB Baseband Specs"));
        this.dsbBasebandTable = this.setupDSBBasebandTable();
        scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.dsbBasebandTable);
        this.addComponent(jPanel2, gridBagLayout2, gridBagConstraints2, scrollWhenFocusedPane);
        JPanel jPanel3 = this.createNewGroup();
        GridBagLayout gridBagLayout3 = this.createNewLayout(jPanel3);
        GridBagConstraints gridBagConstraints3 = this.createNewConstraints();
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        this.addComboBox((JComponent)jPanel3, gridBagLayout3, gridBagConstraints3, RECEIVERTYPE_FID, "Receiver Type", "Receiver Type", ReceiverType.getLabels());
        JCheckBox jCheckBox = this.makeCheckBox(REQUESTLO1_FID, "Request LO1", "Check if you wish to specify LO1.");
        ValueUnitPairEditor valueUnitPairEditor = this.makeValueUnitPairEditor(this.getModel().getLO1Model(), "This value is used to calculate IF frequencies to pass the configurator.");
        valueUnitPairEditor.setEnabled(false);
        this.register(valueUnitPairEditor, LO1_VUP_FID);
        this.addComboBox((JComponent)jPanel3, gridBagLayout3, gridBagConstraints3, RECEIVERBAND_FID, "Receiver Band", "Receiver Band", selectableReceiverBands);
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(jCheckBox);
        componentCollection.remember(valueUnitPairEditor);
        this.addComponentArray(jPanel3, gridBagLayout3, gridBagConstraints3, componentCollection);
        this.addComponent(jPanel3, gridBagLayout3, gridBagConstraints3, jPanel);
        this.addComponent(jPanel3, gridBagLayout3, gridBagConstraints3, jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.makeButton(ADDBUTTON_FID, "Add", "Add a new BasebandSpec"));
        jPanel4.add(this.makeButton(DELETEBUTTON_FID, "Delete", "Delete selected BasebandSpec"));
        this.addComponent(jPanel3, gridBagLayout3, gridBagConstraints3, jPanel4);
        this.addButton(jPanel3, gridBagLayout3, gridBagConstraints3, CALCBUTTON_FID, "Calculate LOs", "Calculate LO setup");
        JTextArea jTextArea = new JTextArea(3, 50);
        jTextArea.setForeground(Color.red);
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setBorder(BorderFactory.createTitledBorder("Message"));
        this.initEvents(jTextArea, FEEDBACK_FID);
        this.addComponent(jPanel3, gridBagLayout3, gridBagConstraints3, jTextArea);
        return this.addGroup(jPanel3, "Settings");
    }

    private JPanel addHardwareInfoGroup() {
        JLabel jLabel = new JLabel();
        this.initEvents(jLabel, HARDWAREINFO_FID);
        return this.addGroup(jLabel, "Hardware Info");
    }

    private Table setupSSBBasebandTable() {
        Table table = new Table(this.getModel().getSSBTableModel()){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = this.getSelectedRow();
                super.tableChanged(tableModelEvent);
                if (n < this.getRowCount() && n >= 0) {
                    this.setRowSelectionInterval(n, n);
                }
            }
        };
        table.getTableHeader().setReorderingAllowed(false);
        table.setDefaultRenderer(Object.class, new ResourceColumnRenderer());
        table.setDefaultRenderer(Double.class, new ResourceColumnRenderer());
        table.getSelectionModel().setSelectionMode(0);
        table.setDefaultEditor(Frequency.class, new ValueUnitPairCellEditor.FrequencyEditor());
        Dimension dimension = new Dimension(400, 64);
        table.setMinimumSize(dimension);
        table.setPreferredSize(dimension);
        table.setPreferredScrollableViewportSize(dimension);
        int n = LOToolModel.SSBbasebandSpecTableColumnDescriptor.SIDEBAND_PREF.ordinal();
        TableColumn tableColumn = table.getColumnModel().getColumn(n);
        JComboBox<SidebandPreferenceWrapper> jComboBox = new JComboBox<SidebandPreferenceWrapper>(SidebandPreferenceWrapper.values());
        ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor((JComboBox)jComboBox);
        comboBoxCellEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(comboBoxCellEditor);
        n = LOToolModel.SSBbasebandSpecTableColumnDescriptor.WEIGHT.ordinal();
        tableColumn = table.getColumnModel().getColumn(n);
        JComboBox<Double> jComboBox2 = new JComboBox<Double>(new Double[]{100.0, 50.0, 0.0});
        comboBoxCellEditor = new ComboBoxCellEditor((JComboBox)jComboBox2);
        comboBoxCellEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(comboBoxCellEditor);
        n = LOToolModel.SSBbasebandSpecTableColumnDescriptor.SKY_FREQUENCY.ordinal();
        tableColumn = table.getColumnModel().getColumn(n);
        tableColumn.setCellEditor(new ValueUnitPairCellEditor.FrequencyEditor(true));
        ColumnResizer.initColumnSizes(table, this.getModel().getSSBTableModel().getLongValues());
        return table;
    }

    private Table setupDSBBasebandTable() {
        Table table = new Table(this.getModel().getDSBTableModel()){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = this.getSelectedRow();
                super.tableChanged(tableModelEvent);
                if (n < this.getRowCount() && n >= 0) {
                    this.setRowSelectionInterval(n, n);
                }
            }
        };
        table.getTableHeader().setReorderingAllowed(false);
        table.setDefaultRenderer(Object.class, new ResourceColumnRenderer());
        table.setDefaultRenderer(Double.class, new ResourceColumnRenderer());
        table.getSelectionModel().setSelectionMode(0);
        table.setDefaultEditor(Frequency.class, new ValueUnitPairCellEditor.FrequencyEditor());
        Dimension dimension = new Dimension(600, 64);
        table.setMinimumSize(dimension);
        table.setPreferredSize(dimension);
        table.setPreferredScrollableViewportSize(dimension);
        int n = LOToolModel.DSBbasebandSpecTableColumnDescriptor.SIDEBANDSELECT.ordinal();
        TableColumn tableColumn = table.getColumnModel().getColumn(n);
        JComboBox<SidebandSelectWrapper> jComboBox = new JComboBox<SidebandSelectWrapper>(SidebandSelectWrapper.values());
        ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor((JComboBox)jComboBox);
        comboBoxCellEditor.setClickCountToStart(2);
        tableColumn.setCellEditor(comboBoxCellEditor);
        JComboBox<Double> jComboBox2 = new JComboBox<Double>(new Double[]{100.0, 50.0, 0.0});
        comboBoxCellEditor = new ComboBoxCellEditor((JComboBox)jComboBox2);
        comboBoxCellEditor.setClickCountToStart(2);
        n = LOToolModel.DSBbasebandSpecTableColumnDescriptor.WEIGHT_1.ordinal();
        tableColumn = table.getColumnModel().getColumn(n);
        tableColumn.setCellEditor(comboBoxCellEditor);
        n = LOToolModel.DSBbasebandSpecTableColumnDescriptor.WEIGHT_2.ordinal();
        tableColumn = table.getColumnModel().getColumn(n);
        tableColumn.setCellEditor(comboBoxCellEditor);
        n = LOToolModel.DSBbasebandSpecTableColumnDescriptor.SKY_FREQUENCY_1.ordinal();
        tableColumn = table.getColumnModel().getColumn(n);
        tableColumn.setCellEditor(new ValueUnitPairCellEditor.FrequencyEditor(true));
        n = LOToolModel.DSBbasebandSpecTableColumnDescriptor.SKY_FREQUENCY_2.ordinal();
        tableColumn = table.getColumnModel().getColumn(n);
        tableColumn.setCellEditor(new ValueUnitPairCellEditor.FrequencyEditor(true));
        ColumnResizer.initColumnSizes(table, this.getModel().getDSBTableModel().getLongValues());
        return table;
    }

    private JPanel addResultsGroup() {
        LOToolTuningParametersEditor lOToolTuningParametersEditor = new LOToolTuningParametersEditor(this.getModel().getTuningParametersModel());
        this.addComponent(lOToolTuningParametersEditor);
        return lOToolTuningParametersEditor;
    }

    private void addControlButtonBox() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.makeButton(CLOSEBUTTON_FID, "Close", "Close this window"), "East");
        this.addComponent(jPanel);
    }

    @Override
    protected void build() {
        super.build("OT Losolution Parameters");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == ADDBUTTON_FID || fieldID == DELETEBUTTON_FID) {
            this.setButtons();
            return;
        }
        if (fieldID == CALCBUTTON_FID) {
            return;
        }
        if (fieldID == HARDWAREINFO_FID) {
            String string = "<html><pre>" + (String)object + "</pre></html>";
            super.update(fieldID, string);
            return;
        }
        if (fieldID == RECEIVERTYPE_FID) {
            ReceiverType receiverType;
            if (object instanceof String) {
                String string = (String)object;
                receiverType = ReceiverType.getItem(string);
            } else if (object instanceof Boolean) {
                receiverType = ReceiverType.getItem((Boolean)object);
            } else {
                throw new IllegalArgumentException(object.getClass() + " is not expected.");
            }
            this.getComponent(RECEIVERBAND_FID).setEnabled(!receiverType.isDsb);
            this.updateBasebandTablePanel(receiverType.isDsb);
            super.update(fieldID, receiverType.label);
            this.setButtons();
            return;
        }
        if (fieldID == REQUESTLO1_FID) {
            boolean bl = (Boolean)object;
            this.getComponent(LO1_VUP_FID).setEnabled(bl);
            super.update(fieldID, object);
            return;
        }
        if (fieldID == CLOSEBUTTON_FID) {
            this.getRootPane().getParent().setVisible(false);
            return;
        }
        super.update(fieldID, object);
    }

    private void updateBasebandTablePanel(boolean bl) {
        this.ssbBasebandTable.clearSelection();
        this.dsbBasebandTable.clearSelection();
        JPanel jPanel = (JPanel)this.getComponent(SSBPANEL_FID);
        JPanel jPanel2 = (JPanel)this.getComponent(DSBPANEL_FID);
        jPanel.setVisible(!bl);
        jPanel2.setVisible(bl);
    }

    public int getSelectedRow() {
        JPanel jPanel = (JPanel)this.getComponent(SSBPANEL_FID);
        if (jPanel.isVisible()) {
            return this.ssbBasebandTable.getSelectedRow();
        }
        return this.dsbBasebandTable.getSelectedRow();
    }

    public void setButtons() {
        JButton jButton = (JButton)this.getComponent(ADDBUTTON_FID);
        JButton jButton2 = (JButton)this.getComponent(DELETEBUTTON_FID);
        this.setEnabled(jButton, true);
        this.setEnabled(jButton2, true);
        LOToolParameters lOToolParameters = this.getModel().getLOToolParameters();
        int n = lOToolParameters.getBasebandParametersCount();
        if (n == 0) {
            this.setEnabled(jButton2, false);
        } else if (n == 4) {
            this.setEnabled(jButton, false);
        }
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        LOToolModel lOToolModel = new LOToolModel(null);
        LOToolEditor lOToolEditor = new LOToolEditor(lOToolModel);
        LOToolParameters lOToolParameters = new LOToolParameters();
        lOToolModel.setDocument(lOToolParameters);
        LOToolEditor.runTestApp(lOToolEditor);
    }

    public static enum ReceiverType {
        SSB("Band1(USB),Band2(LSB),Band3-8(2SB)", false),
        DSB("Band9,10(DSB)", true);

        String label;
        boolean isDsb;

        public static ReceiverType getItem(String string) {
            for (ReceiverType receiverType : ReceiverType.values()) {
                if (!receiverType.label.equals(string)) continue;
                return receiverType;
            }
            return null;
        }

        public static ReceiverType getItem(boolean bl) {
            return bl ? DSB : SSB;
        }

        public static String[] getLabels() {
            String[] stringArray = new String[ReceiverType.values().length];
            for (int i = 0; i < ReceiverType.values().length; ++i) {
                stringArray[i] = ReceiverType.values()[i].label;
            }
            return stringArray;
        }

        private ReceiverType(String string2, boolean bl) {
            this.label = string2;
            this.isDsb = bl;
        }
    }
}

