/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.losolutions;

import alma.Control.DSBbasebandSpec;
import alma.Control.LO2Parameters;
import alma.Control.LOSolutions.LOSolutions;
import alma.Control.LOSolutions.LOSolutionsInterface;
import alma.Control.LOSolutions.SidebandSelect;
import alma.Control.SSBbasebandSpec;
import alma.Control.TuningParameters;
import alma.ReceiverBandMod.ReceiverBand;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.ReceiverType;
import alma.obsprep.services.losolutions.LOSolutionException;
import alma.obsprep.services.losolutions.LOToolParameters;
import alma.obsprep.services.losolutions.wrappers.AbstractBasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.DSBbasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.SSBbasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.SidebandSelectWrapper;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import lombok.NonNull;

public class OTLOsolutions {
    private final Set<alma.obsprep.bo.schedblock.ReceiverBand> band2and3 = new HashSet<alma.obsprep.bo.schedblock.ReceiverBand>(alma.obsprep.bo.schedblock.ReceiverBand.getReceiverBands(3, 2));
    private final LOSolutionsInterface loSolutions;
    private final LOToolParameters loToolParameters;
    private static final double BasebandBW = 2.0E9;
    private static final double BandOffset = 9.999999999E8;
    private static final double DigitizerFreq = 4.0E9;
    private TuningParameters tuningParameters;

    private OTLOsolutions(Logger logger) {
        this.loSolutions = new LOSolutions(logger);
        this.loToolParameters = new LOToolParameters();
    }

    private OTLOsolutions() {
        this((Logger)Log.logger(OTLOsolutions.class));
    }

    public static OTLOsolutions createOTLOsolutions() {
        return new OTLOsolutions();
    }

    public void setBasebandCenterFrequencies(Frequency[] frequencyArray, Velocity velocity, alma.obsprep.bo.schedblock.ReceiverBand receiverBand) throws LOSolutionException {
        if (receiverBand == null) {
            throw new LOSolutionException("rxb must be specified");
        }
        if (frequencyArray == null || frequencyArray.length == 0) {
            throw new LOSolutionException("At least one frequency is needed.");
        }
        Frequency[] frequencyArray2 = new Frequency[frequencyArray.length];
        for (int i = 0; i < frequencyArray.length; ++i) {
            frequencyArray2[i] = frequencyArray[i].dopplerShifted(velocity);
        }
        this.loToolParameters.clearBasebandParameters();
        this.loToolParameters.setDsbReceiver(ReceiverType.getReceiverType(receiverBand.getType()) == ReceiverType.DSB);
        for (Frequency frequency : frequencyArray2) {
            AbstractBasebandSpecWrapper abstractBasebandSpecWrapper = this.loToolParameters.addNewBasebandParameters();
            abstractBasebandSpecWrapper.setOneSkyFrequency(frequency);
        }
    }

    public TuningParameters computeSolutions(alma.obsprep.bo.schedblock.ReceiverBand receiverBand) throws LOSolutionException {
        return this.computeSolutions(this.loToolParameters.getLOSBasebandSpecList(), Optional.of(receiverBand));
    }

    public TuningParameters computeSolutions(@NonNull List<AbstractBasebandSpecWrapper> list, @NonNull Optional<alma.obsprep.bo.schedblock.ReceiverBand> optional) throws LOSolutionException {
        if (list == null) {
            throw new NullPointerException("basebands is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("receiverBand is marked non-null but is null");
        }
        for (AbstractBasebandSpecWrapper abstractBasebandSpecWrapper : list) {
            Frequency frequency;
            AbstractBasebandSpecWrapper abstractBasebandSpecWrapper2;
            Frequency frequency2 = Frequency.createFrequencyGHZ(0.0);
            if (abstractBasebandSpecWrapper instanceof DSBbasebandSpecWrapper) {
                abstractBasebandSpecWrapper2 = (DSBbasebandSpecWrapper)abstractBasebandSpecWrapper;
                frequency = ((DSBbasebandSpecWrapper)abstractBasebandSpecWrapper2).getPrimarySpec().getSkyFrequency();
                if (frequency.isLessThan((AbstractDoubleWithUnit)frequency2) || frequency.isZero(0.1)) {
                    ((DSBbasebandSpecWrapper)abstractBasebandSpecWrapper2).getPrimarySpec().setWeight(0.0);
                }
                if (!(frequency = ((DSBbasebandSpecWrapper)abstractBasebandSpecWrapper2).getSubSpec().getSkyFrequency()).isLessThan((AbstractDoubleWithUnit)frequency2) && !frequency.isZero(0.1)) continue;
                ((DSBbasebandSpecWrapper)abstractBasebandSpecWrapper2).getSubSpec().setWeight(0.0);
                continue;
            }
            if (abstractBasebandSpecWrapper instanceof SSBbasebandSpecWrapper) {
                abstractBasebandSpecWrapper2 = (SSBbasebandSpecWrapper)abstractBasebandSpecWrapper;
                frequency = ((SSBbasebandSpecWrapper)abstractBasebandSpecWrapper2).getSkyFrequency();
                if (!frequency.isLessThan((AbstractDoubleWithUnit)frequency2) && !frequency.isZero(0.1)) continue;
                ((SSBbasebandSpecWrapper)abstractBasebandSpecWrapper2).setWeight(0.0);
                continue;
            }
            throw new RuntimeException("Unknown type of BB wrapper defined : " + abstractBasebandSpecWrapper.getClass().getName());
        }
        this.tuningParameters = null;
        if (list.size() == 0 || list.get(0) instanceof SSBbasebandSpecWrapper) {
            this.computeSSBSolution(list, optional);
        } else {
            this.computeDSBSolution(list);
        }
        return this.tuningParameters;
    }

    private void computeDSBSolution(List<AbstractBasebandSpecWrapper> list) throws LOSolutionException {
        ArrayList<DSBbasebandSpec> arrayList = new ArrayList<DSBbasebandSpec>();
        for (AbstractBasebandSpecWrapper abstractBasebandSpecWrapper : list) {
            DSBbasebandSpecWrapper dSBbasebandSpecWrapper = (DSBbasebandSpecWrapper)abstractBasebandSpecWrapper;
            arrayList.add(dSBbasebandSpecWrapper.exportNativeBasebandSpec());
        }
        try {
            this.tuningParameters = this.loSolutions.computeDSBSolution(arrayList);
        }
        catch (Exception exception) {
            throw new LOSolutionException(exception.getMessage(), exception);
        }
    }

    private void computeSSBSolution(List<AbstractBasebandSpecWrapper> list, Optional<alma.obsprep.bo.schedblock.ReceiverBand> optional) throws LOSolutionException {
        Set<alma.obsprep.bo.schedblock.ReceiverBand> set = alma.obsprep.bo.schedblock.ReceiverBand.getReceiverBands(list.stream().map(abstractBasebandSpecWrapper -> ((SSBbasebandSpecWrapper)abstractBasebandSpecWrapper).getSkyFrequency()).toList());
        boolean bl = set.equals(this.band2and3);
        ArrayList<SSBbasebandSpec> arrayList = new ArrayList<SSBbasebandSpec>();
        for (AbstractBasebandSpecWrapper object : list) {
            SSBbasebandSpecWrapper sSBbasebandSpecWrapper = (SSBbasebandSpecWrapper)object;
            arrayList.add(sSBbasebandSpecWrapper.exportNativeBasebandSpec());
        }
        try {
            if (bl) {
                this.tuningParameters = this.loSolutions.computeSSBSolution(arrayList, ReceiverBand.ALMA_RB_03);
            } else if (optional.isPresent()) {
                alma.obsprep.bo.schedblock.ReceiverBand receiverBand = optional.get();
                if (!receiverBand.equals(alma.obsprep.bo.schedblock.ReceiverBand.ILLEGAL_RECEIVER)) {
                    ReceiverBand receiverBand2 = ReceiverBand.from_int((int)(receiverBand.getNumber() - 1));
                    this.tuningParameters = this.loSolutions.computeSSBSolution(arrayList, receiverBand2);
                } else {
                    this.tuningParameters = this.loSolutions.computeSSBSolution(arrayList);
                }
            } else {
                this.tuningParameters = this.loSolutions.computeSSBSolution(arrayList);
            }
        }
        catch (Exception exception) {
            throw new LOSolutionException(exception.getMessage(), exception);
        }
    }

    public Frequency getPreferredLO1FrequencySky() {
        return this.tuningParameters != null ? Frequency.createFrequencyGHZ(this.LO1Freq(this.tuningParameters) / 1.0E9) : null;
    }

    public double LO1Freq(TuningParameters tuningParameters) {
        return this.loSolutions.LO1Freq(tuningParameters);
    }

    public double getLO2Freq(LO2Parameters lO2Parameters) {
        return LOSolutions.getLO2Freq((LO2Parameters)lO2Parameters);
    }

    public double IFfrequency(LO2Parameters lO2Parameters) {
        double d = this.getLO2Freq(lO2Parameters);
        return d - 4.0E9 + 9.999999999E8;
    }

    public double actualSkyFreq(TuningParameters tuningParameters, int n, SidebandSelectWrapper sidebandSelectWrapper) throws Exception {
        return LOSolutions.actualSkyFreq((TuningParameters)tuningParameters, (int)n, (SidebandSelect)sidebandSelectWrapper.getNativeSidebandSelect());
    }

    public String getHardwareParameters() throws Exception {
        return this.loSolutions.getHardwareParameters();
    }
}

