/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.sfi;

import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.mvc.ContextSwitchInterface;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.MultipageViewException;
import alma.obsprep.ot.boEditors.MultiPageEditor;
import alma.obsprep.ot.editors.obsproject.CalibrationSetupParametersEditor;
import alma.obsprep.ot.editors.sciencegoals.FieldSetupEditor;
import alma.obsprep.ot.editors.sciencegoals.SfiControlParameterEditor;
import alma.obsprep.ot.editors.sciencegoals.SfiSpectralSetupEditor;
import alma.obsprep.ot.editors.sciencegoals.SgNoteEditor;
import alma.obsprep.ot.editors.sciencegoals.TechnicalJustificationEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.obsproject.RectangleModel;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationModel;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.valuetypes.Speed;
import java.awt.Component;
import java.util.List;
import javax.help.CSH;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class SingleFieldScienceGoalEditor
extends MultiPageEditor {
    private static final long serialVersionUID = -6769486630034767127L;
    private final SfiControlParameterEditor controlParameterEditor;
    private final FieldSetupEditor fieldSetupEditor;
    private final SfiSpectralSetupEditor spectralEditor;
    private List<Editor> editorlist = null;
    private final CalibrationSetupParametersEditor calibrationSetupParametersEditor;

    @Override
    public void finalizeUserEdits() {
        assert (this.editorlist != null);
        this.editorlist.forEach(ContextSwitchInterface::finalizeUserEdits);
    }

    public SingleFieldScienceGoalEditor(SingleFieldScienceGoalModel singleFieldScienceGoalModel) {
        super(singleFieldScienceGoalModel);
        SgNoteEditor sgNoteEditor = new SgNoteEditor(singleFieldScienceGoalModel.getSgNoteModel(), true);
        this.fieldSetupEditor = new FieldSetupEditor(singleFieldScienceGoalModel.getSgFieldSetupModel(), false, false);
        this.fieldSetupEditor.setName("SingleFieldScienceGoalEditor.FieldSetupEditor");
        this.spectralEditor = new SfiSpectralSetupEditor(singleFieldScienceGoalModel.getSpectralSetupParametersModel());
        SfiControlParameterModel sfiControlParameterModel = singleFieldScienceGoalModel.getSfiControlParameterModel();
        this.controlParameterEditor = new SfiControlParameterEditor(sfiControlParameterModel, false);
        this.calibrationSetupParametersEditor = new CalibrationSetupParametersEditor(singleFieldScienceGoalModel);
        TechnicalJustificationEditor technicalJustificationEditor = new TechnicalJustificationEditor(singleFieldScienceGoalModel.getTechnicalJustificationModel(), true);
        this.editorlist = List.of(sgNoteEditor, this.fieldSetupEditor, this.spectralEditor, this.controlParameterEditor, this.calibrationSetupParametersEditor, technicalJustificationEditor);
        this.registerSubView(sgNoteEditor);
        this.registerSubView(this.fieldSetupEditor);
        this.registerSubView(this.spectralEditor);
        this.registerSubView(this.controlParameterEditor);
        this.registerSubView(this.calibrationSetupParametersEditor);
        this.registerSubView(technicalJustificationEditor);
        CSH.setHelpIDString((Component)sgNoteEditor, (String)"TOC-Phase 1 and Phase 2 Science Goals-General");
        CSH.setHelpIDString((Component)this.fieldSetupEditor, (String)"TOC-Phase 1 and Phase 2 Science Goals-Field Setup");
        CSH.setHelpIDString((Component)this.spectralEditor, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup");
        CSH.setHelpIDString((Component)this.calibrationSetupParametersEditor, (String)"TOC-Phase 1 and Phase 2 Science Goals-Calibration Setup");
        CSH.setHelpIDString((Component)technicalJustificationEditor, (String)"TOC-Phase 1 and Phase 2 Science Goals-Technical Justification");
        MultiPageEditor.PagePanel pagePanel = this.addPage(sgNoteEditor, new MultiPageEditor.PageDescriptor("General"), new String[]{"Enter a name and description for the purpose of this science goal.", "This text is optional but you may find it useful to keep a note."});
        CSH.setHelpIDString((Component)pagePanel, (String)"TOC-Phase 1 and Phase 2 Science Goals-General");
        pagePanel = this.addPage(this.fieldSetupEditor, new MultiPageEditor.PageDescriptor("Field Setup"), new String[]{"Input source details and mapping info or use the Visual Editor on the spatial tab.", "You must choose between checking 1 Rectangular Field on all sources or none.", "Check 1 Rectangular Field on the first source before adding others to put rectangular mosaics around multiple sources."});
        CSH.setHelpIDString((Component)pagePanel, (String)"TOC-Phase 1 and Phase 2 Science Goals-Field Setup");
        pagePanel = AlmaCapabilities.getInstance().getMaxNumberSw() == 4 ? this.addPage(this.spectralEditor, new MultiPageEditor.PageDescriptor("Spectral Setup"), new String[]{"In the table below, it is possible to define up to four spectral windows, one per baseband.", "Each baseband is 2GHz wide and can be separately configured i.e. each spectral window can have a different bandwidth and resolution.", "Note that for bands 3 to 8, it is not possible to put 3 basebands in one sideband and the fourth one in the other."}) : this.addPage(this.spectralEditor, new MultiPageEditor.PageDescriptor("Spectral Setup"), new String[]{"In the table below, it is possible to define up to 16 spectral windows, 4 per baseband as long as the total fraction per baseband is no more than 1.", "Each baseband is 2GHz wide and can be separately configured i.e. each spectral window can have a different bandwidth and resolution.", "Note that for bands 3 to 8, it is not possible to put 3 basebands in one sideband and the fourth one in the other."});
        CSH.setHelpIDString((Component)pagePanel, (String)"TOC-Phase 1 and Phase 2 Science Goals-Spectral Setup");
        pagePanel = this.addPage(this.calibrationSetupParametersEditor, new MultiPageEditor.PageDescriptor("Calibration Setup"), new String[]{"Select calibration strategy."});
        CSH.setHelpIDString((Component)pagePanel, (String)"TOC-Phase 1 and Phase 2 Science Goals-Calibration Setup");
        pagePanel = this.addPage(this.controlParameterEditor, new MultiPageEditor.PageDescriptor("Control and Performance"), new String[]{"These parameters are used to control various aspects of the observations, including the required antenna configurations and integration times."});
        CSH.setHelpIDString((Component)pagePanel, (String)"TOC-Phase 1 and Phase 2 Science Goals-Control and Performance");
        pagePanel = this.addPage(technicalJustificationEditor, new MultiPageEditor.PageDescriptor("Technical Justification"), new String[]{"Enter a Technical Justification for this Science Goal, paying special attention to the parameters reproduced below."});
        pagePanel.setVisibleInMultiView(false);
        CSH.setHelpIDString((Component)pagePanel, (String)"TOC-Phase 1 and Phase 2 Science Goals-Technical Justification");
        this.fieldSetupEditor.getModel().getTargetParametersModel().subscribe(this.controlParameterEditor);
        RectangleModel rectangleModel = singleFieldScienceGoalModel.getSgFieldSetupModel().getTargetParametersModel().getFieldModel().getRectangleModel();
        sfiControlParameterModel.subscribe(rectangleModel.getAcaEnabledUpdater());
        PointingPatternModel pointingPatternModel = singleFieldScienceGoalModel.getSgFieldSetupModel().getTargetParametersModel().getFieldModel().getPointingPatternModel();
        sfiControlParameterModel.subscribe(pointingPatternModel.getAcaStatusUpdater());
        this.fieldSetupEditor.getModel().getTargetParametersModel().subscribe(rectangleModel.getUpdaterFor12mPointings());
    }

    @Override
    public void showAllPageInOneView(boolean bl) {
        super.showAllPageInOneView(bl);
        if (bl) {
            SingleFieldScienceGoalModel singleFieldScienceGoalModel = (SingleFieldScienceGoalModel)this.getModel();
            TechnicalJustificationModel technicalJustificationModel = singleFieldScienceGoalModel.getTechnicalJustificationModel();
            technicalJustificationModel.setDocument(technicalJustificationModel.getDocument());
        }
    }

    @Override
    public void displayPageNumber(int n) throws MultipageViewException {
        if ("Technical Justification".equals(this.getPageName(n))) {
            SingleFieldScienceGoalModel singleFieldScienceGoalModel = (SingleFieldScienceGoalModel)this.getModel();
            singleFieldScienceGoalModel.getTechnicalJustificationModel().publish();
        }
        super.displayPageNumber(n);
    }

    @Override
    public void editorSelected(Object object) {
        this.spectralEditor.editorSelected(object);
    }

    @Override
    public Object getEditorUnselectedInfo() {
        return this.spectralEditor.getEditorUnselectedInfo();
    }

    public static void main(String[] stringArray) throws Exception {
        for (UIManager.LookAndFeelInfo object2 : UIManager.getInstalledLookAndFeels()) {
            if (!"Metal".equals(object2.getName())) continue;
            UIManager.setLookAndFeel(object2.getClassName());
            break;
        }
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("Single Field Spectral Setup Editor");
        jFrame.setDefaultCloseOperation(3);
        ObsProject obsProject = ObsProject.createObsProject();
        ObsProposal obsProposal = ObsProposal.createObsProposal();
        obsProject.setObsProposal(obsProposal);
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        obsProposal.addAbstractScienceGoal((AbstractScienceGoal)((Object)scienceGoal));
        scienceGoal.getKeyTargetParameters().getSourceVelocity().getCenterVelocity().setContentAndUnit(1000.0, Speed.UNIT_KM_S);
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        spectralSetupParameters.setPolarisation(SpectralSetupParameters.POLARISATION_DOUBLE);
        spectralSetupParameters.clearAbstractScienceSpectralWindow();
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow(88.6316, "HCN v=0 J=1-0", 62.5, 0.06103515625);
        ScienceSpectralWindow scienceSpectralWindow2 = ScienceSpectralWindow.createScienceSpectralWindow(89.18853, "HCO+ v=0 1-0", 62.5, 0.06103515625);
        ScienceSpectralWindow scienceSpectralWindow3 = ScienceSpectralWindow.createScienceSpectralWindow(89.48741000000001, "HOC+ v=0 1-0", 62.5, 0.06103515625);
        scienceSpectralWindow.setGroupResourceUse(ScienceSpectralWindow.GROUPRESOURCEUSE_QUARTER);
        scienceSpectralWindow2.setGroupResourceUse(ScienceSpectralWindow.GROUPRESOURCEUSE_QUARTER);
        scienceSpectralWindow3.setGroupResourceUse(ScienceSpectralWindow.GROUPRESOURCEUSE_QUARTER);
        ScienceSpectralWindow scienceSpectralWindow4 = ScienceSpectralWindow.createScienceSpectralWindow(102.21757000000001, "NH2CHO 2(1,2)-1(0,1)", 62.5, 0.030517578125000003);
        ScienceSpectralWindow scienceSpectralWindow5 = ScienceSpectralWindow.createScienceSpectralWindow(102.58748, "CF+ v=0 1-0", 62.5, 0.030517578125000003);
        scienceSpectralWindow4.setGroupResourceUse(ScienceSpectralWindow.GROUPRESOURCEUSE_HALF);
        scienceSpectralWindow5.setGroupResourceUse(ScienceSpectralWindow.GROUPRESOURCEUSE_HALF);
        spectralSetupParameters.addScienceSpectralWindow(0, 0, scienceSpectralWindow);
        spectralSetupParameters.addScienceSpectralWindow(0, 1, scienceSpectralWindow2);
        spectralSetupParameters.addScienceSpectralWindow(0, 2, scienceSpectralWindow3);
        spectralSetupParameters.addScienceSpectralWindow(1, 0, scienceSpectralWindow4);
        spectralSetupParameters.addScienceSpectralWindow(1, 1, scienceSpectralWindow5);
        spectralSetupParameters.setType(SpectralSetupParameters.TYPE_FULL);
        SingleFieldScienceGoalModel singleFieldScienceGoalModel = new SingleFieldScienceGoalModel(null);
        SingleFieldScienceGoalEditor singleFieldScienceGoalEditor = new SingleFieldScienceGoalEditor(singleFieldScienceGoalModel);
        singleFieldScienceGoalModel.setDocument(scienceGoal);
        singleFieldScienceGoalEditor.showAllPageInOneView(true);
        TestUtilities.runTestApp(singleFieldScienceGoalEditor);
    }

    public SfiControlParameterEditor getControlParameterEditor() {
        return this.controlParameterEditor;
    }

    public FieldSetupEditor getFieldSetupEditor() {
        return this.fieldSetupEditor;
    }

    public SfiSpectralSetupEditor getSpectralEditor() {
        return this.spectralEditor;
    }

    public CalibrationSetupParametersEditor getCalibrationSetupParametersEditor() {
        return this.calibrationSetupParametersEditor;
    }
}

